<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Notification_Channel_MessageType StructType
 * Meta information extracted from the WSDL
 * - documentation: Enter values for configured Notification Channels.
 * @subpackage Structs
 */
class Notification_Channel_MessageType extends AbstractStructBase
{
    /**
     * The Email_Display_Name
     * Meta information extracted from the WSDL
     * - documentation: Display Name for Email Notification.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email_Display_Name;
    /**
     * The Email_Reply_To
     * Meta information extracted from the WSDL
     * - documentation: Reply To field for email notification.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email_Reply_To;
    /**
     * The Email_Subject
     * Meta information extracted from the WSDL
     * - documentation: Email Subject.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email_Subject;
    /**
     * The Email_Body
     * Meta information extracted from the WSDL
     * - documentation: Email Body.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email_Body;
    /**
     * The Push_Notification_Message
     * Meta information extracted from the WSDL
     * - documentation: Push Notification Message.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Push_Notification_Message;
    /**
     * The SMS_Message
     * Meta information extracted from the WSDL
     * - documentation: SMS Message
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SMS_Message;
    /**
     * Constructor method for Notification_Channel_MessageType
     * @uses Notification_Channel_MessageType::setEmail_Display_Name()
     * @uses Notification_Channel_MessageType::setEmail_Reply_To()
     * @uses Notification_Channel_MessageType::setEmail_Subject()
     * @uses Notification_Channel_MessageType::setEmail_Body()
     * @uses Notification_Channel_MessageType::setPush_Notification_Message()
     * @uses Notification_Channel_MessageType::setSMS_Message()
     * @param string $email_Display_Name
     * @param string $email_Reply_To
     * @param string $email_Subject
     * @param string $email_Body
     * @param string $push_Notification_Message
     * @param string $sMS_Message
     */
    public function __construct($email_Display_Name = null, $email_Reply_To = null, $email_Subject = null, $email_Body = null, $push_Notification_Message = null, $sMS_Message = null)
    {
        $this
            ->setEmail_Display_Name($email_Display_Name)
            ->setEmail_Reply_To($email_Reply_To)
            ->setEmail_Subject($email_Subject)
            ->setEmail_Body($email_Body)
            ->setPush_Notification_Message($push_Notification_Message)
            ->setSMS_Message($sMS_Message);
    }
    /**
     * Get Email_Display_Name value
     * @return string|null
     */
    public function getEmail_Display_Name()
    {
        return $this->Email_Display_Name;
    }
    /**
     * Set Email_Display_Name value
     * @param string $email_Display_Name
     * @return \StructType\Notification_Channel_MessageType
     */
    public function setEmail_Display_Name($email_Display_Name = null)
    {
        // validation for constraint: string
        if (!is_null($email_Display_Name) && !is_string($email_Display_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email_Display_Name, true), gettype($email_Display_Name)), __LINE__);
        }
        $this->Email_Display_Name = $email_Display_Name;
        return $this;
    }
    /**
     * Get Email_Reply_To value
     * @return string|null
     */
    public function getEmail_Reply_To()
    {
        return $this->Email_Reply_To;
    }
    /**
     * Set Email_Reply_To value
     * @param string $email_Reply_To
     * @return \StructType\Notification_Channel_MessageType
     */
    public function setEmail_Reply_To($email_Reply_To = null)
    {
        // validation for constraint: string
        if (!is_null($email_Reply_To) && !is_string($email_Reply_To)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email_Reply_To, true), gettype($email_Reply_To)), __LINE__);
        }
        $this->Email_Reply_To = $email_Reply_To;
        return $this;
    }
    /**
     * Get Email_Subject value
     * @return string|null
     */
    public function getEmail_Subject()
    {
        return $this->Email_Subject;
    }
    /**
     * Set Email_Subject value
     * @param string $email_Subject
     * @return \StructType\Notification_Channel_MessageType
     */
    public function setEmail_Subject($email_Subject = null)
    {
        // validation for constraint: string
        if (!is_null($email_Subject) && !is_string($email_Subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email_Subject, true), gettype($email_Subject)), __LINE__);
        }
        $this->Email_Subject = $email_Subject;
        return $this;
    }
    /**
     * Get Email_Body value
     * @return string|null
     */
    public function getEmail_Body()
    {
        return $this->Email_Body;
    }
    /**
     * Set Email_Body value
     * @param string $email_Body
     * @return \StructType\Notification_Channel_MessageType
     */
    public function setEmail_Body($email_Body = null)
    {
        // validation for constraint: string
        if (!is_null($email_Body) && !is_string($email_Body)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email_Body, true), gettype($email_Body)), __LINE__);
        }
        $this->Email_Body = $email_Body;
        return $this;
    }
    /**
     * Get Push_Notification_Message value
     * @return string|null
     */
    public function getPush_Notification_Message()
    {
        return $this->Push_Notification_Message;
    }
    /**
     * Set Push_Notification_Message value
     * @param string $push_Notification_Message
     * @return \StructType\Notification_Channel_MessageType
     */
    public function setPush_Notification_Message($push_Notification_Message = null)
    {
        // validation for constraint: string
        if (!is_null($push_Notification_Message) && !is_string($push_Notification_Message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($push_Notification_Message, true), gettype($push_Notification_Message)), __LINE__);
        }
        $this->Push_Notification_Message = $push_Notification_Message;
        return $this;
    }
    /**
     * Get SMS_Message value
     * @return string|null
     */
    public function getSMS_Message()
    {
        return $this->SMS_Message;
    }
    /**
     * Set SMS_Message value
     * @param string $sMS_Message
     * @return \StructType\Notification_Channel_MessageType
     */
    public function setSMS_Message($sMS_Message = null)
    {
        // validation for constraint: string
        if (!is_null($sMS_Message) && !is_string($sMS_Message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sMS_Message, true), gettype($sMS_Message)), __LINE__);
        }
        $this->SMS_Message = $sMS_Message;
        return $this;
    }
}
