<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Multiple_Choice_Answer_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains multiple choice answer data.
 * @subpackage Structs
 */
class Multiple_Choice_Answer_DataType extends AbstractStructBase
{
    /**
     * The Multiple_Choice_Answer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the multiple choice answer.
     * - choice: Multiple_Choice_Answer_Reference | Multiple_Choice_Answer_Text
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Question_Multiple_Choice_AnswerObjectType
     */
    public $Multiple_Choice_Answer_Reference;
    /**
     * The Multiple_Choice_Answer_Text
     * Meta information extracted from the WSDL
     * - documentation: Text of the multiple choice answer.
     * - choice: Multiple_Choice_Answer_Reference | Multiple_Choice_Answer_Text
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var string
     */
    public $Multiple_Choice_Answer_Text;
    /**
     * Constructor method for Multiple_Choice_Answer_DataType
     * @uses Multiple_Choice_Answer_DataType::setMultiple_Choice_Answer_Reference()
     * @uses Multiple_Choice_Answer_DataType::setMultiple_Choice_Answer_Text()
     * @param \StructType\Question_Multiple_Choice_AnswerObjectType $multiple_Choice_Answer_Reference
     * @param string $multiple_Choice_Answer_Text
     */
    public function __construct(\StructType\Question_Multiple_Choice_AnswerObjectType $multiple_Choice_Answer_Reference = null, $multiple_Choice_Answer_Text = null)
    {
        $this
            ->setMultiple_Choice_Answer_Reference($multiple_Choice_Answer_Reference)
            ->setMultiple_Choice_Answer_Text($multiple_Choice_Answer_Text);
    }
    /**
     * Get Multiple_Choice_Answer_Reference value
     * @return \StructType\Question_Multiple_Choice_AnswerObjectType|null
     */
    public function getMultiple_Choice_Answer_Reference()
    {
        return isset($this->Multiple_Choice_Answer_Reference) ? $this->Multiple_Choice_Answer_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMultiple_Choice_Answer_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiple_Choice_Answer_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMultiple_Choice_Answer_ReferenceForChoiceConstraintsFromSetMultiple_Choice_Answer_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Multiple_Choice_Answer_Text',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Multiple_Choice_Answer_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Multiple_Choice_Answer_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Multiple_Choice_Answer_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Question_Multiple_Choice_AnswerObjectType $multiple_Choice_Answer_Reference
     * @return \StructType\Multiple_Choice_Answer_DataType
     */
    public function setMultiple_Choice_Answer_Reference(\StructType\Question_Multiple_Choice_AnswerObjectType $multiple_Choice_Answer_Reference = null)
    {
        // validation for constraint: choice(Multiple_Choice_Answer_Reference, Multiple_Choice_Answer_Text)
        if ('' !== ($multiple_Choice_Answer_ReferenceChoiceErrorMessage = self::validateMultiple_Choice_Answer_ReferenceForChoiceConstraintsFromSetMultiple_Choice_Answer_Reference($multiple_Choice_Answer_Reference))) {
            throw new \InvalidArgumentException($multiple_Choice_Answer_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($multiple_Choice_Answer_Reference) || (is_array($multiple_Choice_Answer_Reference) && empty($multiple_Choice_Answer_Reference))) {
            unset($this->Multiple_Choice_Answer_Reference);
        } else {
            $this->Multiple_Choice_Answer_Reference = $multiple_Choice_Answer_Reference;
        }
        return $this;
    }
    /**
     * Get Multiple_Choice_Answer_Text value
     * @return string|null
     */
    public function getMultiple_Choice_Answer_Text()
    {
        return isset($this->Multiple_Choice_Answer_Text) ? $this->Multiple_Choice_Answer_Text : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMultiple_Choice_Answer_Text method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiple_Choice_Answer_Text method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMultiple_Choice_Answer_TextForChoiceConstraintsFromSetMultiple_Choice_Answer_Text($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Multiple_Choice_Answer_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Multiple_Choice_Answer_Text can\'t be set as the property %s is already set. Only one property must be set among these properties: Multiple_Choice_Answer_Text, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Multiple_Choice_Answer_Text value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $multiple_Choice_Answer_Text
     * @return \StructType\Multiple_Choice_Answer_DataType
     */
    public function setMultiple_Choice_Answer_Text($multiple_Choice_Answer_Text = null)
    {
        // validation for constraint: string
        if (!is_null($multiple_Choice_Answer_Text) && !is_string($multiple_Choice_Answer_Text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($multiple_Choice_Answer_Text, true), gettype($multiple_Choice_Answer_Text)), __LINE__);
        }
        // validation for constraint: choice(Multiple_Choice_Answer_Reference, Multiple_Choice_Answer_Text)
        if ('' !== ($multiple_Choice_Answer_TextChoiceErrorMessage = self::validateMultiple_Choice_Answer_TextForChoiceConstraintsFromSetMultiple_Choice_Answer_Text($multiple_Choice_Answer_Text))) {
            throw new \InvalidArgumentException($multiple_Choice_Answer_TextChoiceErrorMessage, __LINE__);
        }
        if (is_null($multiple_Choice_Answer_Text) || (is_array($multiple_Choice_Answer_Text) && empty($multiple_Choice_Answer_Text))) {
            unset($this->Multiple_Choice_Answer_Text);
        } else {
            $this->Multiple_Choice_Answer_Text = $multiple_Choice_Answer_Text;
        }
        return $this;
    }
}
