<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Requisition_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Utilize the Request References element to retrieve a specific instance(s) of Job Requisition and its associated data.
 * @subpackage Structs
 */
class Job_Requisition_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier for a Job Requisition requested.
     * - maxOccurs: unbounded
     * @var \StructType\Job_RequisitionObjectType[]
     */
    public $Job_Requisition_Reference;
    /**
     * The Skip_Non_Existing_Instances
     * @var bool
     */
    public $Skip_Non_Existing_Instances;
    /**
     * Constructor method for Job_Requisition_Request_ReferencesType
     * @uses Job_Requisition_Request_ReferencesType::setJob_Requisition_Reference()
     * @uses Job_Requisition_Request_ReferencesType::setSkip_Non_Existing_Instances()
     * @param \StructType\Job_RequisitionObjectType[] $job_Requisition_Reference
     * @param bool $skip_Non_Existing_Instances
     */
    public function __construct(array $job_Requisition_Reference = array(), $skip_Non_Existing_Instances = null)
    {
        $this
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setSkip_Non_Existing_Instances($skip_Non_Existing_Instances);
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_RequisitionObjectType[]|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Requisition_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Requisition_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Requisition_ReferenceForArrayConstraintsFromSetJob_Requisition_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Requisition_Request_ReferencesTypeJob_Requisition_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Requisition_Request_ReferencesTypeJob_Requisition_ReferenceItem instanceof \StructType\Job_RequisitionObjectType) {
                $invalidValues[] = is_object($job_Requisition_Request_ReferencesTypeJob_Requisition_ReferenceItem) ? get_class($job_Requisition_Request_ReferencesTypeJob_Requisition_ReferenceItem) : sprintf('%s(%s)', gettype($job_Requisition_Request_ReferencesTypeJob_Requisition_ReferenceItem), var_export($job_Requisition_Request_ReferencesTypeJob_Requisition_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Requisition_Reference property can only contain items of type \StructType\Job_RequisitionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Requisition_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_RequisitionObjectType[] $job_Requisition_Reference
     * @return \StructType\Job_Requisition_Request_ReferencesType
     */
    public function setJob_Requisition_Reference(array $job_Requisition_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Requisition_ReferenceArrayErrorMessage = self::validateJob_Requisition_ReferenceForArrayConstraintsFromSetJob_Requisition_Reference($job_Requisition_Reference))) {
            throw new \InvalidArgumentException($job_Requisition_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Add item to Job_Requisition_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_RequisitionObjectType $item
     * @return \StructType\Job_Requisition_Request_ReferencesType
     */
    public function addToJob_Requisition_Reference(\StructType\Job_RequisitionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_RequisitionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Job_Requisition_Reference property can only contain items of type \StructType\Job_RequisitionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Requisition_Reference[] = $item;
        return $this;
    }
    /**
     * Get Skip_Non_Existing_Instances value
     * @return bool|null
     */
    public function getSkip_Non_Existing_Instances()
    {
        return $this->Skip_Non_Existing_Instances;
    }
    /**
     * Set Skip_Non_Existing_Instances value
     * @param bool $skip_Non_Existing_Instances
     * @return \StructType\Job_Requisition_Request_ReferencesType
     */
    public function setSkip_Non_Existing_Instances($skip_Non_Existing_Instances = null)
    {
        // validation for constraint: boolean
        if (!is_null($skip_Non_Existing_Instances) && !is_bool($skip_Non_Existing_Instances)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skip_Non_Existing_Instances, true), gettype($skip_Non_Existing_Instances)), __LINE__);
        }
        $this->Skip_Non_Existing_Instances = $skip_Non_Existing_Instances;
        return $this;
    }
}
