<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Requisition_Interview_Team_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains job requisition interview sessions data and the overall comment for the job requisition interview team.
 * @subpackage Structs
 */
class Job_Requisition_Interview_Team_DataType extends AbstractStructBase
{
    /**
     * The Job_Requisition_Interview_Team_ID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier to reference a Job Requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Requisition_Interview_Team_ID;
    /**
     * The Job_Requisition_Interview_Session
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_Interview_SessionType[]
     */
    public $Job_Requisition_Interview_Session;
    /**
     * The Overall_Comment
     * Meta information extracted from the WSDL
     * - documentation: Overall Comment for the job requisition interview team.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Overall_Comment;
    /**
     * Constructor method for Job_Requisition_Interview_Team_DataType
     * @uses Job_Requisition_Interview_Team_DataType::setJob_Requisition_Interview_Team_ID()
     * @uses Job_Requisition_Interview_Team_DataType::setJob_Requisition_Interview_Session()
     * @uses Job_Requisition_Interview_Team_DataType::setOverall_Comment()
     * @param string $job_Requisition_Interview_Team_ID
     * @param \StructType\Job_Requisition_Interview_SessionType[] $job_Requisition_Interview_Session
     * @param string $overall_Comment
     */
    public function __construct($job_Requisition_Interview_Team_ID = null, array $job_Requisition_Interview_Session = array(), $overall_Comment = null)
    {
        $this
            ->setJob_Requisition_Interview_Team_ID($job_Requisition_Interview_Team_ID)
            ->setJob_Requisition_Interview_Session($job_Requisition_Interview_Session)
            ->setOverall_Comment($overall_Comment);
    }
    /**
     * Get Job_Requisition_Interview_Team_ID value
     * @return string|null
     */
    public function getJob_Requisition_Interview_Team_ID()
    {
        return $this->Job_Requisition_Interview_Team_ID;
    }
    /**
     * Set Job_Requisition_Interview_Team_ID value
     * @param string $job_Requisition_Interview_Team_ID
     * @return \StructType\Job_Requisition_Interview_Team_DataType
     */
    public function setJob_Requisition_Interview_Team_ID($job_Requisition_Interview_Team_ID = null)
    {
        // validation for constraint: string
        if (!is_null($job_Requisition_Interview_Team_ID) && !is_string($job_Requisition_Interview_Team_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Requisition_Interview_Team_ID, true), gettype($job_Requisition_Interview_Team_ID)), __LINE__);
        }
        $this->Job_Requisition_Interview_Team_ID = $job_Requisition_Interview_Team_ID;
        return $this;
    }
    /**
     * Get Job_Requisition_Interview_Session value
     * @return \StructType\Job_Requisition_Interview_SessionType[]|null
     */
    public function getJob_Requisition_Interview_Session()
    {
        return $this->Job_Requisition_Interview_Session;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Requisition_Interview_Session method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Requisition_Interview_Session method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Requisition_Interview_SessionForArrayConstraintsFromSetJob_Requisition_Interview_Session(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Requisition_Interview_Team_DataTypeJob_Requisition_Interview_SessionItem) {
            // validation for constraint: itemType
            if (!$job_Requisition_Interview_Team_DataTypeJob_Requisition_Interview_SessionItem instanceof \StructType\Job_Requisition_Interview_SessionType) {
                $invalidValues[] = is_object($job_Requisition_Interview_Team_DataTypeJob_Requisition_Interview_SessionItem) ? get_class($job_Requisition_Interview_Team_DataTypeJob_Requisition_Interview_SessionItem) : sprintf('%s(%s)', gettype($job_Requisition_Interview_Team_DataTypeJob_Requisition_Interview_SessionItem), var_export($job_Requisition_Interview_Team_DataTypeJob_Requisition_Interview_SessionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Requisition_Interview_Session property can only contain items of type \StructType\Job_Requisition_Interview_SessionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Requisition_Interview_Session value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_Interview_SessionType[] $job_Requisition_Interview_Session
     * @return \StructType\Job_Requisition_Interview_Team_DataType
     */
    public function setJob_Requisition_Interview_Session(array $job_Requisition_Interview_Session = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Requisition_Interview_SessionArrayErrorMessage = self::validateJob_Requisition_Interview_SessionForArrayConstraintsFromSetJob_Requisition_Interview_Session($job_Requisition_Interview_Session))) {
            throw new \InvalidArgumentException($job_Requisition_Interview_SessionArrayErrorMessage, __LINE__);
        }
        $this->Job_Requisition_Interview_Session = $job_Requisition_Interview_Session;
        return $this;
    }
    /**
     * Add item to Job_Requisition_Interview_Session value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_Interview_SessionType $item
     * @return \StructType\Job_Requisition_Interview_Team_DataType
     */
    public function addToJob_Requisition_Interview_Session(\StructType\Job_Requisition_Interview_SessionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Requisition_Interview_SessionType) {
            throw new \InvalidArgumentException(sprintf('The Job_Requisition_Interview_Session property can only contain items of type \StructType\Job_Requisition_Interview_SessionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Requisition_Interview_Session[] = $item;
        return $this;
    }
    /**
     * Get Overall_Comment value
     * @return string|null
     */
    public function getOverall_Comment()
    {
        return $this->Overall_Comment;
    }
    /**
     * Set Overall_Comment value
     * @param string $overall_Comment
     * @return \StructType\Job_Requisition_Interview_Team_DataType
     */
    public function setOverall_Comment($overall_Comment = null)
    {
        // validation for constraint: string
        if (!is_null($overall_Comment) && !is_string($overall_Comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overall_Comment, true), gettype($overall_Comment)), __LINE__);
        }
        $this->Overall_Comment = $overall_Comment;
        return $this;
    }
}
