<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Requisition_Definition_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Job Requisition Details
 * @subpackage Structs
 */
class Job_Requisition_Definition_DataType extends AbstractStructBase
{
    /**
     * The Job_Posting_Title
     * Meta information extracted from the WSDL
     * - documentation: The Job Posting Title of the Job Requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Posting_Title;
    /**
     * The Positions_Allocated
     * Meta information extracted from the WSDL
     * - documentation: The number of positions made available by the job requisition. This number can only be greater than 1 for job requisitions created with the "new position" option. A value of greater than 1 was only allowed starting in W16. This
     * element must be omitted for the Create Job Requisition and Edit Job Requisition operations.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $Positions_Allocated;
    /**
     * The Positions_Available
     * Meta information extracted from the WSDL
     * - documentation: The number of openings or positions available to fill for the job requisition.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $Positions_Available;
    /**
     * The Academic_Tenure_Eligible
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Job Requisition is for a position that is academic tenure eligible.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Academic_Tenure_Eligible;
    /**
     * The Job_Description_Summary
     * Meta information extracted from the WSDL
     * - documentation: The job description summary (plain text) for the job requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Description_Summary;
    /**
     * The Job_Description
     * Meta information extracted from the WSDL
     * - documentation: The job description (rich text) for the job requisition.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Description;
    /**
     * The Additional_Job_Description
     * Meta information extracted from the WSDL
     * - documentation: The Additional Job Description is only available when the Recruiting functional area is enabled. Use job posting templates to control where the Additional Job Description displays. Example: Define a Job Description for external job
     * postings and an Additional Job Description for internal job postings.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Additional_Job_Description;
    /**
     * The Justification
     * Meta information extracted from the WSDL
     * - documentation: The Justification for the Job Requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Justification;
    /**
     * The Recruiting_Instruction_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Recruiting_Instruction_DataType
     */
    public $Recruiting_Instruction_Data;
    /**
     * The Available_for_Recruiting
     * Meta information extracted from the WSDL
     * - documentation: Returns true if any of the job requisition's positions is available for recruiting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Available_for_Recruiting;
    /**
     * The Replacement_for_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: If the job requisition exists with the purpose of replacing a worker, enter the reference worker.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Replacement_for_Worker_Reference;
    /**
     * The Confidential_Job_Requisition
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the job requisition is confidential
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Confidential_Job_Requisition;
    /**
     * The Job_Application_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Job Application Template associated with the Job Requisition
     * - minOccurs: 0
     * @var \StructType\Job_Application_TemplateObjectType
     */
    public $Job_Application_Template_Reference;
    /**
     * Constructor method for Job_Requisition_Definition_DataType
     * @uses Job_Requisition_Definition_DataType::setJob_Posting_Title()
     * @uses Job_Requisition_Definition_DataType::setPositions_Allocated()
     * @uses Job_Requisition_Definition_DataType::setPositions_Available()
     * @uses Job_Requisition_Definition_DataType::setAcademic_Tenure_Eligible()
     * @uses Job_Requisition_Definition_DataType::setJob_Description_Summary()
     * @uses Job_Requisition_Definition_DataType::setJob_Description()
     * @uses Job_Requisition_Definition_DataType::setAdditional_Job_Description()
     * @uses Job_Requisition_Definition_DataType::setJustification()
     * @uses Job_Requisition_Definition_DataType::setRecruiting_Instruction_Data()
     * @uses Job_Requisition_Definition_DataType::setAvailable_for_Recruiting()
     * @uses Job_Requisition_Definition_DataType::setReplacement_for_Worker_Reference()
     * @uses Job_Requisition_Definition_DataType::setConfidential_Job_Requisition()
     * @uses Job_Requisition_Definition_DataType::setJob_Application_Template_Reference()
     * @param string $job_Posting_Title
     * @param float $positions_Allocated
     * @param float $positions_Available
     * @param bool $academic_Tenure_Eligible
     * @param string $job_Description_Summary
     * @param string $job_Description
     * @param string $additional_Job_Description
     * @param string $justification
     * @param \StructType\Recruiting_Instruction_DataType $recruiting_Instruction_Data
     * @param bool $available_for_Recruiting
     * @param \StructType\WorkerObjectType $replacement_for_Worker_Reference
     * @param bool $confidential_Job_Requisition
     * @param \StructType\Job_Application_TemplateObjectType $job_Application_Template_Reference
     */
    public function __construct($job_Posting_Title = null, $positions_Allocated = null, $positions_Available = null, $academic_Tenure_Eligible = null, $job_Description_Summary = null, $job_Description = null, $additional_Job_Description = null, $justification = null, \StructType\Recruiting_Instruction_DataType $recruiting_Instruction_Data = null, $available_for_Recruiting = null, \StructType\WorkerObjectType $replacement_for_Worker_Reference = null, $confidential_Job_Requisition = null, \StructType\Job_Application_TemplateObjectType $job_Application_Template_Reference = null)
    {
        $this
            ->setJob_Posting_Title($job_Posting_Title)
            ->setPositions_Allocated($positions_Allocated)
            ->setPositions_Available($positions_Available)
            ->setAcademic_Tenure_Eligible($academic_Tenure_Eligible)
            ->setJob_Description_Summary($job_Description_Summary)
            ->setJob_Description($job_Description)
            ->setAdditional_Job_Description($additional_Job_Description)
            ->setJustification($justification)
            ->setRecruiting_Instruction_Data($recruiting_Instruction_Data)
            ->setAvailable_for_Recruiting($available_for_Recruiting)
            ->setReplacement_for_Worker_Reference($replacement_for_Worker_Reference)
            ->setConfidential_Job_Requisition($confidential_Job_Requisition)
            ->setJob_Application_Template_Reference($job_Application_Template_Reference);
    }
    /**
     * Get Job_Posting_Title value
     * @return string|null
     */
    public function getJob_Posting_Title()
    {
        return $this->Job_Posting_Title;
    }
    /**
     * Set Job_Posting_Title value
     * @param string $job_Posting_Title
     * @return \StructType\Job_Requisition_Definition_DataType
     */
    public function setJob_Posting_Title($job_Posting_Title = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_Title) && !is_string($job_Posting_Title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_Title, true), gettype($job_Posting_Title)), __LINE__);
        }
        $this->Job_Posting_Title = $job_Posting_Title;
        return $this;
    }
    /**
     * Get Positions_Allocated value
     * @return float|null
     */
    public function getPositions_Allocated()
    {
        return $this->Positions_Allocated;
    }
    /**
     * Set Positions_Allocated value
     * @param float $positions_Allocated
     * @return \StructType\Job_Requisition_Definition_DataType
     */
    public function setPositions_Allocated($positions_Allocated = null)
    {
        // validation for constraint: float
        if (!is_null($positions_Allocated) && !(is_float($positions_Allocated) || is_numeric($positions_Allocated))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($positions_Allocated, true), gettype($positions_Allocated)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($positions_Allocated) && mb_strlen(mb_substr($positions_Allocated, false !== mb_strpos($positions_Allocated, '.') ? mb_strpos($positions_Allocated, '.') + 1 : mb_strlen($positions_Allocated))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($positions_Allocated, true), mb_strlen(mb_substr($positions_Allocated, mb_strpos($positions_Allocated, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($positions_Allocated) && $positions_Allocated < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($positions_Allocated, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($positions_Allocated) && mb_strlen(preg_replace('/(\D)/', '', $positions_Allocated)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($positions_Allocated, true), mb_strlen(preg_replace('/(\D)/', '', $positions_Allocated))), __LINE__);
        }
        $this->Positions_Allocated = $positions_Allocated;
        return $this;
    }
    /**
     * Get Positions_Available value
     * @return float|null
     */
    public function getPositions_Available()
    {
        return $this->Positions_Available;
    }
    /**
     * Set Positions_Available value
     * @param float $positions_Available
     * @return \StructType\Job_Requisition_Definition_DataType
     */
    public function setPositions_Available($positions_Available = null)
    {
        // validation for constraint: float
        if (!is_null($positions_Available) && !(is_float($positions_Available) || is_numeric($positions_Available))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($positions_Available, true), gettype($positions_Available)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($positions_Available) && mb_strlen(mb_substr($positions_Available, false !== mb_strpos($positions_Available, '.') ? mb_strpos($positions_Available, '.') + 1 : mb_strlen($positions_Available))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($positions_Available, true), mb_strlen(mb_substr($positions_Available, mb_strpos($positions_Available, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($positions_Available) && mb_strlen(preg_replace('/(\D)/', '', $positions_Available)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($positions_Available, true), mb_strlen(preg_replace('/(\D)/', '', $positions_Available))), __LINE__);
        }
        $this->Positions_Available = $positions_Available;
        return $this;
    }
    /**
     * Get Academic_Tenure_Eligible value
     * @return bool|null
     */
    public function getAcademic_Tenure_Eligible()
    {
        return $this->Academic_Tenure_Eligible;
    }
    /**
     * Set Academic_Tenure_Eligible value
     * @param bool $academic_Tenure_Eligible
     * @return \StructType\Job_Requisition_Definition_DataType
     */
    public function setAcademic_Tenure_Eligible($academic_Tenure_Eligible = null)
    {
        // validation for constraint: boolean
        if (!is_null($academic_Tenure_Eligible) && !is_bool($academic_Tenure_Eligible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($academic_Tenure_Eligible, true), gettype($academic_Tenure_Eligible)), __LINE__);
        }
        $this->Academic_Tenure_Eligible = $academic_Tenure_Eligible;
        return $this;
    }
    /**
     * Get Job_Description_Summary value
     * @return string|null
     */
    public function getJob_Description_Summary()
    {
        return $this->Job_Description_Summary;
    }
    /**
     * Set Job_Description_Summary value
     * @param string $job_Description_Summary
     * @return \StructType\Job_Requisition_Definition_DataType
     */
    public function setJob_Description_Summary($job_Description_Summary = null)
    {
        // validation for constraint: string
        if (!is_null($job_Description_Summary) && !is_string($job_Description_Summary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Description_Summary, true), gettype($job_Description_Summary)), __LINE__);
        }
        $this->Job_Description_Summary = $job_Description_Summary;
        return $this;
    }
    /**
     * Get Job_Description value
     * @return string|null
     */
    public function getJob_Description()
    {
        return $this->Job_Description;
    }
    /**
     * Set Job_Description value
     * @param string $job_Description
     * @return \StructType\Job_Requisition_Definition_DataType
     */
    public function setJob_Description($job_Description = null)
    {
        // validation for constraint: string
        if (!is_null($job_Description) && !is_string($job_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Description, true), gettype($job_Description)), __LINE__);
        }
        $this->Job_Description = $job_Description;
        return $this;
    }
    /**
     * Get Additional_Job_Description value
     * @return string|null
     */
    public function getAdditional_Job_Description()
    {
        return $this->Additional_Job_Description;
    }
    /**
     * Set Additional_Job_Description value
     * @param string $additional_Job_Description
     * @return \StructType\Job_Requisition_Definition_DataType
     */
    public function setAdditional_Job_Description($additional_Job_Description = null)
    {
        // validation for constraint: string
        if (!is_null($additional_Job_Description) && !is_string($additional_Job_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additional_Job_Description, true), gettype($additional_Job_Description)), __LINE__);
        }
        $this->Additional_Job_Description = $additional_Job_Description;
        return $this;
    }
    /**
     * Get Justification value
     * @return string|null
     */
    public function getJustification()
    {
        return $this->Justification;
    }
    /**
     * Set Justification value
     * @param string $justification
     * @return \StructType\Job_Requisition_Definition_DataType
     */
    public function setJustification($justification = null)
    {
        // validation for constraint: string
        if (!is_null($justification) && !is_string($justification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($justification, true), gettype($justification)), __LINE__);
        }
        $this->Justification = $justification;
        return $this;
    }
    /**
     * Get Recruiting_Instruction_Data value
     * @return \StructType\Recruiting_Instruction_DataType|null
     */
    public function getRecruiting_Instruction_Data()
    {
        return $this->Recruiting_Instruction_Data;
    }
    /**
     * Set Recruiting_Instruction_Data value
     * @param \StructType\Recruiting_Instruction_DataType $recruiting_Instruction_Data
     * @return \StructType\Job_Requisition_Definition_DataType
     */
    public function setRecruiting_Instruction_Data(\StructType\Recruiting_Instruction_DataType $recruiting_Instruction_Data = null)
    {
        $this->Recruiting_Instruction_Data = $recruiting_Instruction_Data;
        return $this;
    }
    /**
     * Get Available_for_Recruiting value
     * @return bool|null
     */
    public function getAvailable_for_Recruiting()
    {
        return $this->Available_for_Recruiting;
    }
    /**
     * Set Available_for_Recruiting value
     * @param bool $available_for_Recruiting
     * @return \StructType\Job_Requisition_Definition_DataType
     */
    public function setAvailable_for_Recruiting($available_for_Recruiting = null)
    {
        // validation for constraint: boolean
        if (!is_null($available_for_Recruiting) && !is_bool($available_for_Recruiting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($available_for_Recruiting, true), gettype($available_for_Recruiting)), __LINE__);
        }
        $this->Available_for_Recruiting = $available_for_Recruiting;
        return $this;
    }
    /**
     * Get Replacement_for_Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getReplacement_for_Worker_Reference()
    {
        return $this->Replacement_for_Worker_Reference;
    }
    /**
     * Set Replacement_for_Worker_Reference value
     * @param \StructType\WorkerObjectType $replacement_for_Worker_Reference
     * @return \StructType\Job_Requisition_Definition_DataType
     */
    public function setReplacement_for_Worker_Reference(\StructType\WorkerObjectType $replacement_for_Worker_Reference = null)
    {
        $this->Replacement_for_Worker_Reference = $replacement_for_Worker_Reference;
        return $this;
    }
    /**
     * Get Confidential_Job_Requisition value
     * @return bool|null
     */
    public function getConfidential_Job_Requisition()
    {
        return $this->Confidential_Job_Requisition;
    }
    /**
     * Set Confidential_Job_Requisition value
     * @param bool $confidential_Job_Requisition
     * @return \StructType\Job_Requisition_Definition_DataType
     */
    public function setConfidential_Job_Requisition($confidential_Job_Requisition = null)
    {
        // validation for constraint: boolean
        if (!is_null($confidential_Job_Requisition) && !is_bool($confidential_Job_Requisition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($confidential_Job_Requisition, true), gettype($confidential_Job_Requisition)), __LINE__);
        }
        $this->Confidential_Job_Requisition = $confidential_Job_Requisition;
        return $this;
    }
    /**
     * Get Job_Application_Template_Reference value
     * @return \StructType\Job_Application_TemplateObjectType|null
     */
    public function getJob_Application_Template_Reference()
    {
        return $this->Job_Application_Template_Reference;
    }
    /**
     * Set Job_Application_Template_Reference value
     * @param \StructType\Job_Application_TemplateObjectType $job_Application_Template_Reference
     * @return \StructType\Job_Requisition_Definition_DataType
     */
    public function setJob_Application_Template_Reference(\StructType\Job_Application_TemplateObjectType $job_Application_Template_Reference = null)
    {
        $this->Job_Application_Template_Reference = $job_Application_Template_Reference;
        return $this;
    }
}
