<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Requisition_Custom_Object_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Effective dated additional data for a job requisition.
 * @subpackage Structs
 */
class Job_Requisition_Custom_Object_DataType extends AbstractStructBase
{
    /**
     * The Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Effective date of the edit additional data request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Effective_Date;
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Job Requisition for edit additional data request.
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_EnabledObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * The Business_Object_Additional_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Effective_Dated_Web_Service_Additional_DataType[]
     */
    public $Business_Object_Additional_Data;
    /**
     * Constructor method for Job_Requisition_Custom_Object_DataType
     * @uses Job_Requisition_Custom_Object_DataType::setEffective_Date()
     * @uses Job_Requisition_Custom_Object_DataType::setJob_Requisition_Reference()
     * @uses Job_Requisition_Custom_Object_DataType::setBusiness_Object_Additional_Data()
     * @param string $effective_Date
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @param \StructType\Effective_Dated_Web_Service_Additional_DataType[] $business_Object_Additional_Data
     */
    public function __construct($effective_Date = null, \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null, array $business_Object_Additional_Data = array())
    {
        $this
            ->setEffective_Date($effective_Date)
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setBusiness_Object_Additional_Data($business_Object_Additional_Data);
    }
    /**
     * Get Effective_Date value
     * @return string|null
     */
    public function getEffective_Date()
    {
        return $this->Effective_Date;
    }
    /**
     * Set Effective_Date value
     * @param string $effective_Date
     * @return \StructType\Job_Requisition_Custom_Object_DataType
     */
    public function setEffective_Date($effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($effective_Date) && !is_string($effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effective_Date, true), gettype($effective_Date)), __LINE__);
        }
        $this->Effective_Date = $effective_Date;
        return $this;
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @return \StructType\Job_Requisition_Custom_Object_DataType
     */
    public function setJob_Requisition_Reference(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Get Business_Object_Additional_Data value
     * @return \StructType\Effective_Dated_Web_Service_Additional_DataType[]|null
     */
    public function getBusiness_Object_Additional_Data()
    {
        return $this->Business_Object_Additional_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Object_Additional_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Object_Additional_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Object_Additional_DataForArrayConstraintsFromSetBusiness_Object_Additional_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Requisition_Custom_Object_DataTypeBusiness_Object_Additional_DataItem) {
            // validation for constraint: itemType
            if (!$job_Requisition_Custom_Object_DataTypeBusiness_Object_Additional_DataItem instanceof \StructType\Effective_Dated_Web_Service_Additional_DataType) {
                $invalidValues[] = is_object($job_Requisition_Custom_Object_DataTypeBusiness_Object_Additional_DataItem) ? get_class($job_Requisition_Custom_Object_DataTypeBusiness_Object_Additional_DataItem) : sprintf('%s(%s)', gettype($job_Requisition_Custom_Object_DataTypeBusiness_Object_Additional_DataItem), var_export($job_Requisition_Custom_Object_DataTypeBusiness_Object_Additional_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Object_Additional_Data property can only contain items of type \StructType\Effective_Dated_Web_Service_Additional_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Object_Additional_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Effective_Dated_Web_Service_Additional_DataType[] $business_Object_Additional_Data
     * @return \StructType\Job_Requisition_Custom_Object_DataType
     */
    public function setBusiness_Object_Additional_Data(array $business_Object_Additional_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Object_Additional_DataArrayErrorMessage = self::validateBusiness_Object_Additional_DataForArrayConstraintsFromSetBusiness_Object_Additional_Data($business_Object_Additional_Data))) {
            throw new \InvalidArgumentException($business_Object_Additional_DataArrayErrorMessage, __LINE__);
        }
        $this->Business_Object_Additional_Data = $business_Object_Additional_Data;
        return $this;
    }
    /**
     * Add item to Business_Object_Additional_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Effective_Dated_Web_Service_Additional_DataType $item
     * @return \StructType\Job_Requisition_Custom_Object_DataType
     */
    public function addToBusiness_Object_Additional_Data(\StructType\Effective_Dated_Web_Service_Additional_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Effective_Dated_Web_Service_Additional_DataType) {
            throw new \InvalidArgumentException(sprintf('The Business_Object_Additional_Data property can only contain items of type \StructType\Effective_Dated_Web_Service_Additional_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Object_Additional_Data[] = $item;
        return $this;
    }
}
