<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Posting_Site_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Container which holds Job Posting Sites returned by the GET
 * @subpackage Structs
 */
class Job_Posting_Site_Response_DataType extends AbstractStructBase
{
    /**
     * The Job_Posting_Site
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Posting_SiteType[]
     */
    public $Job_Posting_Site;
    /**
     * Constructor method for Job_Posting_Site_Response_DataType
     * @uses Job_Posting_Site_Response_DataType::setJob_Posting_Site()
     * @param \StructType\Job_Posting_SiteType[] $job_Posting_Site
     */
    public function __construct(array $job_Posting_Site = array())
    {
        $this
            ->setJob_Posting_Site($job_Posting_Site);
    }
    /**
     * Get Job_Posting_Site value
     * @return \StructType\Job_Posting_SiteType[]|null
     */
    public function getJob_Posting_Site()
    {
        return $this->Job_Posting_Site;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Posting_Site method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Posting_Site method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Posting_SiteForArrayConstraintsFromSetJob_Posting_Site(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Posting_Site_Response_DataTypeJob_Posting_SiteItem) {
            // validation for constraint: itemType
            if (!$job_Posting_Site_Response_DataTypeJob_Posting_SiteItem instanceof \StructType\Job_Posting_SiteType) {
                $invalidValues[] = is_object($job_Posting_Site_Response_DataTypeJob_Posting_SiteItem) ? get_class($job_Posting_Site_Response_DataTypeJob_Posting_SiteItem) : sprintf('%s(%s)', gettype($job_Posting_Site_Response_DataTypeJob_Posting_SiteItem), var_export($job_Posting_Site_Response_DataTypeJob_Posting_SiteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Posting_Site property can only contain items of type \StructType\Job_Posting_SiteType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Posting_Site value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_SiteType[] $job_Posting_Site
     * @return \StructType\Job_Posting_Site_Response_DataType
     */
    public function setJob_Posting_Site(array $job_Posting_Site = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Posting_SiteArrayErrorMessage = self::validateJob_Posting_SiteForArrayConstraintsFromSetJob_Posting_Site($job_Posting_Site))) {
            throw new \InvalidArgumentException($job_Posting_SiteArrayErrorMessage, __LINE__);
        }
        $this->Job_Posting_Site = $job_Posting_Site;
        return $this;
    }
    /**
     * Add item to Job_Posting_Site value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Posting_SiteType $item
     * @return \StructType\Job_Posting_Site_Response_DataType
     */
    public function addToJob_Posting_Site(\StructType\Job_Posting_SiteType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Posting_SiteType) {
            throw new \InvalidArgumentException(sprintf('The Job_Posting_Site property can only contain items of type \StructType\Job_Posting_SiteType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Posting_Site[] = $item;
        return $this;
    }
}
