<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Posting_Site_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Get Job Posting Site via following criteria: Posting Site Name or All Generic Job Posting Sites
 * @subpackage Structs
 */
class Job_Posting_Site_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Posting_Site_Name
     * Meta information extracted from the WSDL
     * - documentation: Search for a Job Posting Site by name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Posting_Site_Name;
    /**
     * The Generic_Job_Posting_Sites
     * Meta information extracted from the WSDL
     * - documentation: Return only Generic Job Posting Sites
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Generic_Job_Posting_Sites;
    /**
     * Constructor method for Job_Posting_Site_Request_CriteriaType
     * @uses Job_Posting_Site_Request_CriteriaType::setPosting_Site_Name()
     * @uses Job_Posting_Site_Request_CriteriaType::setGeneric_Job_Posting_Sites()
     * @param string $posting_Site_Name
     * @param bool $generic_Job_Posting_Sites
     */
    public function __construct($posting_Site_Name = null, $generic_Job_Posting_Sites = null)
    {
        $this
            ->setPosting_Site_Name($posting_Site_Name)
            ->setGeneric_Job_Posting_Sites($generic_Job_Posting_Sites);
    }
    /**
     * Get Posting_Site_Name value
     * @return string|null
     */
    public function getPosting_Site_Name()
    {
        return $this->Posting_Site_Name;
    }
    /**
     * Set Posting_Site_Name value
     * @param string $posting_Site_Name
     * @return \StructType\Job_Posting_Site_Request_CriteriaType
     */
    public function setPosting_Site_Name($posting_Site_Name = null)
    {
        // validation for constraint: string
        if (!is_null($posting_Site_Name) && !is_string($posting_Site_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($posting_Site_Name, true), gettype($posting_Site_Name)), __LINE__);
        }
        $this->Posting_Site_Name = $posting_Site_Name;
        return $this;
    }
    /**
     * Get Generic_Job_Posting_Sites value
     * @return bool|null
     */
    public function getGeneric_Job_Posting_Sites()
    {
        return $this->Generic_Job_Posting_Sites;
    }
    /**
     * Set Generic_Job_Posting_Sites value
     * @param bool $generic_Job_Posting_Sites
     * @return \StructType\Job_Posting_Site_Request_CriteriaType
     */
    public function setGeneric_Job_Posting_Sites($generic_Job_Posting_Sites = null)
    {
        // validation for constraint: boolean
        if (!is_null($generic_Job_Posting_Sites) && !is_bool($generic_Job_Posting_Sites)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generic_Job_Posting_Sites, true), gettype($generic_Job_Posting_Sites)), __LINE__);
        }
        $this->Generic_Job_Posting_Sites = $generic_Job_Posting_Sites;
        return $this;
    }
}
