<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Posting_Response_GroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: The response group allows for the response data to be tailored to only included elements that the user is looking for. If no response group is provided in the request then only the following elements will be returned: Reference, Job
 * Requisition Definition Data, and Job Requisition Restrictions Data.
 * @subpackage Structs
 */
class Job_Posting_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Reference for the Job Posting is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Include_Job_Requisition_Restrictions_Data
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Job Requisition Restrictions Data is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Job_Requisition_Restrictions_Data;
    /**
     * The Include_Job_Requisition_Definition_Data
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Job Requisition Definition Data is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Job_Requisition_Definition_Data;
    /**
     * The Include_Qualifications
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Position's Qualifications (Competencies, Education, Responsibilities, etc.) are included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Qualifications;
    /**
     * The Include_Job_Requisition_Attachments
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Position's Open Job Requisition Attachments (if they exist) are included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Job_Requisition_Attachments;
    /**
     * Constructor method for Job_Posting_Response_GroupType
     * @uses Job_Posting_Response_GroupType::setInclude_Reference()
     * @uses Job_Posting_Response_GroupType::setInclude_Job_Requisition_Restrictions_Data()
     * @uses Job_Posting_Response_GroupType::setInclude_Job_Requisition_Definition_Data()
     * @uses Job_Posting_Response_GroupType::setInclude_Qualifications()
     * @uses Job_Posting_Response_GroupType::setInclude_Job_Requisition_Attachments()
     * @param bool $include_Reference
     * @param bool $include_Job_Requisition_Restrictions_Data
     * @param bool $include_Job_Requisition_Definition_Data
     * @param bool $include_Qualifications
     * @param bool $include_Job_Requisition_Attachments
     */
    public function __construct($include_Reference = null, $include_Job_Requisition_Restrictions_Data = null, $include_Job_Requisition_Definition_Data = null, $include_Qualifications = null, $include_Job_Requisition_Attachments = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setInclude_Job_Requisition_Restrictions_Data($include_Job_Requisition_Restrictions_Data)
            ->setInclude_Job_Requisition_Definition_Data($include_Job_Requisition_Definition_Data)
            ->setInclude_Qualifications($include_Qualifications)
            ->setInclude_Job_Requisition_Attachments($include_Job_Requisition_Attachments);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Job_Posting_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Include_Job_Requisition_Restrictions_Data value
     * @return bool|null
     */
    public function getInclude_Job_Requisition_Restrictions_Data()
    {
        return $this->Include_Job_Requisition_Restrictions_Data;
    }
    /**
     * Set Include_Job_Requisition_Restrictions_Data value
     * @param bool $include_Job_Requisition_Restrictions_Data
     * @return \StructType\Job_Posting_Response_GroupType
     */
    public function setInclude_Job_Requisition_Restrictions_Data($include_Job_Requisition_Restrictions_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Job_Requisition_Restrictions_Data) && !is_bool($include_Job_Requisition_Restrictions_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Job_Requisition_Restrictions_Data, true), gettype($include_Job_Requisition_Restrictions_Data)), __LINE__);
        }
        $this->Include_Job_Requisition_Restrictions_Data = $include_Job_Requisition_Restrictions_Data;
        return $this;
    }
    /**
     * Get Include_Job_Requisition_Definition_Data value
     * @return bool|null
     */
    public function getInclude_Job_Requisition_Definition_Data()
    {
        return $this->Include_Job_Requisition_Definition_Data;
    }
    /**
     * Set Include_Job_Requisition_Definition_Data value
     * @param bool $include_Job_Requisition_Definition_Data
     * @return \StructType\Job_Posting_Response_GroupType
     */
    public function setInclude_Job_Requisition_Definition_Data($include_Job_Requisition_Definition_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Job_Requisition_Definition_Data) && !is_bool($include_Job_Requisition_Definition_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Job_Requisition_Definition_Data, true), gettype($include_Job_Requisition_Definition_Data)), __LINE__);
        }
        $this->Include_Job_Requisition_Definition_Data = $include_Job_Requisition_Definition_Data;
        return $this;
    }
    /**
     * Get Include_Qualifications value
     * @return bool|null
     */
    public function getInclude_Qualifications()
    {
        return $this->Include_Qualifications;
    }
    /**
     * Set Include_Qualifications value
     * @param bool $include_Qualifications
     * @return \StructType\Job_Posting_Response_GroupType
     */
    public function setInclude_Qualifications($include_Qualifications = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Qualifications) && !is_bool($include_Qualifications)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Qualifications, true), gettype($include_Qualifications)), __LINE__);
        }
        $this->Include_Qualifications = $include_Qualifications;
        return $this;
    }
    /**
     * Get Include_Job_Requisition_Attachments value
     * @return bool|null
     */
    public function getInclude_Job_Requisition_Attachments()
    {
        return $this->Include_Job_Requisition_Attachments;
    }
    /**
     * Set Include_Job_Requisition_Attachments value
     * @param bool $include_Job_Requisition_Attachments
     * @return \StructType\Job_Posting_Response_GroupType
     */
    public function setInclude_Job_Requisition_Attachments($include_Job_Requisition_Attachments = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Job_Requisition_Attachments) && !is_bool($include_Job_Requisition_Attachments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Job_Requisition_Attachments, true), gettype($include_Job_Requisition_Attachments)), __LINE__);
        }
        $this->Include_Job_Requisition_Attachments = $include_Job_Requisition_Attachments;
        return $this;
    }
}
