<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Posting_Data_WWSType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element for a Job Posting.
 * @subpackage Structs
 */
class Job_Posting_Data_WWSType extends AbstractStructBase
{
    /**
     * The Job_Posting_ID
     * Meta information extracted from the WSDL
     * - documentation: The ID of the Job Posting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Posting_ID;
    /**
     * The Job_Posting_Title
     * Meta information extracted from the WSDL
     * - documentation: The Job Posting Title for the Job Posting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Posting_Title;
    /**
     * The Job_Posting_Description
     * Meta information extracted from the WSDL
     * - documentation: The Job Posting Description for the Job Posting.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Posting_Description;
    /**
     * The Job_Posting_Site_Reference
     * Meta information extracted from the WSDL
     * - documentation: Job Posting Site for Job Posting.
     * - minOccurs: 0
     * @var \StructType\Job_Posting_SiteObjectType
     */
    public $Job_Posting_Site_Reference;
    /**
     * The External_Job_Path
     * Meta information extracted from the WSDL
     * - documentation: The External Site Path for the Job Posting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Job_Path;
    /**
     * The External_Apply_URL
     * Meta information extracted from the WSDL
     * - documentation: For external postings (custom and/or external career site), this is the link to the external career site job URL.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Apply_URL;
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Job Requisition for the Job Posting.
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_EnabledObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * The Job_Requisition_ID
     * Meta information extracted from the WSDL
     * - documentation: The ID of the Job Requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Requisition_ID;
    /**
     * The Job_Posting_Location_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Job_Posting_Location_DataType
     */
    public $Job_Posting_Location_Data;
    /**
     * The Job_Posting_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start Date of the Job Posting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Posting_Start_Date;
    /**
     * The Job_Posting_End_Date
     * Meta information extracted from the WSDL
     * - documentation: End date of the Job Posting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Posting_End_Date;
    /**
     * The Primary_Posting
     * Meta information extracted from the WSDL
     * - documentation: Job posting is the default job posting used for social share and invite to apply referrals. Will return false until post job business process is complete.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Primary_Posting;
    /**
     * The Forecasted_Payout
     * Meta information extracted from the WSDL
     * - documentation: The Forecasted Agency Payout on a Job Posting. Calculated at time of posting or updated later. The Currency for this value is stored separately on the Job Posting.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Forecasted_Payout;
    /**
     * The Forecasted_Payout_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Currency for the Forecasted Agency Payout stored on the Job Posting.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Forecasted_Payout_Currency_Reference;
    /**
     * The Job_Family_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Job Family for the Job Posting.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_FamilyObjectType[]
     */
    public $Job_Family_Reference;
    /**
     * The Time_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Position Time Type for the Job Posting.
     * - minOccurs: 0
     * @var \StructType\Position_Time_TypeObjectType
     */
    public $Time_Type_Reference;
    /**
     * The Job_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Worker Subt-Type for the Job Posting.
     * - minOccurs: 0
     * @var \StructType\Position_Worker_TypeObjectType
     */
    public $Job_Type_Reference;
    /**
     * The Supervisory_Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Supervisory Organization for the Job Posting.
     * - minOccurs: 0
     * @var \StructType\Supervisory_OrganizationObjectType
     */
    public $Supervisory_Organization_Reference;
    /**
     * The Student_Award_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: The work-study student award sources for the job posting. Includes at least 1 job profile that requires or allows work-study from at least 1 of these student award sources.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Student_Award_SourceObjectType[]
     */
    public $Student_Award_Source_Reference;
    /**
     * The Union_Reference
     * Meta information extracted from the WSDL
     * - documentation: The unions for the job posting. Includes at least 1 job profile that requires or allows membership in at least 1 of these unions.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UnionObjectType[]
     */
    public $Union_Reference;
    /**
     * The Similar_Jobs_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Similar Job(s) for the Job Posting.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_PostingObjectType[]
     */
    public $Similar_Jobs_Reference;
    /**
     * The Hiring_Requirement_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_Restrictions_DataType
     */
    public $Hiring_Requirement_Data;
    /**
     * The Job_Requisition_Detail_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_Definition_DataType
     */
    public $Job_Requisition_Detail_Data;
    /**
     * The Qualification_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Qualifications_from_Position_Restrictions_DataType
     */
    public $Qualification_Data;
    /**
     * The Job_Requisition_Attachments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_AttachmentsType
     */
    public $Job_Requisition_Attachments;
    /**
     * The Document_Field_Result_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_Field_Result_DataType[]
     */
    public $Document_Field_Result_Data;
    /**
     * Constructor method for Job_Posting_Data_WWSType
     * @uses Job_Posting_Data_WWSType::setJob_Posting_ID()
     * @uses Job_Posting_Data_WWSType::setJob_Posting_Title()
     * @uses Job_Posting_Data_WWSType::setJob_Posting_Description()
     * @uses Job_Posting_Data_WWSType::setJob_Posting_Site_Reference()
     * @uses Job_Posting_Data_WWSType::setExternal_Job_Path()
     * @uses Job_Posting_Data_WWSType::setExternal_Apply_URL()
     * @uses Job_Posting_Data_WWSType::setJob_Requisition_Reference()
     * @uses Job_Posting_Data_WWSType::setJob_Requisition_ID()
     * @uses Job_Posting_Data_WWSType::setJob_Posting_Location_Data()
     * @uses Job_Posting_Data_WWSType::setJob_Posting_Start_Date()
     * @uses Job_Posting_Data_WWSType::setJob_Posting_End_Date()
     * @uses Job_Posting_Data_WWSType::setPrimary_Posting()
     * @uses Job_Posting_Data_WWSType::setForecasted_Payout()
     * @uses Job_Posting_Data_WWSType::setForecasted_Payout_Currency_Reference()
     * @uses Job_Posting_Data_WWSType::setJob_Family_Reference()
     * @uses Job_Posting_Data_WWSType::setTime_Type_Reference()
     * @uses Job_Posting_Data_WWSType::setJob_Type_Reference()
     * @uses Job_Posting_Data_WWSType::setSupervisory_Organization_Reference()
     * @uses Job_Posting_Data_WWSType::setStudent_Award_Source_Reference()
     * @uses Job_Posting_Data_WWSType::setUnion_Reference()
     * @uses Job_Posting_Data_WWSType::setSimilar_Jobs_Reference()
     * @uses Job_Posting_Data_WWSType::setHiring_Requirement_Data()
     * @uses Job_Posting_Data_WWSType::setJob_Requisition_Detail_Data()
     * @uses Job_Posting_Data_WWSType::setQualification_Data()
     * @uses Job_Posting_Data_WWSType::setJob_Requisition_Attachments()
     * @uses Job_Posting_Data_WWSType::setDocument_Field_Result_Data()
     * @param string $job_Posting_ID
     * @param string $job_Posting_Title
     * @param string $job_Posting_Description
     * @param \StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference
     * @param string $external_Job_Path
     * @param string $external_Apply_URL
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @param string $job_Requisition_ID
     * @param \StructType\Job_Posting_Location_DataType $job_Posting_Location_Data
     * @param string $job_Posting_Start_Date
     * @param string $job_Posting_End_Date
     * @param bool $primary_Posting
     * @param float $forecasted_Payout
     * @param \StructType\CurrencyObjectType $forecasted_Payout_Currency_Reference
     * @param \StructType\Job_FamilyObjectType[] $job_Family_Reference
     * @param \StructType\Position_Time_TypeObjectType $time_Type_Reference
     * @param \StructType\Position_Worker_TypeObjectType $job_Type_Reference
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @param \StructType\Student_Award_SourceObjectType[] $student_Award_Source_Reference
     * @param \StructType\UnionObjectType[] $union_Reference
     * @param \StructType\Job_PostingObjectType[] $similar_Jobs_Reference
     * @param \StructType\Job_Requisition_Restrictions_DataType $hiring_Requirement_Data
     * @param \StructType\Job_Requisition_Definition_DataType $job_Requisition_Detail_Data
     * @param \StructType\Qualifications_from_Position_Restrictions_DataType $qualification_Data
     * @param \StructType\Job_Requisition_AttachmentsType $job_Requisition_Attachments
     * @param \StructType\Document_Field_Result_DataType[] $document_Field_Result_Data
     */
    public function __construct($job_Posting_ID = null, $job_Posting_Title = null, $job_Posting_Description = null, \StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference = null, $external_Job_Path = null, $external_Apply_URL = null, \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null, $job_Requisition_ID = null, \StructType\Job_Posting_Location_DataType $job_Posting_Location_Data = null, $job_Posting_Start_Date = null, $job_Posting_End_Date = null, $primary_Posting = null, $forecasted_Payout = null, \StructType\CurrencyObjectType $forecasted_Payout_Currency_Reference = null, array $job_Family_Reference = array(), \StructType\Position_Time_TypeObjectType $time_Type_Reference = null, \StructType\Position_Worker_TypeObjectType $job_Type_Reference = null, \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null, array $student_Award_Source_Reference = array(), array $union_Reference = array(), array $similar_Jobs_Reference = array(), \StructType\Job_Requisition_Restrictions_DataType $hiring_Requirement_Data = null, \StructType\Job_Requisition_Definition_DataType $job_Requisition_Detail_Data = null, \StructType\Qualifications_from_Position_Restrictions_DataType $qualification_Data = null, \StructType\Job_Requisition_AttachmentsType $job_Requisition_Attachments = null, array $document_Field_Result_Data = array())
    {
        $this
            ->setJob_Posting_ID($job_Posting_ID)
            ->setJob_Posting_Title($job_Posting_Title)
            ->setJob_Posting_Description($job_Posting_Description)
            ->setJob_Posting_Site_Reference($job_Posting_Site_Reference)
            ->setExternal_Job_Path($external_Job_Path)
            ->setExternal_Apply_URL($external_Apply_URL)
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setJob_Requisition_ID($job_Requisition_ID)
            ->setJob_Posting_Location_Data($job_Posting_Location_Data)
            ->setJob_Posting_Start_Date($job_Posting_Start_Date)
            ->setJob_Posting_End_Date($job_Posting_End_Date)
            ->setPrimary_Posting($primary_Posting)
            ->setForecasted_Payout($forecasted_Payout)
            ->setForecasted_Payout_Currency_Reference($forecasted_Payout_Currency_Reference)
            ->setJob_Family_Reference($job_Family_Reference)
            ->setTime_Type_Reference($time_Type_Reference)
            ->setJob_Type_Reference($job_Type_Reference)
            ->setSupervisory_Organization_Reference($supervisory_Organization_Reference)
            ->setStudent_Award_Source_Reference($student_Award_Source_Reference)
            ->setUnion_Reference($union_Reference)
            ->setSimilar_Jobs_Reference($similar_Jobs_Reference)
            ->setHiring_Requirement_Data($hiring_Requirement_Data)
            ->setJob_Requisition_Detail_Data($job_Requisition_Detail_Data)
            ->setQualification_Data($qualification_Data)
            ->setJob_Requisition_Attachments($job_Requisition_Attachments)
            ->setDocument_Field_Result_Data($document_Field_Result_Data);
    }
    /**
     * Get Job_Posting_ID value
     * @return string|null
     */
    public function getJob_Posting_ID()
    {
        return $this->Job_Posting_ID;
    }
    /**
     * Set Job_Posting_ID value
     * @param string $job_Posting_ID
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setJob_Posting_ID($job_Posting_ID = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_ID) && !is_string($job_Posting_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_ID, true), gettype($job_Posting_ID)), __LINE__);
        }
        $this->Job_Posting_ID = $job_Posting_ID;
        return $this;
    }
    /**
     * Get Job_Posting_Title value
     * @return string|null
     */
    public function getJob_Posting_Title()
    {
        return $this->Job_Posting_Title;
    }
    /**
     * Set Job_Posting_Title value
     * @param string $job_Posting_Title
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setJob_Posting_Title($job_Posting_Title = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_Title) && !is_string($job_Posting_Title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_Title, true), gettype($job_Posting_Title)), __LINE__);
        }
        $this->Job_Posting_Title = $job_Posting_Title;
        return $this;
    }
    /**
     * Get Job_Posting_Description value
     * @return string|null
     */
    public function getJob_Posting_Description()
    {
        return $this->Job_Posting_Description;
    }
    /**
     * Set Job_Posting_Description value
     * @param string $job_Posting_Description
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setJob_Posting_Description($job_Posting_Description = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_Description) && !is_string($job_Posting_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_Description, true), gettype($job_Posting_Description)), __LINE__);
        }
        $this->Job_Posting_Description = $job_Posting_Description;
        return $this;
    }
    /**
     * Get Job_Posting_Site_Reference value
     * @return \StructType\Job_Posting_SiteObjectType|null
     */
    public function getJob_Posting_Site_Reference()
    {
        return $this->Job_Posting_Site_Reference;
    }
    /**
     * Set Job_Posting_Site_Reference value
     * @param \StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setJob_Posting_Site_Reference(\StructType\Job_Posting_SiteObjectType $job_Posting_Site_Reference = null)
    {
        $this->Job_Posting_Site_Reference = $job_Posting_Site_Reference;
        return $this;
    }
    /**
     * Get External_Job_Path value
     * @return string|null
     */
    public function getExternal_Job_Path()
    {
        return $this->External_Job_Path;
    }
    /**
     * Set External_Job_Path value
     * @param string $external_Job_Path
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setExternal_Job_Path($external_Job_Path = null)
    {
        // validation for constraint: string
        if (!is_null($external_Job_Path) && !is_string($external_Job_Path)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Job_Path, true), gettype($external_Job_Path)), __LINE__);
        }
        $this->External_Job_Path = $external_Job_Path;
        return $this;
    }
    /**
     * Get External_Apply_URL value
     * @return string|null
     */
    public function getExternal_Apply_URL()
    {
        return $this->External_Apply_URL;
    }
    /**
     * Set External_Apply_URL value
     * @param string $external_Apply_URL
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setExternal_Apply_URL($external_Apply_URL = null)
    {
        // validation for constraint: string
        if (!is_null($external_Apply_URL) && !is_string($external_Apply_URL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Apply_URL, true), gettype($external_Apply_URL)), __LINE__);
        }
        $this->External_Apply_URL = $external_Apply_URL;
        return $this;
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setJob_Requisition_Reference(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Get Job_Requisition_ID value
     * @return string|null
     */
    public function getJob_Requisition_ID()
    {
        return $this->Job_Requisition_ID;
    }
    /**
     * Set Job_Requisition_ID value
     * @param string $job_Requisition_ID
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setJob_Requisition_ID($job_Requisition_ID = null)
    {
        // validation for constraint: string
        if (!is_null($job_Requisition_ID) && !is_string($job_Requisition_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Requisition_ID, true), gettype($job_Requisition_ID)), __LINE__);
        }
        $this->Job_Requisition_ID = $job_Requisition_ID;
        return $this;
    }
    /**
     * Get Job_Posting_Location_Data value
     * @return \StructType\Job_Posting_Location_DataType|null
     */
    public function getJob_Posting_Location_Data()
    {
        return $this->Job_Posting_Location_Data;
    }
    /**
     * Set Job_Posting_Location_Data value
     * @param \StructType\Job_Posting_Location_DataType $job_Posting_Location_Data
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setJob_Posting_Location_Data(\StructType\Job_Posting_Location_DataType $job_Posting_Location_Data = null)
    {
        $this->Job_Posting_Location_Data = $job_Posting_Location_Data;
        return $this;
    }
    /**
     * Get Job_Posting_Start_Date value
     * @return string|null
     */
    public function getJob_Posting_Start_Date()
    {
        return $this->Job_Posting_Start_Date;
    }
    /**
     * Set Job_Posting_Start_Date value
     * @param string $job_Posting_Start_Date
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setJob_Posting_Start_Date($job_Posting_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_Start_Date) && !is_string($job_Posting_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_Start_Date, true), gettype($job_Posting_Start_Date)), __LINE__);
        }
        $this->Job_Posting_Start_Date = $job_Posting_Start_Date;
        return $this;
    }
    /**
     * Get Job_Posting_End_Date value
     * @return string|null
     */
    public function getJob_Posting_End_Date()
    {
        return $this->Job_Posting_End_Date;
    }
    /**
     * Set Job_Posting_End_Date value
     * @param string $job_Posting_End_Date
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setJob_Posting_End_Date($job_Posting_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_End_Date) && !is_string($job_Posting_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_End_Date, true), gettype($job_Posting_End_Date)), __LINE__);
        }
        $this->Job_Posting_End_Date = $job_Posting_End_Date;
        return $this;
    }
    /**
     * Get Primary_Posting value
     * @return bool|null
     */
    public function getPrimary_Posting()
    {
        return $this->Primary_Posting;
    }
    /**
     * Set Primary_Posting value
     * @param bool $primary_Posting
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setPrimary_Posting($primary_Posting = null)
    {
        // validation for constraint: boolean
        if (!is_null($primary_Posting) && !is_bool($primary_Posting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primary_Posting, true), gettype($primary_Posting)), __LINE__);
        }
        $this->Primary_Posting = $primary_Posting;
        return $this;
    }
    /**
     * Get Forecasted_Payout value
     * @return float|null
     */
    public function getForecasted_Payout()
    {
        return $this->Forecasted_Payout;
    }
    /**
     * Set Forecasted_Payout value
     * @param float $forecasted_Payout
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setForecasted_Payout($forecasted_Payout = null)
    {
        // validation for constraint: float
        if (!is_null($forecasted_Payout) && !(is_float($forecasted_Payout) || is_numeric($forecasted_Payout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($forecasted_Payout, true), gettype($forecasted_Payout)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($forecasted_Payout) && mb_strlen(mb_substr($forecasted_Payout, false !== mb_strpos($forecasted_Payout, '.') ? mb_strpos($forecasted_Payout, '.') + 1 : mb_strlen($forecasted_Payout))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($forecasted_Payout, true), mb_strlen(mb_substr($forecasted_Payout, mb_strpos($forecasted_Payout, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($forecasted_Payout) && $forecasted_Payout < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($forecasted_Payout, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($forecasted_Payout) && mb_strlen(preg_replace('/(\D)/', '', $forecasted_Payout)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($forecasted_Payout, true), mb_strlen(preg_replace('/(\D)/', '', $forecasted_Payout))), __LINE__);
        }
        $this->Forecasted_Payout = $forecasted_Payout;
        return $this;
    }
    /**
     * Get Forecasted_Payout_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getForecasted_Payout_Currency_Reference()
    {
        return $this->Forecasted_Payout_Currency_Reference;
    }
    /**
     * Set Forecasted_Payout_Currency_Reference value
     * @param \StructType\CurrencyObjectType $forecasted_Payout_Currency_Reference
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setForecasted_Payout_Currency_Reference(\StructType\CurrencyObjectType $forecasted_Payout_Currency_Reference = null)
    {
        $this->Forecasted_Payout_Currency_Reference = $forecasted_Payout_Currency_Reference;
        return $this;
    }
    /**
     * Get Job_Family_Reference value
     * @return \StructType\Job_FamilyObjectType[]|null
     */
    public function getJob_Family_Reference()
    {
        return $this->Job_Family_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Family_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Family_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Family_ReferenceForArrayConstraintsFromSetJob_Family_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Posting_Data_WWSTypeJob_Family_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Posting_Data_WWSTypeJob_Family_ReferenceItem instanceof \StructType\Job_FamilyObjectType) {
                $invalidValues[] = is_object($job_Posting_Data_WWSTypeJob_Family_ReferenceItem) ? get_class($job_Posting_Data_WWSTypeJob_Family_ReferenceItem) : sprintf('%s(%s)', gettype($job_Posting_Data_WWSTypeJob_Family_ReferenceItem), var_export($job_Posting_Data_WWSTypeJob_Family_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Family_Reference property can only contain items of type \StructType\Job_FamilyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Family_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_FamilyObjectType[] $job_Family_Reference
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setJob_Family_Reference(array $job_Family_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Family_ReferenceArrayErrorMessage = self::validateJob_Family_ReferenceForArrayConstraintsFromSetJob_Family_Reference($job_Family_Reference))) {
            throw new \InvalidArgumentException($job_Family_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Job_Family_Reference = $job_Family_Reference;
        return $this;
    }
    /**
     * Add item to Job_Family_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_FamilyObjectType $item
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function addToJob_Family_Reference(\StructType\Job_FamilyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_FamilyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Job_Family_Reference property can only contain items of type \StructType\Job_FamilyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Family_Reference[] = $item;
        return $this;
    }
    /**
     * Get Time_Type_Reference value
     * @return \StructType\Position_Time_TypeObjectType|null
     */
    public function getTime_Type_Reference()
    {
        return $this->Time_Type_Reference;
    }
    /**
     * Set Time_Type_Reference value
     * @param \StructType\Position_Time_TypeObjectType $time_Type_Reference
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setTime_Type_Reference(\StructType\Position_Time_TypeObjectType $time_Type_Reference = null)
    {
        $this->Time_Type_Reference = $time_Type_Reference;
        return $this;
    }
    /**
     * Get Job_Type_Reference value
     * @return \StructType\Position_Worker_TypeObjectType|null
     */
    public function getJob_Type_Reference()
    {
        return $this->Job_Type_Reference;
    }
    /**
     * Set Job_Type_Reference value
     * @param \StructType\Position_Worker_TypeObjectType $job_Type_Reference
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setJob_Type_Reference(\StructType\Position_Worker_TypeObjectType $job_Type_Reference = null)
    {
        $this->Job_Type_Reference = $job_Type_Reference;
        return $this;
    }
    /**
     * Get Supervisory_Organization_Reference value
     * @return \StructType\Supervisory_OrganizationObjectType|null
     */
    public function getSupervisory_Organization_Reference()
    {
        return $this->Supervisory_Organization_Reference;
    }
    /**
     * Set Supervisory_Organization_Reference value
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setSupervisory_Organization_Reference(\StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null)
    {
        $this->Supervisory_Organization_Reference = $supervisory_Organization_Reference;
        return $this;
    }
    /**
     * Get Student_Award_Source_Reference value
     * @return \StructType\Student_Award_SourceObjectType[]|null
     */
    public function getStudent_Award_Source_Reference()
    {
        return $this->Student_Award_Source_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setStudent_Award_Source_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStudent_Award_Source_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStudent_Award_Source_ReferenceForArrayConstraintsFromSetStudent_Award_Source_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Posting_Data_WWSTypeStudent_Award_Source_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Posting_Data_WWSTypeStudent_Award_Source_ReferenceItem instanceof \StructType\Student_Award_SourceObjectType) {
                $invalidValues[] = is_object($job_Posting_Data_WWSTypeStudent_Award_Source_ReferenceItem) ? get_class($job_Posting_Data_WWSTypeStudent_Award_Source_ReferenceItem) : sprintf('%s(%s)', gettype($job_Posting_Data_WWSTypeStudent_Award_Source_ReferenceItem), var_export($job_Posting_Data_WWSTypeStudent_Award_Source_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Student_Award_Source_Reference property can only contain items of type \StructType\Student_Award_SourceObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Student_Award_Source_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Student_Award_SourceObjectType[] $student_Award_Source_Reference
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setStudent_Award_Source_Reference(array $student_Award_Source_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($student_Award_Source_ReferenceArrayErrorMessage = self::validateStudent_Award_Source_ReferenceForArrayConstraintsFromSetStudent_Award_Source_Reference($student_Award_Source_Reference))) {
            throw new \InvalidArgumentException($student_Award_Source_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Student_Award_Source_Reference = $student_Award_Source_Reference;
        return $this;
    }
    /**
     * Add item to Student_Award_Source_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Student_Award_SourceObjectType $item
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function addToStudent_Award_Source_Reference(\StructType\Student_Award_SourceObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Student_Award_SourceObjectType) {
            throw new \InvalidArgumentException(sprintf('The Student_Award_Source_Reference property can only contain items of type \StructType\Student_Award_SourceObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Student_Award_Source_Reference[] = $item;
        return $this;
    }
    /**
     * Get Union_Reference value
     * @return \StructType\UnionObjectType[]|null
     */
    public function getUnion_Reference()
    {
        return $this->Union_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setUnion_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnion_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnion_ReferenceForArrayConstraintsFromSetUnion_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Posting_Data_WWSTypeUnion_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Posting_Data_WWSTypeUnion_ReferenceItem instanceof \StructType\UnionObjectType) {
                $invalidValues[] = is_object($job_Posting_Data_WWSTypeUnion_ReferenceItem) ? get_class($job_Posting_Data_WWSTypeUnion_ReferenceItem) : sprintf('%s(%s)', gettype($job_Posting_Data_WWSTypeUnion_ReferenceItem), var_export($job_Posting_Data_WWSTypeUnion_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Union_Reference property can only contain items of type \StructType\UnionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Union_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\UnionObjectType[] $union_Reference
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setUnion_Reference(array $union_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($union_ReferenceArrayErrorMessage = self::validateUnion_ReferenceForArrayConstraintsFromSetUnion_Reference($union_Reference))) {
            throw new \InvalidArgumentException($union_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Union_Reference = $union_Reference;
        return $this;
    }
    /**
     * Add item to Union_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\UnionObjectType $item
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function addToUnion_Reference(\StructType\UnionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Union_Reference property can only contain items of type \StructType\UnionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Union_Reference[] = $item;
        return $this;
    }
    /**
     * Get Similar_Jobs_Reference value
     * @return \StructType\Job_PostingObjectType[]|null
     */
    public function getSimilar_Jobs_Reference()
    {
        return $this->Similar_Jobs_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSimilar_Jobs_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSimilar_Jobs_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSimilar_Jobs_ReferenceForArrayConstraintsFromSetSimilar_Jobs_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Posting_Data_WWSTypeSimilar_Jobs_ReferenceItem) {
            // validation for constraint: itemType
            if (!$job_Posting_Data_WWSTypeSimilar_Jobs_ReferenceItem instanceof \StructType\Job_PostingObjectType) {
                $invalidValues[] = is_object($job_Posting_Data_WWSTypeSimilar_Jobs_ReferenceItem) ? get_class($job_Posting_Data_WWSTypeSimilar_Jobs_ReferenceItem) : sprintf('%s(%s)', gettype($job_Posting_Data_WWSTypeSimilar_Jobs_ReferenceItem), var_export($job_Posting_Data_WWSTypeSimilar_Jobs_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Similar_Jobs_Reference property can only contain items of type \StructType\Job_PostingObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Similar_Jobs_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_PostingObjectType[] $similar_Jobs_Reference
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setSimilar_Jobs_Reference(array $similar_Jobs_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($similar_Jobs_ReferenceArrayErrorMessage = self::validateSimilar_Jobs_ReferenceForArrayConstraintsFromSetSimilar_Jobs_Reference($similar_Jobs_Reference))) {
            throw new \InvalidArgumentException($similar_Jobs_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Similar_Jobs_Reference = $similar_Jobs_Reference;
        return $this;
    }
    /**
     * Add item to Similar_Jobs_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_PostingObjectType $item
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function addToSimilar_Jobs_Reference(\StructType\Job_PostingObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_PostingObjectType) {
            throw new \InvalidArgumentException(sprintf('The Similar_Jobs_Reference property can only contain items of type \StructType\Job_PostingObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Similar_Jobs_Reference[] = $item;
        return $this;
    }
    /**
     * Get Hiring_Requirement_Data value
     * @return \StructType\Job_Requisition_Restrictions_DataType|null
     */
    public function getHiring_Requirement_Data()
    {
        return $this->Hiring_Requirement_Data;
    }
    /**
     * Set Hiring_Requirement_Data value
     * @param \StructType\Job_Requisition_Restrictions_DataType $hiring_Requirement_Data
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setHiring_Requirement_Data(\StructType\Job_Requisition_Restrictions_DataType $hiring_Requirement_Data = null)
    {
        $this->Hiring_Requirement_Data = $hiring_Requirement_Data;
        return $this;
    }
    /**
     * Get Job_Requisition_Detail_Data value
     * @return \StructType\Job_Requisition_Definition_DataType|null
     */
    public function getJob_Requisition_Detail_Data()
    {
        return $this->Job_Requisition_Detail_Data;
    }
    /**
     * Set Job_Requisition_Detail_Data value
     * @param \StructType\Job_Requisition_Definition_DataType $job_Requisition_Detail_Data
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setJob_Requisition_Detail_Data(\StructType\Job_Requisition_Definition_DataType $job_Requisition_Detail_Data = null)
    {
        $this->Job_Requisition_Detail_Data = $job_Requisition_Detail_Data;
        return $this;
    }
    /**
     * Get Qualification_Data value
     * @return \StructType\Qualifications_from_Position_Restrictions_DataType|null
     */
    public function getQualification_Data()
    {
        return $this->Qualification_Data;
    }
    /**
     * Set Qualification_Data value
     * @param \StructType\Qualifications_from_Position_Restrictions_DataType $qualification_Data
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setQualification_Data(\StructType\Qualifications_from_Position_Restrictions_DataType $qualification_Data = null)
    {
        $this->Qualification_Data = $qualification_Data;
        return $this;
    }
    /**
     * Get Job_Requisition_Attachments value
     * @return \StructType\Job_Requisition_AttachmentsType|null
     */
    public function getJob_Requisition_Attachments()
    {
        return $this->Job_Requisition_Attachments;
    }
    /**
     * Set Job_Requisition_Attachments value
     * @param \StructType\Job_Requisition_AttachmentsType $job_Requisition_Attachments
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setJob_Requisition_Attachments(\StructType\Job_Requisition_AttachmentsType $job_Requisition_Attachments = null)
    {
        $this->Job_Requisition_Attachments = $job_Requisition_Attachments;
        return $this;
    }
    /**
     * Get Document_Field_Result_Data value
     * @return \StructType\Document_Field_Result_DataType[]|null
     */
    public function getDocument_Field_Result_Data()
    {
        return $this->Document_Field_Result_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument_Field_Result_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument_Field_Result_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocument_Field_Result_DataForArrayConstraintsFromSetDocument_Field_Result_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Posting_Data_WWSTypeDocument_Field_Result_DataItem) {
            // validation for constraint: itemType
            if (!$job_Posting_Data_WWSTypeDocument_Field_Result_DataItem instanceof \StructType\Document_Field_Result_DataType) {
                $invalidValues[] = is_object($job_Posting_Data_WWSTypeDocument_Field_Result_DataItem) ? get_class($job_Posting_Data_WWSTypeDocument_Field_Result_DataItem) : sprintf('%s(%s)', gettype($job_Posting_Data_WWSTypeDocument_Field_Result_DataItem), var_export($job_Posting_Data_WWSTypeDocument_Field_Result_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document_Field_Result_Data property can only contain items of type \StructType\Document_Field_Result_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document_Field_Result_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_Field_Result_DataType[] $document_Field_Result_Data
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function setDocument_Field_Result_Data(array $document_Field_Result_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($document_Field_Result_DataArrayErrorMessage = self::validateDocument_Field_Result_DataForArrayConstraintsFromSetDocument_Field_Result_Data($document_Field_Result_Data))) {
            throw new \InvalidArgumentException($document_Field_Result_DataArrayErrorMessage, __LINE__);
        }
        $this->Document_Field_Result_Data = $document_Field_Result_Data;
        return $this;
    }
    /**
     * Add item to Document_Field_Result_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_Field_Result_DataType $item
     * @return \StructType\Job_Posting_Data_WWSType
     */
    public function addToDocument_Field_Result_Data(\StructType\Document_Field_Result_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_Field_Result_DataType) {
            throw new \InvalidArgumentException(sprintf('The Document_Field_Result_Data property can only contain items of type \StructType\Document_Field_Result_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Document_Field_Result_Data[] = $item;
        return $this;
    }
}
