<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Posting_Additional_Location_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains References and the External Name value for a Job Posting's additional locations.
 * @subpackage Structs
 */
class Job_Posting_Additional_Location_DataType extends AbstractStructBase
{
    /**
     * The Additional_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Additional Locations for the Job Posting.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Additional_Location_Reference;
    /**
     * The External_Name
     * Meta information extracted from the WSDL
     * - documentation: An alternate name for the primary location when the job details display on the Recruiting External Career Sites.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Name;
    /**
     * Constructor method for Job_Posting_Additional_Location_DataType
     * @uses Job_Posting_Additional_Location_DataType::setAdditional_Location_Reference()
     * @uses Job_Posting_Additional_Location_DataType::setExternal_Name()
     * @param \StructType\LocationObjectType $additional_Location_Reference
     * @param string $external_Name
     */
    public function __construct(\StructType\LocationObjectType $additional_Location_Reference = null, $external_Name = null)
    {
        $this
            ->setAdditional_Location_Reference($additional_Location_Reference)
            ->setExternal_Name($external_Name);
    }
    /**
     * Get Additional_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getAdditional_Location_Reference()
    {
        return $this->Additional_Location_Reference;
    }
    /**
     * Set Additional_Location_Reference value
     * @param \StructType\LocationObjectType $additional_Location_Reference
     * @return \StructType\Job_Posting_Additional_Location_DataType
     */
    public function setAdditional_Location_Reference(\StructType\LocationObjectType $additional_Location_Reference = null)
    {
        $this->Additional_Location_Reference = $additional_Location_Reference;
        return $this;
    }
    /**
     * Get External_Name value
     * @return string|null
     */
    public function getExternal_Name()
    {
        return $this->External_Name;
    }
    /**
     * Set External_Name value
     * @param string $external_Name
     * @return \StructType\Job_Posting_Additional_Location_DataType
     */
    public function setExternal_Name($external_Name = null)
    {
        // validation for constraint: string
        if (!is_null($external_Name) && !is_string($external_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Name, true), gettype($external_Name)), __LINE__);
        }
        $this->External_Name = $external_Name;
        return $this;
    }
}
