<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Application_Template_TranslationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains translations for the Job Application Template for all translated languages or specified languages
 * @subpackage Structs
 */
class Job_Application_Template_TranslationType extends AbstractStructBase
{
    /**
     * The Job_Application_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference ID or WID of Job Application Template
     * - minOccurs: 0
     * @var \StructType\Job_Application_TemplateObjectType
     */
    public $Job_Application_Template_Reference;
    /**
     * The Job_Application_Template_Translation_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains language reference, configurable section, and translated values
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Application_Template_Translation_DataType[]
     */
    public $Job_Application_Template_Translation_Data;
    /**
     * Constructor method for Job_Application_Template_TranslationType
     * @uses Job_Application_Template_TranslationType::setJob_Application_Template_Reference()
     * @uses Job_Application_Template_TranslationType::setJob_Application_Template_Translation_Data()
     * @param \StructType\Job_Application_TemplateObjectType $job_Application_Template_Reference
     * @param \StructType\Job_Application_Template_Translation_DataType[] $job_Application_Template_Translation_Data
     */
    public function __construct(\StructType\Job_Application_TemplateObjectType $job_Application_Template_Reference = null, array $job_Application_Template_Translation_Data = array())
    {
        $this
            ->setJob_Application_Template_Reference($job_Application_Template_Reference)
            ->setJob_Application_Template_Translation_Data($job_Application_Template_Translation_Data);
    }
    /**
     * Get Job_Application_Template_Reference value
     * @return \StructType\Job_Application_TemplateObjectType|null
     */
    public function getJob_Application_Template_Reference()
    {
        return $this->Job_Application_Template_Reference;
    }
    /**
     * Set Job_Application_Template_Reference value
     * @param \StructType\Job_Application_TemplateObjectType $job_Application_Template_Reference
     * @return \StructType\Job_Application_Template_TranslationType
     */
    public function setJob_Application_Template_Reference(\StructType\Job_Application_TemplateObjectType $job_Application_Template_Reference = null)
    {
        $this->Job_Application_Template_Reference = $job_Application_Template_Reference;
        return $this;
    }
    /**
     * Get Job_Application_Template_Translation_Data value
     * @return \StructType\Job_Application_Template_Translation_DataType[]|null
     */
    public function getJob_Application_Template_Translation_Data()
    {
        return $this->Job_Application_Template_Translation_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Application_Template_Translation_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Application_Template_Translation_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Application_Template_Translation_DataForArrayConstraintsFromSetJob_Application_Template_Translation_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Application_Template_TranslationTypeJob_Application_Template_Translation_DataItem) {
            // validation for constraint: itemType
            if (!$job_Application_Template_TranslationTypeJob_Application_Template_Translation_DataItem instanceof \StructType\Job_Application_Template_Translation_DataType) {
                $invalidValues[] = is_object($job_Application_Template_TranslationTypeJob_Application_Template_Translation_DataItem) ? get_class($job_Application_Template_TranslationTypeJob_Application_Template_Translation_DataItem) : sprintf('%s(%s)', gettype($job_Application_Template_TranslationTypeJob_Application_Template_Translation_DataItem), var_export($job_Application_Template_TranslationTypeJob_Application_Template_Translation_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Application_Template_Translation_Data property can only contain items of type \StructType\Job_Application_Template_Translation_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Application_Template_Translation_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Application_Template_Translation_DataType[] $job_Application_Template_Translation_Data
     * @return \StructType\Job_Application_Template_TranslationType
     */
    public function setJob_Application_Template_Translation_Data(array $job_Application_Template_Translation_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Application_Template_Translation_DataArrayErrorMessage = self::validateJob_Application_Template_Translation_DataForArrayConstraintsFromSetJob_Application_Template_Translation_Data($job_Application_Template_Translation_Data))) {
            throw new \InvalidArgumentException($job_Application_Template_Translation_DataArrayErrorMessage, __LINE__);
        }
        $this->Job_Application_Template_Translation_Data = $job_Application_Template_Translation_Data;
        return $this;
    }
    /**
     * Add item to Job_Application_Template_Translation_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Application_Template_Translation_DataType $item
     * @return \StructType\Job_Application_Template_TranslationType
     */
    public function addToJob_Application_Template_Translation_Data(\StructType\Job_Application_Template_Translation_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Application_Template_Translation_DataType) {
            throw new \InvalidArgumentException(sprintf('The Job_Application_Template_Translation_Data property can only contain items of type \StructType\Job_Application_Template_Translation_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Application_Template_Translation_Data[] = $item;
        return $this;
    }
}
