<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Job_Application_Additional_Data_Response_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains Job Application Additional data
 * @subpackage Structs
 */
class Job_Application_Additional_Data_Response_DataType extends AbstractStructBase
{
    /**
     * The Job_Application_Custom_Object_Data
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element containing Candidate Job Application Additional Data for requested references or criteria and for requested response group.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_ApplicationType[]
     */
    public $Job_Application_Custom_Object_Data;
    /**
     * Constructor method for Job_Application_Additional_Data_Response_DataType
     * @uses Job_Application_Additional_Data_Response_DataType::setJob_Application_Custom_Object_Data()
     * @param \StructType\Job_ApplicationType[] $job_Application_Custom_Object_Data
     */
    public function __construct(array $job_Application_Custom_Object_Data = array())
    {
        $this
            ->setJob_Application_Custom_Object_Data($job_Application_Custom_Object_Data);
    }
    /**
     * Get Job_Application_Custom_Object_Data value
     * @return \StructType\Job_ApplicationType[]|null
     */
    public function getJob_Application_Custom_Object_Data()
    {
        return $this->Job_Application_Custom_Object_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Application_Custom_Object_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Application_Custom_Object_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Application_Custom_Object_DataForArrayConstraintsFromSetJob_Application_Custom_Object_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $job_Application_Additional_Data_Response_DataTypeJob_Application_Custom_Object_DataItem) {
            // validation for constraint: itemType
            if (!$job_Application_Additional_Data_Response_DataTypeJob_Application_Custom_Object_DataItem instanceof \StructType\Job_ApplicationType) {
                $invalidValues[] = is_object($job_Application_Additional_Data_Response_DataTypeJob_Application_Custom_Object_DataItem) ? get_class($job_Application_Additional_Data_Response_DataTypeJob_Application_Custom_Object_DataItem) : sprintf('%s(%s)', gettype($job_Application_Additional_Data_Response_DataTypeJob_Application_Custom_Object_DataItem), var_export($job_Application_Additional_Data_Response_DataTypeJob_Application_Custom_Object_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Application_Custom_Object_Data property can only contain items of type \StructType\Job_ApplicationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Application_Custom_Object_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_ApplicationType[] $job_Application_Custom_Object_Data
     * @return \StructType\Job_Application_Additional_Data_Response_DataType
     */
    public function setJob_Application_Custom_Object_Data(array $job_Application_Custom_Object_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Application_Custom_Object_DataArrayErrorMessage = self::validateJob_Application_Custom_Object_DataForArrayConstraintsFromSetJob_Application_Custom_Object_Data($job_Application_Custom_Object_Data))) {
            throw new \InvalidArgumentException($job_Application_Custom_Object_DataArrayErrorMessage, __LINE__);
        }
        $this->Job_Application_Custom_Object_Data = $job_Application_Custom_Object_Data;
        return $this;
    }
    /**
     * Add item to Job_Application_Custom_Object_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_ApplicationType $item
     * @return \StructType\Job_Application_Additional_Data_Response_DataType
     */
    public function addToJob_Application_Custom_Object_Data(\StructType\Job_ApplicationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_ApplicationType) {
            throw new \InvalidArgumentException(sprintf('The Job_Application_Custom_Object_Data property can only contain items of type \StructType\Job_ApplicationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Application_Custom_Object_Data[] = $item;
        return $this;
    }
}
