<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Interview_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains interview data.
 * @subpackage Structs
 */
class Interview_Response_DataType extends AbstractStructBase
{
    /**
     * The Interview
     * Meta information extracted from the WSDL
     * - documentation: Contains interview data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InterviewType[]
     */
    public $Interview;
    /**
     * Constructor method for Interview_Response_DataType
     * @uses Interview_Response_DataType::setInterview()
     * @param \StructType\InterviewType[] $interview
     */
    public function __construct(array $interview = array())
    {
        $this
            ->setInterview($interview);
    }
    /**
     * Get Interview value
     * @return \StructType\InterviewType[]|null
     */
    public function getInterview()
    {
        return $this->Interview;
    }
    /**
     * This method is responsible for validating the values passed to the setInterview method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterview method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInterviewForArrayConstraintsFromSetInterview(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interview_Response_DataTypeInterviewItem) {
            // validation for constraint: itemType
            if (!$interview_Response_DataTypeInterviewItem instanceof \StructType\InterviewType) {
                $invalidValues[] = is_object($interview_Response_DataTypeInterviewItem) ? get_class($interview_Response_DataTypeInterviewItem) : sprintf('%s(%s)', gettype($interview_Response_DataTypeInterviewItem), var_export($interview_Response_DataTypeInterviewItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Interview property can only contain items of type \StructType\InterviewType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Interview value
     * @throws \InvalidArgumentException
     * @param \StructType\InterviewType[] $interview
     * @return \StructType\Interview_Response_DataType
     */
    public function setInterview(array $interview = array())
    {
        // validation for constraint: array
        if ('' !== ($interviewArrayErrorMessage = self::validateInterviewForArrayConstraintsFromSetInterview($interview))) {
            throw new \InvalidArgumentException($interviewArrayErrorMessage, __LINE__);
        }
        $this->Interview = $interview;
        return $this;
    }
    /**
     * Add item to Interview value
     * @throws \InvalidArgumentException
     * @param \StructType\InterviewType $item
     * @return \StructType\Interview_Response_DataType
     */
    public function addToInterview(\StructType\InterviewType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InterviewType) {
            throw new \InvalidArgumentException(sprintf('The Interview property can only contain items of type \StructType\InterviewType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Interview[] = $item;
        return $this;
    }
}
