<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Interview_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the interview reference.
 * @subpackage Structs
 */
class Interview_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Interview_Reference
     * Meta information extracted from the WSDL
     * - documentation: Interview Request Reference.
     * - maxOccurs: unbounded
     * @var \StructType\Unique_IdentifierObjectType[]
     */
    public $Interview_Reference;
    /**
     * Constructor method for Interview_Request_ReferencesType
     * @uses Interview_Request_ReferencesType::setInterview_Reference()
     * @param \StructType\Unique_IdentifierObjectType[] $interview_Reference
     */
    public function __construct(array $interview_Reference = array())
    {
        $this
            ->setInterview_Reference($interview_Reference);
    }
    /**
     * Get Interview_Reference value
     * @return \StructType\Unique_IdentifierObjectType[]|null
     */
    public function getInterview_Reference()
    {
        return $this->Interview_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setInterview_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterview_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInterview_ReferenceForArrayConstraintsFromSetInterview_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interview_Request_ReferencesTypeInterview_ReferenceItem) {
            // validation for constraint: itemType
            if (!$interview_Request_ReferencesTypeInterview_ReferenceItem instanceof \StructType\Unique_IdentifierObjectType) {
                $invalidValues[] = is_object($interview_Request_ReferencesTypeInterview_ReferenceItem) ? get_class($interview_Request_ReferencesTypeInterview_ReferenceItem) : sprintf('%s(%s)', gettype($interview_Request_ReferencesTypeInterview_ReferenceItem), var_export($interview_Request_ReferencesTypeInterview_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Interview_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Interview_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType[] $interview_Reference
     * @return \StructType\Interview_Request_ReferencesType
     */
    public function setInterview_Reference(array $interview_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($interview_ReferenceArrayErrorMessage = self::validateInterview_ReferenceForArrayConstraintsFromSetInterview_Reference($interview_Reference))) {
            throw new \InvalidArgumentException($interview_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Interview_Reference = $interview_Reference;
        return $this;
    }
    /**
     * Add item to Interview_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $item
     * @return \StructType\Interview_Request_ReferencesType
     */
    public function addToInterview_Reference(\StructType\Unique_IdentifierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_IdentifierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Interview_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Interview_Reference[] = $item;
        return $this;
    }
}
