<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Interview_Feedback_DetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the overall rating and comment for the interview feedback.
 * @subpackage Structs
 */
class Interview_Feedback_DetailsType extends AbstractStructBase
{
    /**
     * The Competency_Assessment_Data
     * Meta information extracted from the WSDL
     * - documentation: Competency rating and comments.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Competency_Assessment_DataType[]
     */
    public $Competency_Assessment_Data;
    /**
     * The Interview_Questionnaire_Data
     * Meta information extracted from the WSDL
     * - documentation: Interview Questionnaire and Response
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Interview_Questionnaire_DataType[]
     */
    public $Interview_Questionnaire_Data;
    /**
     * The Interview_Feedback_Rating_Reference
     * Meta information extracted from the WSDL
     * - documentation: The overall rating of an interview feedback.
     * - minOccurs: 0
     * @var \StructType\Interview_Feedback_RatingObjectType
     */
    public $Interview_Feedback_Rating_Reference;
    /**
     * The Overall_Comment
     * Meta information extracted from the WSDL
     * - documentation: The overall comment of the interview feedback.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Overall_Comment;
    /**
     * Constructor method for Interview_Feedback_DetailsType
     * @uses Interview_Feedback_DetailsType::setCompetency_Assessment_Data()
     * @uses Interview_Feedback_DetailsType::setInterview_Questionnaire_Data()
     * @uses Interview_Feedback_DetailsType::setInterview_Feedback_Rating_Reference()
     * @uses Interview_Feedback_DetailsType::setOverall_Comment()
     * @param \StructType\Competency_Assessment_DataType[] $competency_Assessment_Data
     * @param \StructType\Interview_Questionnaire_DataType[] $interview_Questionnaire_Data
     * @param \StructType\Interview_Feedback_RatingObjectType $interview_Feedback_Rating_Reference
     * @param string $overall_Comment
     */
    public function __construct(array $competency_Assessment_Data = array(), array $interview_Questionnaire_Data = array(), \StructType\Interview_Feedback_RatingObjectType $interview_Feedback_Rating_Reference = null, $overall_Comment = null)
    {
        $this
            ->setCompetency_Assessment_Data($competency_Assessment_Data)
            ->setInterview_Questionnaire_Data($interview_Questionnaire_Data)
            ->setInterview_Feedback_Rating_Reference($interview_Feedback_Rating_Reference)
            ->setOverall_Comment($overall_Comment);
    }
    /**
     * Get Competency_Assessment_Data value
     * @return \StructType\Competency_Assessment_DataType[]|null
     */
    public function getCompetency_Assessment_Data()
    {
        return $this->Competency_Assessment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCompetency_Assessment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompetency_Assessment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompetency_Assessment_DataForArrayConstraintsFromSetCompetency_Assessment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interview_Feedback_DetailsTypeCompetency_Assessment_DataItem) {
            // validation for constraint: itemType
            if (!$interview_Feedback_DetailsTypeCompetency_Assessment_DataItem instanceof \StructType\Competency_Assessment_DataType) {
                $invalidValues[] = is_object($interview_Feedback_DetailsTypeCompetency_Assessment_DataItem) ? get_class($interview_Feedback_DetailsTypeCompetency_Assessment_DataItem) : sprintf('%s(%s)', gettype($interview_Feedback_DetailsTypeCompetency_Assessment_DataItem), var_export($interview_Feedback_DetailsTypeCompetency_Assessment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Competency_Assessment_Data property can only contain items of type \StructType\Competency_Assessment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Competency_Assessment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Competency_Assessment_DataType[] $competency_Assessment_Data
     * @return \StructType\Interview_Feedback_DetailsType
     */
    public function setCompetency_Assessment_Data(array $competency_Assessment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($competency_Assessment_DataArrayErrorMessage = self::validateCompetency_Assessment_DataForArrayConstraintsFromSetCompetency_Assessment_Data($competency_Assessment_Data))) {
            throw new \InvalidArgumentException($competency_Assessment_DataArrayErrorMessage, __LINE__);
        }
        $this->Competency_Assessment_Data = $competency_Assessment_Data;
        return $this;
    }
    /**
     * Add item to Competency_Assessment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Competency_Assessment_DataType $item
     * @return \StructType\Interview_Feedback_DetailsType
     */
    public function addToCompetency_Assessment_Data(\StructType\Competency_Assessment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Competency_Assessment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Competency_Assessment_Data property can only contain items of type \StructType\Competency_Assessment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Competency_Assessment_Data[] = $item;
        return $this;
    }
    /**
     * Get Interview_Questionnaire_Data value
     * @return \StructType\Interview_Questionnaire_DataType[]|null
     */
    public function getInterview_Questionnaire_Data()
    {
        return $this->Interview_Questionnaire_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setInterview_Questionnaire_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterview_Questionnaire_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInterview_Questionnaire_DataForArrayConstraintsFromSetInterview_Questionnaire_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interview_Feedback_DetailsTypeInterview_Questionnaire_DataItem) {
            // validation for constraint: itemType
            if (!$interview_Feedback_DetailsTypeInterview_Questionnaire_DataItem instanceof \StructType\Interview_Questionnaire_DataType) {
                $invalidValues[] = is_object($interview_Feedback_DetailsTypeInterview_Questionnaire_DataItem) ? get_class($interview_Feedback_DetailsTypeInterview_Questionnaire_DataItem) : sprintf('%s(%s)', gettype($interview_Feedback_DetailsTypeInterview_Questionnaire_DataItem), var_export($interview_Feedback_DetailsTypeInterview_Questionnaire_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Interview_Questionnaire_Data property can only contain items of type \StructType\Interview_Questionnaire_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Interview_Questionnaire_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Interview_Questionnaire_DataType[] $interview_Questionnaire_Data
     * @return \StructType\Interview_Feedback_DetailsType
     */
    public function setInterview_Questionnaire_Data(array $interview_Questionnaire_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($interview_Questionnaire_DataArrayErrorMessage = self::validateInterview_Questionnaire_DataForArrayConstraintsFromSetInterview_Questionnaire_Data($interview_Questionnaire_Data))) {
            throw new \InvalidArgumentException($interview_Questionnaire_DataArrayErrorMessage, __LINE__);
        }
        $this->Interview_Questionnaire_Data = $interview_Questionnaire_Data;
        return $this;
    }
    /**
     * Add item to Interview_Questionnaire_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Interview_Questionnaire_DataType $item
     * @return \StructType\Interview_Feedback_DetailsType
     */
    public function addToInterview_Questionnaire_Data(\StructType\Interview_Questionnaire_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Interview_Questionnaire_DataType) {
            throw new \InvalidArgumentException(sprintf('The Interview_Questionnaire_Data property can only contain items of type \StructType\Interview_Questionnaire_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Interview_Questionnaire_Data[] = $item;
        return $this;
    }
    /**
     * Get Interview_Feedback_Rating_Reference value
     * @return \StructType\Interview_Feedback_RatingObjectType|null
     */
    public function getInterview_Feedback_Rating_Reference()
    {
        return $this->Interview_Feedback_Rating_Reference;
    }
    /**
     * Set Interview_Feedback_Rating_Reference value
     * @param \StructType\Interview_Feedback_RatingObjectType $interview_Feedback_Rating_Reference
     * @return \StructType\Interview_Feedback_DetailsType
     */
    public function setInterview_Feedback_Rating_Reference(\StructType\Interview_Feedback_RatingObjectType $interview_Feedback_Rating_Reference = null)
    {
        $this->Interview_Feedback_Rating_Reference = $interview_Feedback_Rating_Reference;
        return $this;
    }
    /**
     * Get Overall_Comment value
     * @return string|null
     */
    public function getOverall_Comment()
    {
        return $this->Overall_Comment;
    }
    /**
     * Set Overall_Comment value
     * @param string $overall_Comment
     * @return \StructType\Interview_Feedback_DetailsType
     */
    public function setOverall_Comment($overall_Comment = null)
    {
        // validation for constraint: string
        if (!is_null($overall_Comment) && !is_string($overall_Comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overall_Comment, true), gettype($overall_Comment)), __LINE__);
        }
        $this->Overall_Comment = $overall_Comment;
        return $this;
    }
}
