<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Interview_Feedback_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains one of the following: Interview Event Reference, Job Application Reference, or the Candidate Interview Criteria Data.
 * @subpackage Structs
 */
class Interview_Feedback_DataType extends AbstractStructBase
{
    /**
     * The Interview_Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an interview event.
     * - choice: Interview_Event_Reference | Job_Application_Reference | Candidate_Interview_Criteria_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Interview_Event_Reference;
    /**
     * The Job_Application_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Job Application associated to the interview.
     * - choice: Interview_Event_Reference | Job_Application_Reference | Candidate_Interview_Criteria_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Job_ApplicationObjectType
     */
    public $Job_Application_Reference;
    /**
     * The Candidate_Interview_Criteria_Data
     * Meta information extracted from the WSDL
     * - documentation: A Candidate and Job Requisition reference associated with the interview.
     * - choice: Interview_Event_Reference | Job_Application_Reference | Candidate_Interview_Criteria_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Move_Candidate_CriteriaType
     */
    public $Candidate_Interview_Criteria_Data;
    /**
     * The Interview_Feedback_Details_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains the interviewer reference and its feedback data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Interview_Feedback_Details_DataType[]
     */
    public $Interview_Feedback_Details_Data;
    /**
     * Constructor method for Interview_Feedback_DataType
     * @uses Interview_Feedback_DataType::setInterview_Event_Reference()
     * @uses Interview_Feedback_DataType::setJob_Application_Reference()
     * @uses Interview_Feedback_DataType::setCandidate_Interview_Criteria_Data()
     * @uses Interview_Feedback_DataType::setInterview_Feedback_Details_Data()
     * @param \StructType\Unique_IdentifierObjectType $interview_Event_Reference
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @param \StructType\Move_Candidate_CriteriaType $candidate_Interview_Criteria_Data
     * @param \StructType\Interview_Feedback_Details_DataType[] $interview_Feedback_Details_Data
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $interview_Event_Reference = null, \StructType\Job_ApplicationObjectType $job_Application_Reference = null, \StructType\Move_Candidate_CriteriaType $candidate_Interview_Criteria_Data = null, array $interview_Feedback_Details_Data = array())
    {
        $this
            ->setInterview_Event_Reference($interview_Event_Reference)
            ->setJob_Application_Reference($job_Application_Reference)
            ->setCandidate_Interview_Criteria_Data($candidate_Interview_Criteria_Data)
            ->setInterview_Feedback_Details_Data($interview_Feedback_Details_Data);
    }
    /**
     * Get Interview_Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getInterview_Event_Reference()
    {
        return isset($this->Interview_Event_Reference) ? $this->Interview_Event_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setInterview_Event_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterview_Event_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateInterview_Event_ReferenceForChoiceConstraintsFromSetInterview_Event_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Job_Application_Reference',
            'Candidate_Interview_Criteria_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Interview_Event_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Interview_Event_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Interview_Event_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $interview_Event_Reference
     * @return \StructType\Interview_Feedback_DataType
     */
    public function setInterview_Event_Reference(\StructType\Unique_IdentifierObjectType $interview_Event_Reference = null)
    {
        // validation for constraint: choice(Interview_Event_Reference, Job_Application_Reference, Candidate_Interview_Criteria_Data)
        if ('' !== ($interview_Event_ReferenceChoiceErrorMessage = self::validateInterview_Event_ReferenceForChoiceConstraintsFromSetInterview_Event_Reference($interview_Event_Reference))) {
            throw new \InvalidArgumentException($interview_Event_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($interview_Event_Reference) || (is_array($interview_Event_Reference) && empty($interview_Event_Reference))) {
            unset($this->Interview_Event_Reference);
        } else {
            $this->Interview_Event_Reference = $interview_Event_Reference;
        }
        return $this;
    }
    /**
     * Get Job_Application_Reference value
     * @return \StructType\Job_ApplicationObjectType|null
     */
    public function getJob_Application_Reference()
    {
        return isset($this->Job_Application_Reference) ? $this->Job_Application_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setJob_Application_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Application_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateJob_Application_ReferenceForChoiceConstraintsFromSetJob_Application_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Interview_Event_Reference',
            'Candidate_Interview_Criteria_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Job_Application_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Job_Application_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Job_Application_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @return \StructType\Interview_Feedback_DataType
     */
    public function setJob_Application_Reference(\StructType\Job_ApplicationObjectType $job_Application_Reference = null)
    {
        // validation for constraint: choice(Interview_Event_Reference, Job_Application_Reference, Candidate_Interview_Criteria_Data)
        if ('' !== ($job_Application_ReferenceChoiceErrorMessage = self::validateJob_Application_ReferenceForChoiceConstraintsFromSetJob_Application_Reference($job_Application_Reference))) {
            throw new \InvalidArgumentException($job_Application_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($job_Application_Reference) || (is_array($job_Application_Reference) && empty($job_Application_Reference))) {
            unset($this->Job_Application_Reference);
        } else {
            $this->Job_Application_Reference = $job_Application_Reference;
        }
        return $this;
    }
    /**
     * Get Candidate_Interview_Criteria_Data value
     * @return \StructType\Move_Candidate_CriteriaType|null
     */
    public function getCandidate_Interview_Criteria_Data()
    {
        return isset($this->Candidate_Interview_Criteria_Data) ? $this->Candidate_Interview_Criteria_Data : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCandidate_Interview_Criteria_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCandidate_Interview_Criteria_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCandidate_Interview_Criteria_DataForChoiceConstraintsFromSetCandidate_Interview_Criteria_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Interview_Event_Reference',
            'Job_Application_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Candidate_Interview_Criteria_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Candidate_Interview_Criteria_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Candidate_Interview_Criteria_Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Move_Candidate_CriteriaType $candidate_Interview_Criteria_Data
     * @return \StructType\Interview_Feedback_DataType
     */
    public function setCandidate_Interview_Criteria_Data(\StructType\Move_Candidate_CriteriaType $candidate_Interview_Criteria_Data = null)
    {
        // validation for constraint: choice(Interview_Event_Reference, Job_Application_Reference, Candidate_Interview_Criteria_Data)
        if ('' !== ($candidate_Interview_Criteria_DataChoiceErrorMessage = self::validateCandidate_Interview_Criteria_DataForChoiceConstraintsFromSetCandidate_Interview_Criteria_Data($candidate_Interview_Criteria_Data))) {
            throw new \InvalidArgumentException($candidate_Interview_Criteria_DataChoiceErrorMessage, __LINE__);
        }
        if (is_null($candidate_Interview_Criteria_Data) || (is_array($candidate_Interview_Criteria_Data) && empty($candidate_Interview_Criteria_Data))) {
            unset($this->Candidate_Interview_Criteria_Data);
        } else {
            $this->Candidate_Interview_Criteria_Data = $candidate_Interview_Criteria_Data;
        }
        return $this;
    }
    /**
     * Get Interview_Feedback_Details_Data value
     * @return \StructType\Interview_Feedback_Details_DataType[]|null
     */
    public function getInterview_Feedback_Details_Data()
    {
        return $this->Interview_Feedback_Details_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setInterview_Feedback_Details_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterview_Feedback_Details_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInterview_Feedback_Details_DataForArrayConstraintsFromSetInterview_Feedback_Details_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interview_Feedback_DataTypeInterview_Feedback_Details_DataItem) {
            // validation for constraint: itemType
            if (!$interview_Feedback_DataTypeInterview_Feedback_Details_DataItem instanceof \StructType\Interview_Feedback_Details_DataType) {
                $invalidValues[] = is_object($interview_Feedback_DataTypeInterview_Feedback_Details_DataItem) ? get_class($interview_Feedback_DataTypeInterview_Feedback_Details_DataItem) : sprintf('%s(%s)', gettype($interview_Feedback_DataTypeInterview_Feedback_Details_DataItem), var_export($interview_Feedback_DataTypeInterview_Feedback_Details_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Interview_Feedback_Details_Data property can only contain items of type \StructType\Interview_Feedback_Details_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Interview_Feedback_Details_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Interview_Feedback_Details_DataType[] $interview_Feedback_Details_Data
     * @return \StructType\Interview_Feedback_DataType
     */
    public function setInterview_Feedback_Details_Data(array $interview_Feedback_Details_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($interview_Feedback_Details_DataArrayErrorMessage = self::validateInterview_Feedback_Details_DataForArrayConstraintsFromSetInterview_Feedback_Details_Data($interview_Feedback_Details_Data))) {
            throw new \InvalidArgumentException($interview_Feedback_Details_DataArrayErrorMessage, __LINE__);
        }
        $this->Interview_Feedback_Details_Data = $interview_Feedback_Details_Data;
        return $this;
    }
    /**
     * Add item to Interview_Feedback_Details_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Interview_Feedback_Details_DataType $item
     * @return \StructType\Interview_Feedback_DataType
     */
    public function addToInterview_Feedback_Details_Data(\StructType\Interview_Feedback_Details_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Interview_Feedback_Details_DataType) {
            throw new \InvalidArgumentException(sprintf('The Interview_Feedback_Details_Data property can only contain items of type \StructType\Interview_Feedback_Details_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Interview_Feedback_Details_Data[] = $item;
        return $this;
    }
}
