<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Inline_Assessment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The data used to create or modify a Candidate Assessment
 * @subpackage Structs
 */
class Inline_Assessment_DataType extends AbstractStructBase
{
    /**
     * The Job_Application_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Candidate Assessment retrieved will be the one associated with this Job Application.
     * - minOccurs: 0
     * @var \StructType\Job_ApplicationObjectType
     */
    public $Job_Application_Reference;
    /**
     * The Candidate_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Candidate Assessments retrieved will be those associated with this Candidate.
     * - minOccurs: 0
     * @var \StructType\CandidateObjectType
     */
    public $Candidate_Reference;
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Candidate Assessments retrieved will be those associated with the Candidate for this Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_EnabledObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * The Job_Application_Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Candidate Assessment retrieved will be the one associated with this Job Application Event.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Job_Application_Event_Reference;
    /**
     * The Candidate_Assessment_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Recruiting_Assessment_DataType
     */
    public $Candidate_Assessment_Data;
    /**
     * Constructor method for Inline_Assessment_DataType
     * @uses Inline_Assessment_DataType::setJob_Application_Reference()
     * @uses Inline_Assessment_DataType::setCandidate_Reference()
     * @uses Inline_Assessment_DataType::setJob_Requisition_Reference()
     * @uses Inline_Assessment_DataType::setJob_Application_Event_Reference()
     * @uses Inline_Assessment_DataType::setCandidate_Assessment_Data()
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @param \StructType\CandidateObjectType $candidate_Reference
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @param \StructType\Unique_IdentifierObjectType $job_Application_Event_Reference
     * @param \StructType\Recruiting_Assessment_DataType $candidate_Assessment_Data
     */
    public function __construct(\StructType\Job_ApplicationObjectType $job_Application_Reference = null, \StructType\CandidateObjectType $candidate_Reference = null, \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null, \StructType\Unique_IdentifierObjectType $job_Application_Event_Reference = null, \StructType\Recruiting_Assessment_DataType $candidate_Assessment_Data = null)
    {
        $this
            ->setJob_Application_Reference($job_Application_Reference)
            ->setCandidate_Reference($candidate_Reference)
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setJob_Application_Event_Reference($job_Application_Event_Reference)
            ->setCandidate_Assessment_Data($candidate_Assessment_Data);
    }
    /**
     * Get Job_Application_Reference value
     * @return \StructType\Job_ApplicationObjectType|null
     */
    public function getJob_Application_Reference()
    {
        return $this->Job_Application_Reference;
    }
    /**
     * Set Job_Application_Reference value
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @return \StructType\Inline_Assessment_DataType
     */
    public function setJob_Application_Reference(\StructType\Job_ApplicationObjectType $job_Application_Reference = null)
    {
        $this->Job_Application_Reference = $job_Application_Reference;
        return $this;
    }
    /**
     * Get Candidate_Reference value
     * @return \StructType\CandidateObjectType|null
     */
    public function getCandidate_Reference()
    {
        return $this->Candidate_Reference;
    }
    /**
     * Set Candidate_Reference value
     * @param \StructType\CandidateObjectType $candidate_Reference
     * @return \StructType\Inline_Assessment_DataType
     */
    public function setCandidate_Reference(\StructType\CandidateObjectType $candidate_Reference = null)
    {
        $this->Candidate_Reference = $candidate_Reference;
        return $this;
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_Requisition_EnabledObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference
     * @return \StructType\Inline_Assessment_DataType
     */
    public function setJob_Requisition_Reference(\StructType\Job_Requisition_EnabledObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Get Job_Application_Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getJob_Application_Event_Reference()
    {
        return $this->Job_Application_Event_Reference;
    }
    /**
     * Set Job_Application_Event_Reference value
     * @param \StructType\Unique_IdentifierObjectType $job_Application_Event_Reference
     * @return \StructType\Inline_Assessment_DataType
     */
    public function setJob_Application_Event_Reference(\StructType\Unique_IdentifierObjectType $job_Application_Event_Reference = null)
    {
        $this->Job_Application_Event_Reference = $job_Application_Event_Reference;
        return $this;
    }
    /**
     * Get Candidate_Assessment_Data value
     * @return \StructType\Recruiting_Assessment_DataType|null
     */
    public function getCandidate_Assessment_Data()
    {
        return $this->Candidate_Assessment_Data;
    }
    /**
     * Set Candidate_Assessment_Data value
     * @param \StructType\Recruiting_Assessment_DataType $candidate_Assessment_Data
     * @return \StructType\Inline_Assessment_DataType
     */
    public function setCandidate_Assessment_Data(\StructType\Recruiting_Assessment_DataType $candidate_Assessment_Data = null)
    {
        $this->Candidate_Assessment_Data = $candidate_Assessment_Data;
        return $this;
    }
}
