<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get_Recruiting_Agency_Additional_Data_RequestType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Outer Container which holds all data and criteria for retrieving Recruiting Agency additional data.
 * @subpackage Structs
 */
class Get_Recruiting_Agency_Additional_Data_RequestType extends AbstractStructBase
{
    /**
     * The Request_References
     * Meta information extracted from the WSDL
     * - documentation: Request References
     * - minOccurs: 0
     * @var \StructType\Recruiting_Agency_Request_ReferencesType
     */
    public $Request_References;
    /**
     * The Request_Criteria
     * Meta information extracted from the WSDL
     * - documentation: Request Criteria
     * - minOccurs: 0
     * @var \StructType\Recruiting_Agency_Request_CriteriaType
     */
    public $Request_Criteria;
    /**
     * The Response_Filter
     * Meta information extracted from the WSDL
     * - documentation: Response Filter
     * - choice: Response_Filter | Response_Group
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Response_FilterType
     */
    public $Response_Filter;
    /**
     * The Response_Group
     * Meta information extracted from the WSDL
     * - documentation: Response Group
     * - choice: Response_Filter | Response_Group
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Recruiting_Agency_User_Response_GroupType
     */
    public $Response_Group;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Get_Recruiting_Agency_Additional_Data_RequestType
     * @uses Get_Recruiting_Agency_Additional_Data_RequestType::setRequest_References()
     * @uses Get_Recruiting_Agency_Additional_Data_RequestType::setRequest_Criteria()
     * @uses Get_Recruiting_Agency_Additional_Data_RequestType::setResponse_Filter()
     * @uses Get_Recruiting_Agency_Additional_Data_RequestType::setResponse_Group()
     * @uses Get_Recruiting_Agency_Additional_Data_RequestType::setVersion()
     * @param \StructType\Recruiting_Agency_Request_ReferencesType $request_References
     * @param \StructType\Recruiting_Agency_Request_CriteriaType $request_Criteria
     * @param \StructType\Response_FilterType $response_Filter
     * @param \StructType\Recruiting_Agency_User_Response_GroupType $response_Group
     * @param string $version
     */
    public function __construct(\StructType\Recruiting_Agency_Request_ReferencesType $request_References = null, \StructType\Recruiting_Agency_Request_CriteriaType $request_Criteria = null, \StructType\Response_FilterType $response_Filter = null, \StructType\Recruiting_Agency_User_Response_GroupType $response_Group = null, $version = null)
    {
        $this
            ->setRequest_References($request_References)
            ->setRequest_Criteria($request_Criteria)
            ->setResponse_Filter($response_Filter)
            ->setResponse_Group($response_Group)
            ->setVersion($version);
    }
    /**
     * Get Request_References value
     * @return \StructType\Recruiting_Agency_Request_ReferencesType|null
     */
    public function getRequest_References()
    {
        return $this->Request_References;
    }
    /**
     * Set Request_References value
     * @param \StructType\Recruiting_Agency_Request_ReferencesType $request_References
     * @return \StructType\Get_Recruiting_Agency_Additional_Data_RequestType
     */
    public function setRequest_References(\StructType\Recruiting_Agency_Request_ReferencesType $request_References = null)
    {
        $this->Request_References = $request_References;
        return $this;
    }
    /**
     * Get Request_Criteria value
     * @return \StructType\Recruiting_Agency_Request_CriteriaType|null
     */
    public function getRequest_Criteria()
    {
        return $this->Request_Criteria;
    }
    /**
     * Set Request_Criteria value
     * @param \StructType\Recruiting_Agency_Request_CriteriaType $request_Criteria
     * @return \StructType\Get_Recruiting_Agency_Additional_Data_RequestType
     */
    public function setRequest_Criteria(\StructType\Recruiting_Agency_Request_CriteriaType $request_Criteria = null)
    {
        $this->Request_Criteria = $request_Criteria;
        return $this;
    }
    /**
     * Get Response_Filter value
     * @return \StructType\Response_FilterType|null
     */
    public function getResponse_Filter()
    {
        return isset($this->Response_Filter) ? $this->Response_Filter : null;
    }
    /**
     * This method is responsible for validating the value passed to the setResponse_Filter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResponse_Filter method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateResponse_FilterForChoiceConstraintsFromSetResponse_Filter($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Response_Group',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Response_Filter can\'t be set as the property %s is already set. Only one property must be set among these properties: Response_Filter, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Response_Filter value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Response_FilterType $response_Filter
     * @return \StructType\Get_Recruiting_Agency_Additional_Data_RequestType
     */
    public function setResponse_Filter(\StructType\Response_FilterType $response_Filter = null)
    {
        // validation for constraint: choice(Response_Filter, Response_Group)
        if ('' !== ($response_FilterChoiceErrorMessage = self::validateResponse_FilterForChoiceConstraintsFromSetResponse_Filter($response_Filter))) {
            throw new \InvalidArgumentException($response_FilterChoiceErrorMessage, __LINE__);
        }
        if (is_null($response_Filter) || (is_array($response_Filter) && empty($response_Filter))) {
            unset($this->Response_Filter);
        } else {
            $this->Response_Filter = $response_Filter;
        }
        return $this;
    }
    /**
     * Get Response_Group value
     * @return \StructType\Recruiting_Agency_User_Response_GroupType|null
     */
    public function getResponse_Group()
    {
        return isset($this->Response_Group) ? $this->Response_Group : null;
    }
    /**
     * This method is responsible for validating the value passed to the setResponse_Group method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResponse_Group method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateResponse_GroupForChoiceConstraintsFromSetResponse_Group($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Response_Filter',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Response_Group can\'t be set as the property %s is already set. Only one property must be set among these properties: Response_Group, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Response_Group value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Recruiting_Agency_User_Response_GroupType $response_Group
     * @return \StructType\Get_Recruiting_Agency_Additional_Data_RequestType
     */
    public function setResponse_Group(\StructType\Recruiting_Agency_User_Response_GroupType $response_Group = null)
    {
        // validation for constraint: choice(Response_Filter, Response_Group)
        if ('' !== ($response_GroupChoiceErrorMessage = self::validateResponse_GroupForChoiceConstraintsFromSetResponse_Group($response_Group))) {
            throw new \InvalidArgumentException($response_GroupChoiceErrorMessage, __LINE__);
        }
        if (is_null($response_Group) || (is_array($response_Group) && empty($response_Group))) {
            unset($this->Response_Group);
        } else {
            $this->Response_Group = $response_Group;
        }
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Get_Recruiting_Agency_Additional_Data_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
