<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Evergreen_Job_Requisition_Request_ReferencesType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Utilize the Request References element to retrieve a specific instance(s) of Evergreen Requisition and its associated data.
 * @subpackage Structs
 */
class Evergreen_Job_Requisition_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Evergreen_Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier for an Evergreen Requisition requested.
     * - maxOccurs: unbounded
     * @var \StructType\Evergreen_Job_RequisitionObjectType[]
     */
    public $Evergreen_Job_Requisition_Reference;
    /**
     * The Skip_Non_Existing_Instances
     * @var bool
     */
    public $Skip_Non_Existing_Instances;
    /**
     * Constructor method for Evergreen_Job_Requisition_Request_ReferencesType
     * @uses Evergreen_Job_Requisition_Request_ReferencesType::setEvergreen_Job_Requisition_Reference()
     * @uses Evergreen_Job_Requisition_Request_ReferencesType::setSkip_Non_Existing_Instances()
     * @param \StructType\Evergreen_Job_RequisitionObjectType[] $evergreen_Job_Requisition_Reference
     * @param bool $skip_Non_Existing_Instances
     */
    public function __construct(array $evergreen_Job_Requisition_Reference = array(), $skip_Non_Existing_Instances = null)
    {
        $this
            ->setEvergreen_Job_Requisition_Reference($evergreen_Job_Requisition_Reference)
            ->setSkip_Non_Existing_Instances($skip_Non_Existing_Instances);
    }
    /**
     * Get Evergreen_Job_Requisition_Reference value
     * @return \StructType\Evergreen_Job_RequisitionObjectType[]|null
     */
    public function getEvergreen_Job_Requisition_Reference()
    {
        return $this->Evergreen_Job_Requisition_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setEvergreen_Job_Requisition_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEvergreen_Job_Requisition_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEvergreen_Job_Requisition_ReferenceForArrayConstraintsFromSetEvergreen_Job_Requisition_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $evergreen_Job_Requisition_Request_ReferencesTypeEvergreen_Job_Requisition_ReferenceItem) {
            // validation for constraint: itemType
            if (!$evergreen_Job_Requisition_Request_ReferencesTypeEvergreen_Job_Requisition_ReferenceItem instanceof \StructType\Evergreen_Job_RequisitionObjectType) {
                $invalidValues[] = is_object($evergreen_Job_Requisition_Request_ReferencesTypeEvergreen_Job_Requisition_ReferenceItem) ? get_class($evergreen_Job_Requisition_Request_ReferencesTypeEvergreen_Job_Requisition_ReferenceItem) : sprintf('%s(%s)', gettype($evergreen_Job_Requisition_Request_ReferencesTypeEvergreen_Job_Requisition_ReferenceItem), var_export($evergreen_Job_Requisition_Request_ReferencesTypeEvergreen_Job_Requisition_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Evergreen_Job_Requisition_Reference property can only contain items of type \StructType\Evergreen_Job_RequisitionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Evergreen_Job_Requisition_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Evergreen_Job_RequisitionObjectType[] $evergreen_Job_Requisition_Reference
     * @return \StructType\Evergreen_Job_Requisition_Request_ReferencesType
     */
    public function setEvergreen_Job_Requisition_Reference(array $evergreen_Job_Requisition_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($evergreen_Job_Requisition_ReferenceArrayErrorMessage = self::validateEvergreen_Job_Requisition_ReferenceForArrayConstraintsFromSetEvergreen_Job_Requisition_Reference($evergreen_Job_Requisition_Reference))) {
            throw new \InvalidArgumentException($evergreen_Job_Requisition_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Evergreen_Job_Requisition_Reference = $evergreen_Job_Requisition_Reference;
        return $this;
    }
    /**
     * Add item to Evergreen_Job_Requisition_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Evergreen_Job_RequisitionObjectType $item
     * @return \StructType\Evergreen_Job_Requisition_Request_ReferencesType
     */
    public function addToEvergreen_Job_Requisition_Reference(\StructType\Evergreen_Job_RequisitionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Evergreen_Job_RequisitionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Evergreen_Job_Requisition_Reference property can only contain items of type \StructType\Evergreen_Job_RequisitionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Evergreen_Job_Requisition_Reference[] = $item;
        return $this;
    }
    /**
     * Get Skip_Non_Existing_Instances value
     * @return bool|null
     */
    public function getSkip_Non_Existing_Instances()
    {
        return $this->Skip_Non_Existing_Instances;
    }
    /**
     * Set Skip_Non_Existing_Instances value
     * @param bool $skip_Non_Existing_Instances
     * @return \StructType\Evergreen_Job_Requisition_Request_ReferencesType
     */
    public function setSkip_Non_Existing_Instances($skip_Non_Existing_Instances = null)
    {
        // validation for constraint: boolean
        if (!is_null($skip_Non_Existing_Instances) && !is_bool($skip_Non_Existing_Instances)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skip_Non_Existing_Instances, true), gettype($skip_Non_Existing_Instances)), __LINE__);
        }
        $this->Skip_Non_Existing_Instances = $skip_Non_Existing_Instances;
        return $this;
    }
}
