<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Evergreen_Job_Requisition_Data_for_Create_and_EditType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper for Job Requisition data common to create and edit requests.
 * @subpackage Structs
 */
class Evergreen_Job_Requisition_Data_for_Create_and_EditType extends AbstractStructBase
{
    /**
     * The Job_Requisition_ID
     * Meta information extracted from the WSDL
     * - documentation: The ID for the job requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Requisition_ID;
    /**
     * The Job_Posting_Title
     * Meta information extracted from the WSDL
     * - documentation: The job posting title for the job requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Posting_Title;
    /**
     * The Recruiting_Instruction_Reference
     * Meta information extracted from the WSDL
     * - documentation: Define an optional recruiting instruction on the Maintain External Recruiting Instructions task.
     * - minOccurs: 0
     * @var \StructType\Recruiting_InstructionObjectType
     */
    public $Recruiting_Instruction_Reference;
    /**
     * The Job_Description_Summary
     * Meta information extracted from the WSDL
     * - documentation: The job description summary (plain text) for the job requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Description_Summary;
    /**
     * The Job_Description
     * Meta information extracted from the WSDL
     * - documentation: The job description (rich text) for the job requisition.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Description;
    /**
     * The Additional_Job_Description
     * Meta information extracted from the WSDL
     * - documentation: The Additional Job Description is only available when the Recruiting functional area is enabled. Use job posting templates to control where the Additional Job Description displays. Example: Define a Job Description for external job
     * postings and an Additional Job Description for internal job postings.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Additional_Job_Description;
    /**
     * The Justification
     * Meta information extracted from the WSDL
     * - documentation: The justification for the job requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Justification;
    /**
     * The Job_Requisition_Attachments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_AttachmentsType[]
     */
    public $Job_Requisition_Attachments;
    /**
     * The Recruiting_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: The date from which pre-hires can be considered for this job requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Recruiting_Start_Date;
    /**
     * The Target_Hire_Date
     * Meta information extracted from the WSDL
     * - documentation: The date from which pre-hires can be hired or contracted for this job requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Target_Hire_Date;
    /**
     * The Target_End_Date
     * Meta information extracted from the WSDL
     * - documentation: The date when recruiting ends.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Target_End_Date;
    /**
     * The Job_Profile_Reference
     * Meta information extracted from the WSDL
     * - documentation: The job profile for the job requisition. If empty, Workday automatically populates this value from the position restrictions.
     * - minOccurs: 0
     * @var \StructType\Job_ProfileObjectType
     */
    public $Job_Profile_Reference;
    /**
     * The Additional_Job_Profiles_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Additional Job Profiles for the job requisition. Cannot contain the Primary Job Profile.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_ProfileObjectType[]
     */
    public $Additional_Job_Profiles_Reference;
    /**
     * The Worker_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The worker type for the job requisition. If empty, Workday automatically populates this value from the position restrictions.
     * - minOccurs: 0
     * @var \StructType\Worker_TypeObjectType
     */
    public $Worker_Type_Reference;
    /**
     * The Worker_Sub_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The worker sub-type for the job requisition. If empty, Workday automatically populates this value from the position restrictions.
     * - minOccurs: 0
     * @var \StructType\Position_Worker_TypeObjectType
     */
    public $Worker_Sub_Type_Reference;
    /**
     * The Primary_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: The primary location for the evergreen requisition.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Primary_Location_Reference;
    /**
     * The Primary_Job_Posting_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: The primary job posting location for the evergreen requisition. When creating an evergreen requisition, if empty, Workday automatically populates this value from the primary location of the evergreen requisition.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Primary_Job_Posting_Location_Reference;
    /**
     * The Additional_Locations_Reference
     * Meta information extracted from the WSDL
     * - documentation: The additional location(s) for the evergreen requisition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LocationObjectType[]
     */
    public $Additional_Locations_Reference;
    /**
     * The Additional_Job_Posting_Locations_Reference
     * Meta information extracted from the WSDL
     * - documentation: The additional job posting location(s) for the ~evergreen requisition~. When creating an ~evergreen requisition~, if empty, Workday automatically populates this value from the additional location(s) of the ~evergreen requisition~.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LocationObjectType[]
     */
    public $Additional_Job_Posting_Locations_Reference;
    /**
     * The Position_Time_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The position time type for the job requisition. If empty, Workday automatically populates this value from the position restrictions.
     * - minOccurs: 0
     * @var \StructType\Position_Time_TypeObjectType
     */
    public $Position_Time_Type_Reference;
    /**
     * The Employee_Contract_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The employee contract type for the job requisition.
     * - minOccurs: 0
     * @var \StructType\Employee_Contract_TypeObjectType
     */
    public $Employee_Contract_Type_Reference;
    /**
     * The Scheduled_Weekly_Hours
     * Meta information extracted from the WSDL
     * - documentation: The Schedule Hours for the Job Requisition. | The scheduled weekly hours for the job requisition. If empty, Workday automatically populates this value from the position restrictions. | The scheduled weekly hours associated with the
     * offer
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 14
     * @var float
     */
    public $Scheduled_Weekly_Hours;
    /**
     * The Work_Shift_Reference
     * Meta information extracted from the WSDL
     * - documentation: The worker type for the job requisition. If empty, Workday automatically populates this value from the position restrictions.
     * - minOccurs: 0
     * @var \StructType\Work_ShiftObjectType
     */
    public $Work_Shift_Reference;
    /**
     * The Spotlight_Job
     * Meta information extracted from the WSDL
     * - documentation: If Y, indicates that this is a highlighted job requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Spotlight_Job;
    /**
     * The Job_Requisition_Links_to_Add_Reference
     * Meta information extracted from the WSDL
     * - documentation: Job Requisitions which will be linked to the Evergreen Requisition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_RequisitionObjectType[]
     */
    public $Job_Requisition_Links_to_Add_Reference;
    /**
     * The Job_Requisition_Links_to_Remove_Reference
     * Meta information extracted from the WSDL
     * - documentation: Job Requisitions which are linked to the Evergreen Requisition which will be unlinked.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_RequisitionObjectType[]
     */
    public $Job_Requisition_Links_to_Remove_Reference;
    /**
     * The Questionnaire_Data
     * Meta information extracted from the WSDL
     * - documentation: Questionnaires for the Job Requisition. For use by Recruiting customers only.
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_Questionnaire_DataType
     */
    public $Questionnaire_Data;
    /**
     * The Assessment_Data
     * Meta information extracted from the WSDL
     * - documentation: Assessments for the Job Requisition. For use by Recruiting customers only.
     * - minOccurs: 0
     * @var \StructType\Job_Requisition_Assessment_DataType
     */
    public $Assessment_Data;
    /**
     * The Qualification_Replacement_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing the qualification data for the job requisition.
     * - minOccurs: 0
     * @var \StructType\Qualification_Data_for_Position_Restriction_or_Job_ProfileType
     */
    public $Qualification_Replacement_Data;
    /**
     * The Organization_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing the organization data for the Evergreen Job Requisition. Organizations can only be assigned to Evergreen Job Requisitions for Supervisory Organization using the Job Management staffing model.
     * - minOccurs: 0
     * @var \StructType\Evergreen_Job_Requisition_Organizations_Data_for_Business_ProcessType
     */
    public $Organization_Data;
    /**
     * The Use_Updated_Template_Version
     * Meta information extracted from the WSDL
     * - documentation: If yes, this updates the existing template on job requisition to the most recent version.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Updated_Template_Version;
    /**
     * The Job_Application_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Clear the Job Application Template field because you can't add a job application template when you are creating a job requisition. | You can only add a job application template when editing a job requisition.
     * - minOccurs: 0
     * @var \StructType\Job_Application_TemplateObjectType
     */
    public $Job_Application_Template_Reference;
    /**
     * Constructor method for Evergreen_Job_Requisition_Data_for_Create_and_EditType
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setJob_Requisition_ID()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setJob_Posting_Title()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setRecruiting_Instruction_Reference()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setJob_Description_Summary()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setJob_Description()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setAdditional_Job_Description()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setJustification()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setJob_Requisition_Attachments()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setRecruiting_Start_Date()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setTarget_Hire_Date()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setTarget_End_Date()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setJob_Profile_Reference()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setAdditional_Job_Profiles_Reference()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setWorker_Type_Reference()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setWorker_Sub_Type_Reference()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setPrimary_Location_Reference()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setPrimary_Job_Posting_Location_Reference()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setAdditional_Locations_Reference()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setAdditional_Job_Posting_Locations_Reference()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setPosition_Time_Type_Reference()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setEmployee_Contract_Type_Reference()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setScheduled_Weekly_Hours()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setWork_Shift_Reference()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setSpotlight_Job()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setJob_Requisition_Links_to_Add_Reference()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setJob_Requisition_Links_to_Remove_Reference()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setQuestionnaire_Data()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setAssessment_Data()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setQualification_Replacement_Data()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setOrganization_Data()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setUse_Updated_Template_Version()
     * @uses Evergreen_Job_Requisition_Data_for_Create_and_EditType::setJob_Application_Template_Reference()
     * @param string $job_Requisition_ID
     * @param string $job_Posting_Title
     * @param \StructType\Recruiting_InstructionObjectType $recruiting_Instruction_Reference
     * @param string $job_Description_Summary
     * @param string $job_Description
     * @param string $additional_Job_Description
     * @param string $justification
     * @param \StructType\Job_Requisition_AttachmentsType[] $job_Requisition_Attachments
     * @param string $recruiting_Start_Date
     * @param string $target_Hire_Date
     * @param string $target_End_Date
     * @param \StructType\Job_ProfileObjectType $job_Profile_Reference
     * @param \StructType\Job_ProfileObjectType[] $additional_Job_Profiles_Reference
     * @param \StructType\Worker_TypeObjectType $worker_Type_Reference
     * @param \StructType\Position_Worker_TypeObjectType $worker_Sub_Type_Reference
     * @param \StructType\LocationObjectType $primary_Location_Reference
     * @param \StructType\LocationObjectType $primary_Job_Posting_Location_Reference
     * @param \StructType\LocationObjectType[] $additional_Locations_Reference
     * @param \StructType\LocationObjectType[] $additional_Job_Posting_Locations_Reference
     * @param \StructType\Position_Time_TypeObjectType $position_Time_Type_Reference
     * @param \StructType\Employee_Contract_TypeObjectType $employee_Contract_Type_Reference
     * @param float $scheduled_Weekly_Hours
     * @param \StructType\Work_ShiftObjectType $work_Shift_Reference
     * @param bool $spotlight_Job
     * @param \StructType\Job_RequisitionObjectType[] $job_Requisition_Links_to_Add_Reference
     * @param \StructType\Job_RequisitionObjectType[] $job_Requisition_Links_to_Remove_Reference
     * @param \StructType\Job_Requisition_Questionnaire_DataType $questionnaire_Data
     * @param \StructType\Job_Requisition_Assessment_DataType $assessment_Data
     * @param \StructType\Qualification_Data_for_Position_Restriction_or_Job_ProfileType $qualification_Replacement_Data
     * @param \StructType\Evergreen_Job_Requisition_Organizations_Data_for_Business_ProcessType $organization_Data
     * @param bool $use_Updated_Template_Version
     * @param \StructType\Job_Application_TemplateObjectType $job_Application_Template_Reference
     */
    public function __construct($job_Requisition_ID = null, $job_Posting_Title = null, \StructType\Recruiting_InstructionObjectType $recruiting_Instruction_Reference = null, $job_Description_Summary = null, $job_Description = null, $additional_Job_Description = null, $justification = null, array $job_Requisition_Attachments = array(), $recruiting_Start_Date = null, $target_Hire_Date = null, $target_End_Date = null, \StructType\Job_ProfileObjectType $job_Profile_Reference = null, array $additional_Job_Profiles_Reference = array(), \StructType\Worker_TypeObjectType $worker_Type_Reference = null, \StructType\Position_Worker_TypeObjectType $worker_Sub_Type_Reference = null, \StructType\LocationObjectType $primary_Location_Reference = null, \StructType\LocationObjectType $primary_Job_Posting_Location_Reference = null, array $additional_Locations_Reference = array(), array $additional_Job_Posting_Locations_Reference = array(), \StructType\Position_Time_TypeObjectType $position_Time_Type_Reference = null, \StructType\Employee_Contract_TypeObjectType $employee_Contract_Type_Reference = null, $scheduled_Weekly_Hours = null, \StructType\Work_ShiftObjectType $work_Shift_Reference = null, $spotlight_Job = null, array $job_Requisition_Links_to_Add_Reference = array(), array $job_Requisition_Links_to_Remove_Reference = array(), \StructType\Job_Requisition_Questionnaire_DataType $questionnaire_Data = null, \StructType\Job_Requisition_Assessment_DataType $assessment_Data = null, \StructType\Qualification_Data_for_Position_Restriction_or_Job_ProfileType $qualification_Replacement_Data = null, \StructType\Evergreen_Job_Requisition_Organizations_Data_for_Business_ProcessType $organization_Data = null, $use_Updated_Template_Version = null, \StructType\Job_Application_TemplateObjectType $job_Application_Template_Reference = null)
    {
        $this
            ->setJob_Requisition_ID($job_Requisition_ID)
            ->setJob_Posting_Title($job_Posting_Title)
            ->setRecruiting_Instruction_Reference($recruiting_Instruction_Reference)
            ->setJob_Description_Summary($job_Description_Summary)
            ->setJob_Description($job_Description)
            ->setAdditional_Job_Description($additional_Job_Description)
            ->setJustification($justification)
            ->setJob_Requisition_Attachments($job_Requisition_Attachments)
            ->setRecruiting_Start_Date($recruiting_Start_Date)
            ->setTarget_Hire_Date($target_Hire_Date)
            ->setTarget_End_Date($target_End_Date)
            ->setJob_Profile_Reference($job_Profile_Reference)
            ->setAdditional_Job_Profiles_Reference($additional_Job_Profiles_Reference)
            ->setWorker_Type_Reference($worker_Type_Reference)
            ->setWorker_Sub_Type_Reference($worker_Sub_Type_Reference)
            ->setPrimary_Location_Reference($primary_Location_Reference)
            ->setPrimary_Job_Posting_Location_Reference($primary_Job_Posting_Location_Reference)
            ->setAdditional_Locations_Reference($additional_Locations_Reference)
            ->setAdditional_Job_Posting_Locations_Reference($additional_Job_Posting_Locations_Reference)
            ->setPosition_Time_Type_Reference($position_Time_Type_Reference)
            ->setEmployee_Contract_Type_Reference($employee_Contract_Type_Reference)
            ->setScheduled_Weekly_Hours($scheduled_Weekly_Hours)
            ->setWork_Shift_Reference($work_Shift_Reference)
            ->setSpotlight_Job($spotlight_Job)
            ->setJob_Requisition_Links_to_Add_Reference($job_Requisition_Links_to_Add_Reference)
            ->setJob_Requisition_Links_to_Remove_Reference($job_Requisition_Links_to_Remove_Reference)
            ->setQuestionnaire_Data($questionnaire_Data)
            ->setAssessment_Data($assessment_Data)
            ->setQualification_Replacement_Data($qualification_Replacement_Data)
            ->setOrganization_Data($organization_Data)
            ->setUse_Updated_Template_Version($use_Updated_Template_Version)
            ->setJob_Application_Template_Reference($job_Application_Template_Reference);
    }
    /**
     * Get Job_Requisition_ID value
     * @return string|null
     */
    public function getJob_Requisition_ID()
    {
        return $this->Job_Requisition_ID;
    }
    /**
     * Set Job_Requisition_ID value
     * @param string $job_Requisition_ID
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setJob_Requisition_ID($job_Requisition_ID = null)
    {
        // validation for constraint: string
        if (!is_null($job_Requisition_ID) && !is_string($job_Requisition_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Requisition_ID, true), gettype($job_Requisition_ID)), __LINE__);
        }
        $this->Job_Requisition_ID = $job_Requisition_ID;
        return $this;
    }
    /**
     * Get Job_Posting_Title value
     * @return string|null
     */
    public function getJob_Posting_Title()
    {
        return $this->Job_Posting_Title;
    }
    /**
     * Set Job_Posting_Title value
     * @param string $job_Posting_Title
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setJob_Posting_Title($job_Posting_Title = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_Title) && !is_string($job_Posting_Title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_Title, true), gettype($job_Posting_Title)), __LINE__);
        }
        $this->Job_Posting_Title = $job_Posting_Title;
        return $this;
    }
    /**
     * Get Recruiting_Instruction_Reference value
     * @return \StructType\Recruiting_InstructionObjectType|null
     */
    public function getRecruiting_Instruction_Reference()
    {
        return $this->Recruiting_Instruction_Reference;
    }
    /**
     * Set Recruiting_Instruction_Reference value
     * @param \StructType\Recruiting_InstructionObjectType $recruiting_Instruction_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setRecruiting_Instruction_Reference(\StructType\Recruiting_InstructionObjectType $recruiting_Instruction_Reference = null)
    {
        $this->Recruiting_Instruction_Reference = $recruiting_Instruction_Reference;
        return $this;
    }
    /**
     * Get Job_Description_Summary value
     * @return string|null
     */
    public function getJob_Description_Summary()
    {
        return $this->Job_Description_Summary;
    }
    /**
     * Set Job_Description_Summary value
     * @param string $job_Description_Summary
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setJob_Description_Summary($job_Description_Summary = null)
    {
        // validation for constraint: string
        if (!is_null($job_Description_Summary) && !is_string($job_Description_Summary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Description_Summary, true), gettype($job_Description_Summary)), __LINE__);
        }
        $this->Job_Description_Summary = $job_Description_Summary;
        return $this;
    }
    /**
     * Get Job_Description value
     * @return string|null
     */
    public function getJob_Description()
    {
        return $this->Job_Description;
    }
    /**
     * Set Job_Description value
     * @param string $job_Description
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setJob_Description($job_Description = null)
    {
        // validation for constraint: string
        if (!is_null($job_Description) && !is_string($job_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Description, true), gettype($job_Description)), __LINE__);
        }
        $this->Job_Description = $job_Description;
        return $this;
    }
    /**
     * Get Additional_Job_Description value
     * @return string|null
     */
    public function getAdditional_Job_Description()
    {
        return $this->Additional_Job_Description;
    }
    /**
     * Set Additional_Job_Description value
     * @param string $additional_Job_Description
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setAdditional_Job_Description($additional_Job_Description = null)
    {
        // validation for constraint: string
        if (!is_null($additional_Job_Description) && !is_string($additional_Job_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additional_Job_Description, true), gettype($additional_Job_Description)), __LINE__);
        }
        $this->Additional_Job_Description = $additional_Job_Description;
        return $this;
    }
    /**
     * Get Justification value
     * @return string|null
     */
    public function getJustification()
    {
        return $this->Justification;
    }
    /**
     * Set Justification value
     * @param string $justification
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setJustification($justification = null)
    {
        // validation for constraint: string
        if (!is_null($justification) && !is_string($justification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($justification, true), gettype($justification)), __LINE__);
        }
        $this->Justification = $justification;
        return $this;
    }
    /**
     * Get Job_Requisition_Attachments value
     * @return \StructType\Job_Requisition_AttachmentsType[]|null
     */
    public function getJob_Requisition_Attachments()
    {
        return $this->Job_Requisition_Attachments;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Requisition_Attachments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Requisition_Attachments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Requisition_AttachmentsForArrayConstraintsFromSetJob_Requisition_Attachments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $evergreen_Job_Requisition_Data_for_Create_and_EditTypeJob_Requisition_AttachmentsItem) {
            // validation for constraint: itemType
            if (!$evergreen_Job_Requisition_Data_for_Create_and_EditTypeJob_Requisition_AttachmentsItem instanceof \StructType\Job_Requisition_AttachmentsType) {
                $invalidValues[] = is_object($evergreen_Job_Requisition_Data_for_Create_and_EditTypeJob_Requisition_AttachmentsItem) ? get_class($evergreen_Job_Requisition_Data_for_Create_and_EditTypeJob_Requisition_AttachmentsItem) : sprintf('%s(%s)', gettype($evergreen_Job_Requisition_Data_for_Create_and_EditTypeJob_Requisition_AttachmentsItem), var_export($evergreen_Job_Requisition_Data_for_Create_and_EditTypeJob_Requisition_AttachmentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Requisition_Attachments property can only contain items of type \StructType\Job_Requisition_AttachmentsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Requisition_Attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_AttachmentsType[] $job_Requisition_Attachments
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setJob_Requisition_Attachments(array $job_Requisition_Attachments = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Requisition_AttachmentsArrayErrorMessage = self::validateJob_Requisition_AttachmentsForArrayConstraintsFromSetJob_Requisition_Attachments($job_Requisition_Attachments))) {
            throw new \InvalidArgumentException($job_Requisition_AttachmentsArrayErrorMessage, __LINE__);
        }
        $this->Job_Requisition_Attachments = $job_Requisition_Attachments;
        return $this;
    }
    /**
     * Add item to Job_Requisition_Attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_AttachmentsType $item
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function addToJob_Requisition_Attachments(\StructType\Job_Requisition_AttachmentsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Requisition_AttachmentsType) {
            throw new \InvalidArgumentException(sprintf('The Job_Requisition_Attachments property can only contain items of type \StructType\Job_Requisition_AttachmentsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Requisition_Attachments[] = $item;
        return $this;
    }
    /**
     * Get Recruiting_Start_Date value
     * @return string|null
     */
    public function getRecruiting_Start_Date()
    {
        return $this->Recruiting_Start_Date;
    }
    /**
     * Set Recruiting_Start_Date value
     * @param string $recruiting_Start_Date
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setRecruiting_Start_Date($recruiting_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($recruiting_Start_Date) && !is_string($recruiting_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recruiting_Start_Date, true), gettype($recruiting_Start_Date)), __LINE__);
        }
        $this->Recruiting_Start_Date = $recruiting_Start_Date;
        return $this;
    }
    /**
     * Get Target_Hire_Date value
     * @return string|null
     */
    public function getTarget_Hire_Date()
    {
        return $this->Target_Hire_Date;
    }
    /**
     * Set Target_Hire_Date value
     * @param string $target_Hire_Date
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setTarget_Hire_Date($target_Hire_Date = null)
    {
        // validation for constraint: string
        if (!is_null($target_Hire_Date) && !is_string($target_Hire_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target_Hire_Date, true), gettype($target_Hire_Date)), __LINE__);
        }
        $this->Target_Hire_Date = $target_Hire_Date;
        return $this;
    }
    /**
     * Get Target_End_Date value
     * @return string|null
     */
    public function getTarget_End_Date()
    {
        return $this->Target_End_Date;
    }
    /**
     * Set Target_End_Date value
     * @param string $target_End_Date
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setTarget_End_Date($target_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($target_End_Date) && !is_string($target_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target_End_Date, true), gettype($target_End_Date)), __LINE__);
        }
        $this->Target_End_Date = $target_End_Date;
        return $this;
    }
    /**
     * Get Job_Profile_Reference value
     * @return \StructType\Job_ProfileObjectType|null
     */
    public function getJob_Profile_Reference()
    {
        return $this->Job_Profile_Reference;
    }
    /**
     * Set Job_Profile_Reference value
     * @param \StructType\Job_ProfileObjectType $job_Profile_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setJob_Profile_Reference(\StructType\Job_ProfileObjectType $job_Profile_Reference = null)
    {
        $this->Job_Profile_Reference = $job_Profile_Reference;
        return $this;
    }
    /**
     * Get Additional_Job_Profiles_Reference value
     * @return \StructType\Job_ProfileObjectType[]|null
     */
    public function getAdditional_Job_Profiles_Reference()
    {
        return $this->Additional_Job_Profiles_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditional_Job_Profiles_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditional_Job_Profiles_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditional_Job_Profiles_ReferenceForArrayConstraintsFromSetAdditional_Job_Profiles_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $evergreen_Job_Requisition_Data_for_Create_and_EditTypeAdditional_Job_Profiles_ReferenceItem) {
            // validation for constraint: itemType
            if (!$evergreen_Job_Requisition_Data_for_Create_and_EditTypeAdditional_Job_Profiles_ReferenceItem instanceof \StructType\Job_ProfileObjectType) {
                $invalidValues[] = is_object($evergreen_Job_Requisition_Data_for_Create_and_EditTypeAdditional_Job_Profiles_ReferenceItem) ? get_class($evergreen_Job_Requisition_Data_for_Create_and_EditTypeAdditional_Job_Profiles_ReferenceItem) : sprintf('%s(%s)', gettype($evergreen_Job_Requisition_Data_for_Create_and_EditTypeAdditional_Job_Profiles_ReferenceItem), var_export($evergreen_Job_Requisition_Data_for_Create_and_EditTypeAdditional_Job_Profiles_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Additional_Job_Profiles_Reference property can only contain items of type \StructType\Job_ProfileObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Additional_Job_Profiles_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_ProfileObjectType[] $additional_Job_Profiles_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setAdditional_Job_Profiles_Reference(array $additional_Job_Profiles_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($additional_Job_Profiles_ReferenceArrayErrorMessage = self::validateAdditional_Job_Profiles_ReferenceForArrayConstraintsFromSetAdditional_Job_Profiles_Reference($additional_Job_Profiles_Reference))) {
            throw new \InvalidArgumentException($additional_Job_Profiles_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Additional_Job_Profiles_Reference = $additional_Job_Profiles_Reference;
        return $this;
    }
    /**
     * Add item to Additional_Job_Profiles_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_ProfileObjectType $item
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function addToAdditional_Job_Profiles_Reference(\StructType\Job_ProfileObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_ProfileObjectType) {
            throw new \InvalidArgumentException(sprintf('The Additional_Job_Profiles_Reference property can only contain items of type \StructType\Job_ProfileObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Additional_Job_Profiles_Reference[] = $item;
        return $this;
    }
    /**
     * Get Worker_Type_Reference value
     * @return \StructType\Worker_TypeObjectType|null
     */
    public function getWorker_Type_Reference()
    {
        return $this->Worker_Type_Reference;
    }
    /**
     * Set Worker_Type_Reference value
     * @param \StructType\Worker_TypeObjectType $worker_Type_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setWorker_Type_Reference(\StructType\Worker_TypeObjectType $worker_Type_Reference = null)
    {
        $this->Worker_Type_Reference = $worker_Type_Reference;
        return $this;
    }
    /**
     * Get Worker_Sub_Type_Reference value
     * @return \StructType\Position_Worker_TypeObjectType|null
     */
    public function getWorker_Sub_Type_Reference()
    {
        return $this->{'Worker_Sub-Type_Reference'};
    }
    /**
     * Set Worker_Sub_Type_Reference value
     * @param \StructType\Position_Worker_TypeObjectType $worker_Sub_Type_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setWorker_Sub_Type_Reference(\StructType\Position_Worker_TypeObjectType $worker_Sub_Type_Reference = null)
    {
        $this->Worker_Sub_Type_Reference = $this->{'Worker_Sub-Type_Reference'} = $worker_Sub_Type_Reference;
        return $this;
    }
    /**
     * Get Primary_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getPrimary_Location_Reference()
    {
        return $this->Primary_Location_Reference;
    }
    /**
     * Set Primary_Location_Reference value
     * @param \StructType\LocationObjectType $primary_Location_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setPrimary_Location_Reference(\StructType\LocationObjectType $primary_Location_Reference = null)
    {
        $this->Primary_Location_Reference = $primary_Location_Reference;
        return $this;
    }
    /**
     * Get Primary_Job_Posting_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getPrimary_Job_Posting_Location_Reference()
    {
        return $this->Primary_Job_Posting_Location_Reference;
    }
    /**
     * Set Primary_Job_Posting_Location_Reference value
     * @param \StructType\LocationObjectType $primary_Job_Posting_Location_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setPrimary_Job_Posting_Location_Reference(\StructType\LocationObjectType $primary_Job_Posting_Location_Reference = null)
    {
        $this->Primary_Job_Posting_Location_Reference = $primary_Job_Posting_Location_Reference;
        return $this;
    }
    /**
     * Get Additional_Locations_Reference value
     * @return \StructType\LocationObjectType[]|null
     */
    public function getAdditional_Locations_Reference()
    {
        return $this->Additional_Locations_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditional_Locations_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditional_Locations_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditional_Locations_ReferenceForArrayConstraintsFromSetAdditional_Locations_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $evergreen_Job_Requisition_Data_for_Create_and_EditTypeAdditional_Locations_ReferenceItem) {
            // validation for constraint: itemType
            if (!$evergreen_Job_Requisition_Data_for_Create_and_EditTypeAdditional_Locations_ReferenceItem instanceof \StructType\LocationObjectType) {
                $invalidValues[] = is_object($evergreen_Job_Requisition_Data_for_Create_and_EditTypeAdditional_Locations_ReferenceItem) ? get_class($evergreen_Job_Requisition_Data_for_Create_and_EditTypeAdditional_Locations_ReferenceItem) : sprintf('%s(%s)', gettype($evergreen_Job_Requisition_Data_for_Create_and_EditTypeAdditional_Locations_ReferenceItem), var_export($evergreen_Job_Requisition_Data_for_Create_and_EditTypeAdditional_Locations_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Additional_Locations_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Additional_Locations_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType[] $additional_Locations_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setAdditional_Locations_Reference(array $additional_Locations_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($additional_Locations_ReferenceArrayErrorMessage = self::validateAdditional_Locations_ReferenceForArrayConstraintsFromSetAdditional_Locations_Reference($additional_Locations_Reference))) {
            throw new \InvalidArgumentException($additional_Locations_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Additional_Locations_Reference = $additional_Locations_Reference;
        return $this;
    }
    /**
     * Add item to Additional_Locations_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType $item
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function addToAdditional_Locations_Reference(\StructType\LocationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Additional_Locations_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Additional_Locations_Reference[] = $item;
        return $this;
    }
    /**
     * Get Additional_Job_Posting_Locations_Reference value
     * @return \StructType\LocationObjectType[]|null
     */
    public function getAdditional_Job_Posting_Locations_Reference()
    {
        return $this->Additional_Job_Posting_Locations_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditional_Job_Posting_Locations_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditional_Job_Posting_Locations_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditional_Job_Posting_Locations_ReferenceForArrayConstraintsFromSetAdditional_Job_Posting_Locations_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $evergreen_Job_Requisition_Data_for_Create_and_EditTypeAdditional_Job_Posting_Locations_ReferenceItem) {
            // validation for constraint: itemType
            if (!$evergreen_Job_Requisition_Data_for_Create_and_EditTypeAdditional_Job_Posting_Locations_ReferenceItem instanceof \StructType\LocationObjectType) {
                $invalidValues[] = is_object($evergreen_Job_Requisition_Data_for_Create_and_EditTypeAdditional_Job_Posting_Locations_ReferenceItem) ? get_class($evergreen_Job_Requisition_Data_for_Create_and_EditTypeAdditional_Job_Posting_Locations_ReferenceItem) : sprintf('%s(%s)', gettype($evergreen_Job_Requisition_Data_for_Create_and_EditTypeAdditional_Job_Posting_Locations_ReferenceItem), var_export($evergreen_Job_Requisition_Data_for_Create_and_EditTypeAdditional_Job_Posting_Locations_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Additional_Job_Posting_Locations_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Additional_Job_Posting_Locations_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType[] $additional_Job_Posting_Locations_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setAdditional_Job_Posting_Locations_Reference(array $additional_Job_Posting_Locations_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($additional_Job_Posting_Locations_ReferenceArrayErrorMessage = self::validateAdditional_Job_Posting_Locations_ReferenceForArrayConstraintsFromSetAdditional_Job_Posting_Locations_Reference($additional_Job_Posting_Locations_Reference))) {
            throw new \InvalidArgumentException($additional_Job_Posting_Locations_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Additional_Job_Posting_Locations_Reference = $additional_Job_Posting_Locations_Reference;
        return $this;
    }
    /**
     * Add item to Additional_Job_Posting_Locations_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType $item
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function addToAdditional_Job_Posting_Locations_Reference(\StructType\LocationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Additional_Job_Posting_Locations_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Additional_Job_Posting_Locations_Reference[] = $item;
        return $this;
    }
    /**
     * Get Position_Time_Type_Reference value
     * @return \StructType\Position_Time_TypeObjectType|null
     */
    public function getPosition_Time_Type_Reference()
    {
        return $this->Position_Time_Type_Reference;
    }
    /**
     * Set Position_Time_Type_Reference value
     * @param \StructType\Position_Time_TypeObjectType $position_Time_Type_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setPosition_Time_Type_Reference(\StructType\Position_Time_TypeObjectType $position_Time_Type_Reference = null)
    {
        $this->Position_Time_Type_Reference = $position_Time_Type_Reference;
        return $this;
    }
    /**
     * Get Employee_Contract_Type_Reference value
     * @return \StructType\Employee_Contract_TypeObjectType|null
     */
    public function getEmployee_Contract_Type_Reference()
    {
        return $this->Employee_Contract_Type_Reference;
    }
    /**
     * Set Employee_Contract_Type_Reference value
     * @param \StructType\Employee_Contract_TypeObjectType $employee_Contract_Type_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setEmployee_Contract_Type_Reference(\StructType\Employee_Contract_TypeObjectType $employee_Contract_Type_Reference = null)
    {
        $this->Employee_Contract_Type_Reference = $employee_Contract_Type_Reference;
        return $this;
    }
    /**
     * Get Scheduled_Weekly_Hours value
     * @return float|null
     */
    public function getScheduled_Weekly_Hours()
    {
        return $this->Scheduled_Weekly_Hours;
    }
    /**
     * Set Scheduled_Weekly_Hours value
     * @param float $scheduled_Weekly_Hours
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setScheduled_Weekly_Hours($scheduled_Weekly_Hours = null)
    {
        // validation for constraint: float
        if (!is_null($scheduled_Weekly_Hours) && !(is_float($scheduled_Weekly_Hours) || is_numeric($scheduled_Weekly_Hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($scheduled_Weekly_Hours, true), gettype($scheduled_Weekly_Hours)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($scheduled_Weekly_Hours) && mb_strlen(mb_substr($scheduled_Weekly_Hours, false !== mb_strpos($scheduled_Weekly_Hours, '.') ? mb_strpos($scheduled_Weekly_Hours, '.') + 1 : mb_strlen($scheduled_Weekly_Hours))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($scheduled_Weekly_Hours, true), mb_strlen(mb_substr($scheduled_Weekly_Hours, mb_strpos($scheduled_Weekly_Hours, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(14)
        if (!is_null($scheduled_Weekly_Hours) && mb_strlen(preg_replace('/(\D)/', '', $scheduled_Weekly_Hours)) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 14 digits, "%d" given', var_export($scheduled_Weekly_Hours, true), mb_strlen(preg_replace('/(\D)/', '', $scheduled_Weekly_Hours))), __LINE__);
        }
        $this->Scheduled_Weekly_Hours = $scheduled_Weekly_Hours;
        return $this;
    }
    /**
     * Get Work_Shift_Reference value
     * @return \StructType\Work_ShiftObjectType|null
     */
    public function getWork_Shift_Reference()
    {
        return $this->Work_Shift_Reference;
    }
    /**
     * Set Work_Shift_Reference value
     * @param \StructType\Work_ShiftObjectType $work_Shift_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setWork_Shift_Reference(\StructType\Work_ShiftObjectType $work_Shift_Reference = null)
    {
        $this->Work_Shift_Reference = $work_Shift_Reference;
        return $this;
    }
    /**
     * Get Spotlight_Job value
     * @return bool|null
     */
    public function getSpotlight_Job()
    {
        return $this->Spotlight_Job;
    }
    /**
     * Set Spotlight_Job value
     * @param bool $spotlight_Job
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setSpotlight_Job($spotlight_Job = null)
    {
        // validation for constraint: boolean
        if (!is_null($spotlight_Job) && !is_bool($spotlight_Job)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($spotlight_Job, true), gettype($spotlight_Job)), __LINE__);
        }
        $this->Spotlight_Job = $spotlight_Job;
        return $this;
    }
    /**
     * Get Job_Requisition_Links_to_Add_Reference value
     * @return \StructType\Job_RequisitionObjectType[]|null
     */
    public function getJob_Requisition_Links_to_Add_Reference()
    {
        return $this->Job_Requisition_Links_to_Add_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Requisition_Links_to_Add_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Requisition_Links_to_Add_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Requisition_Links_to_Add_ReferenceForArrayConstraintsFromSetJob_Requisition_Links_to_Add_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $evergreen_Job_Requisition_Data_for_Create_and_EditTypeJob_Requisition_Links_to_Add_ReferenceItem) {
            // validation for constraint: itemType
            if (!$evergreen_Job_Requisition_Data_for_Create_and_EditTypeJob_Requisition_Links_to_Add_ReferenceItem instanceof \StructType\Job_RequisitionObjectType) {
                $invalidValues[] = is_object($evergreen_Job_Requisition_Data_for_Create_and_EditTypeJob_Requisition_Links_to_Add_ReferenceItem) ? get_class($evergreen_Job_Requisition_Data_for_Create_and_EditTypeJob_Requisition_Links_to_Add_ReferenceItem) : sprintf('%s(%s)', gettype($evergreen_Job_Requisition_Data_for_Create_and_EditTypeJob_Requisition_Links_to_Add_ReferenceItem), var_export($evergreen_Job_Requisition_Data_for_Create_and_EditTypeJob_Requisition_Links_to_Add_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Requisition_Links_to_Add_Reference property can only contain items of type \StructType\Job_RequisitionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Requisition_Links_to_Add_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_RequisitionObjectType[] $job_Requisition_Links_to_Add_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setJob_Requisition_Links_to_Add_Reference(array $job_Requisition_Links_to_Add_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Requisition_Links_to_Add_ReferenceArrayErrorMessage = self::validateJob_Requisition_Links_to_Add_ReferenceForArrayConstraintsFromSetJob_Requisition_Links_to_Add_Reference($job_Requisition_Links_to_Add_Reference))) {
            throw new \InvalidArgumentException($job_Requisition_Links_to_Add_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Job_Requisition_Links_to_Add_Reference = $job_Requisition_Links_to_Add_Reference;
        return $this;
    }
    /**
     * Add item to Job_Requisition_Links_to_Add_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_RequisitionObjectType $item
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function addToJob_Requisition_Links_to_Add_Reference(\StructType\Job_RequisitionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_RequisitionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Job_Requisition_Links_to_Add_Reference property can only contain items of type \StructType\Job_RequisitionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Requisition_Links_to_Add_Reference[] = $item;
        return $this;
    }
    /**
     * Get Job_Requisition_Links_to_Remove_Reference value
     * @return \StructType\Job_RequisitionObjectType[]|null
     */
    public function getJob_Requisition_Links_to_Remove_Reference()
    {
        return $this->Job_Requisition_Links_to_Remove_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Requisition_Links_to_Remove_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Requisition_Links_to_Remove_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Requisition_Links_to_Remove_ReferenceForArrayConstraintsFromSetJob_Requisition_Links_to_Remove_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $evergreen_Job_Requisition_Data_for_Create_and_EditTypeJob_Requisition_Links_to_Remove_ReferenceItem) {
            // validation for constraint: itemType
            if (!$evergreen_Job_Requisition_Data_for_Create_and_EditTypeJob_Requisition_Links_to_Remove_ReferenceItem instanceof \StructType\Job_RequisitionObjectType) {
                $invalidValues[] = is_object($evergreen_Job_Requisition_Data_for_Create_and_EditTypeJob_Requisition_Links_to_Remove_ReferenceItem) ? get_class($evergreen_Job_Requisition_Data_for_Create_and_EditTypeJob_Requisition_Links_to_Remove_ReferenceItem) : sprintf('%s(%s)', gettype($evergreen_Job_Requisition_Data_for_Create_and_EditTypeJob_Requisition_Links_to_Remove_ReferenceItem), var_export($evergreen_Job_Requisition_Data_for_Create_and_EditTypeJob_Requisition_Links_to_Remove_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Requisition_Links_to_Remove_Reference property can only contain items of type \StructType\Job_RequisitionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Requisition_Links_to_Remove_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_RequisitionObjectType[] $job_Requisition_Links_to_Remove_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setJob_Requisition_Links_to_Remove_Reference(array $job_Requisition_Links_to_Remove_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Requisition_Links_to_Remove_ReferenceArrayErrorMessage = self::validateJob_Requisition_Links_to_Remove_ReferenceForArrayConstraintsFromSetJob_Requisition_Links_to_Remove_Reference($job_Requisition_Links_to_Remove_Reference))) {
            throw new \InvalidArgumentException($job_Requisition_Links_to_Remove_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Job_Requisition_Links_to_Remove_Reference = $job_Requisition_Links_to_Remove_Reference;
        return $this;
    }
    /**
     * Add item to Job_Requisition_Links_to_Remove_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_RequisitionObjectType $item
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function addToJob_Requisition_Links_to_Remove_Reference(\StructType\Job_RequisitionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_RequisitionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Job_Requisition_Links_to_Remove_Reference property can only contain items of type \StructType\Job_RequisitionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Requisition_Links_to_Remove_Reference[] = $item;
        return $this;
    }
    /**
     * Get Questionnaire_Data value
     * @return \StructType\Job_Requisition_Questionnaire_DataType|null
     */
    public function getQuestionnaire_Data()
    {
        return $this->Questionnaire_Data;
    }
    /**
     * Set Questionnaire_Data value
     * @param \StructType\Job_Requisition_Questionnaire_DataType $questionnaire_Data
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setQuestionnaire_Data(\StructType\Job_Requisition_Questionnaire_DataType $questionnaire_Data = null)
    {
        $this->Questionnaire_Data = $questionnaire_Data;
        return $this;
    }
    /**
     * Get Assessment_Data value
     * @return \StructType\Job_Requisition_Assessment_DataType|null
     */
    public function getAssessment_Data()
    {
        return $this->Assessment_Data;
    }
    /**
     * Set Assessment_Data value
     * @param \StructType\Job_Requisition_Assessment_DataType $assessment_Data
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setAssessment_Data(\StructType\Job_Requisition_Assessment_DataType $assessment_Data = null)
    {
        $this->Assessment_Data = $assessment_Data;
        return $this;
    }
    /**
     * Get Qualification_Replacement_Data value
     * @return \StructType\Qualification_Data_for_Position_Restriction_or_Job_ProfileType|null
     */
    public function getQualification_Replacement_Data()
    {
        return $this->Qualification_Replacement_Data;
    }
    /**
     * Set Qualification_Replacement_Data value
     * @param \StructType\Qualification_Data_for_Position_Restriction_or_Job_ProfileType $qualification_Replacement_Data
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setQualification_Replacement_Data(\StructType\Qualification_Data_for_Position_Restriction_or_Job_ProfileType $qualification_Replacement_Data = null)
    {
        $this->Qualification_Replacement_Data = $qualification_Replacement_Data;
        return $this;
    }
    /**
     * Get Organization_Data value
     * @return \StructType\Evergreen_Job_Requisition_Organizations_Data_for_Business_ProcessType|null
     */
    public function getOrganization_Data()
    {
        return $this->Organization_Data;
    }
    /**
     * Set Organization_Data value
     * @param \StructType\Evergreen_Job_Requisition_Organizations_Data_for_Business_ProcessType $organization_Data
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setOrganization_Data(\StructType\Evergreen_Job_Requisition_Organizations_Data_for_Business_ProcessType $organization_Data = null)
    {
        $this->Organization_Data = $organization_Data;
        return $this;
    }
    /**
     * Get Use_Updated_Template_Version value
     * @return bool|null
     */
    public function getUse_Updated_Template_Version()
    {
        return $this->Use_Updated_Template_Version;
    }
    /**
     * Set Use_Updated_Template_Version value
     * @param bool $use_Updated_Template_Version
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setUse_Updated_Template_Version($use_Updated_Template_Version = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Updated_Template_Version) && !is_bool($use_Updated_Template_Version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Updated_Template_Version, true), gettype($use_Updated_Template_Version)), __LINE__);
        }
        $this->Use_Updated_Template_Version = $use_Updated_Template_Version;
        return $this;
    }
    /**
     * Get Job_Application_Template_Reference value
     * @return \StructType\Job_Application_TemplateObjectType|null
     */
    public function getJob_Application_Template_Reference()
    {
        return $this->Job_Application_Template_Reference;
    }
    /**
     * Set Job_Application_Template_Reference value
     * @param \StructType\Job_Application_TemplateObjectType $job_Application_Template_Reference
     * @return \StructType\Evergreen_Job_Requisition_Data_for_Create_and_EditType
     */
    public function setJob_Application_Template_Reference(\StructType\Job_Application_TemplateObjectType $job_Application_Template_Reference = null)
    {
        $this->Job_Application_Template_Reference = $job_Application_Template_Reference;
        return $this;
    }
}
