<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Employee_Notice_Period_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Adds or updates notice period data for an employee's voluntary termination.
 * @subpackage Structs
 */
class Employee_Notice_Period_DataType extends AbstractStructBase
{
    /**
     * The Derive_Notice_Period
     * Meta information extracted from the WSDL
     * - documentation: Specifies if Workday derives the notice period from the employee's notice period eligibility rule.
     * - choice: Derive_Notice_Period | Override_Notice_Period_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var bool
     */
    public $Derive_Notice_Period;
    /**
     * The Override_Notice_Period_Data
     * Meta information extracted from the WSDL
     * - documentation: Override Notice Period Data
     * - choice: Derive_Notice_Period | Override_Notice_Period_Data
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Override_Notice_Period_DataType
     */
    public $Override_Notice_Period_Data;
    /**
     * Constructor method for Employee_Notice_Period_DataType
     * @uses Employee_Notice_Period_DataType::setDerive_Notice_Period()
     * @uses Employee_Notice_Period_DataType::setOverride_Notice_Period_Data()
     * @param bool $derive_Notice_Period
     * @param \StructType\Override_Notice_Period_DataType $override_Notice_Period_Data
     */
    public function __construct($derive_Notice_Period = null, \StructType\Override_Notice_Period_DataType $override_Notice_Period_Data = null)
    {
        $this
            ->setDerive_Notice_Period($derive_Notice_Period)
            ->setOverride_Notice_Period_Data($override_Notice_Period_Data);
    }
    /**
     * Get Derive_Notice_Period value
     * @return bool|null
     */
    public function getDerive_Notice_Period()
    {
        return isset($this->Derive_Notice_Period) ? $this->Derive_Notice_Period : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDerive_Notice_Period method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDerive_Notice_Period method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDerive_Notice_PeriodForChoiceConstraintsFromSetDerive_Notice_Period($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Override_Notice_Period_Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Derive_Notice_Period can\'t be set as the property %s is already set. Only one property must be set among these properties: Derive_Notice_Period, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Derive_Notice_Period value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $derive_Notice_Period
     * @return \StructType\Employee_Notice_Period_DataType
     */
    public function setDerive_Notice_Period($derive_Notice_Period = null)
    {
        // validation for constraint: boolean
        if (!is_null($derive_Notice_Period) && !is_bool($derive_Notice_Period)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($derive_Notice_Period, true), gettype($derive_Notice_Period)), __LINE__);
        }
        // validation for constraint: choice(Derive_Notice_Period, Override_Notice_Period_Data)
        if ('' !== ($derive_Notice_PeriodChoiceErrorMessage = self::validateDerive_Notice_PeriodForChoiceConstraintsFromSetDerive_Notice_Period($derive_Notice_Period))) {
            throw new \InvalidArgumentException($derive_Notice_PeriodChoiceErrorMessage, __LINE__);
        }
        if (is_null($derive_Notice_Period) || (is_array($derive_Notice_Period) && empty($derive_Notice_Period))) {
            unset($this->Derive_Notice_Period);
        } else {
            $this->Derive_Notice_Period = $derive_Notice_Period;
        }
        return $this;
    }
    /**
     * Get Override_Notice_Period_Data value
     * @return \StructType\Override_Notice_Period_DataType|null
     */
    public function getOverride_Notice_Period_Data()
    {
        return isset($this->Override_Notice_Period_Data) ? $this->Override_Notice_Period_Data : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOverride_Notice_Period_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOverride_Notice_Period_Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOverride_Notice_Period_DataForChoiceConstraintsFromSetOverride_Notice_Period_Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Derive_Notice_Period',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Override_Notice_Period_Data can\'t be set as the property %s is already set. Only one property must be set among these properties: Override_Notice_Period_Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Override_Notice_Period_Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Override_Notice_Period_DataType $override_Notice_Period_Data
     * @return \StructType\Employee_Notice_Period_DataType
     */
    public function setOverride_Notice_Period_Data(\StructType\Override_Notice_Period_DataType $override_Notice_Period_Data = null)
    {
        // validation for constraint: choice(Derive_Notice_Period, Override_Notice_Period_Data)
        if ('' !== ($override_Notice_Period_DataChoiceErrorMessage = self::validateOverride_Notice_Period_DataForChoiceConstraintsFromSetOverride_Notice_Period_Data($override_Notice_Period_Data))) {
            throw new \InvalidArgumentException($override_Notice_Period_DataChoiceErrorMessage, __LINE__);
        }
        if (is_null($override_Notice_Period_Data) || (is_array($override_Notice_Period_Data) && empty($override_Notice_Period_Data))) {
            unset($this->Override_Notice_Period_Data);
        } else {
            $this->Override_Notice_Period_Data = $override_Notice_Period_Data;
        }
        return $this;
    }
}
