<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Edit_Job_Requisition_Event_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for reference to job requisition and job requisition data element.
 * @subpackage Structs
 */
class Edit_Job_Requisition_Event_DataType extends AbstractStructBase
{
    /**
     * The Supervisory_Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Supervisory Organization reference for this requisition.
     * - minOccurs: 0
     * @var \StructType\Supervisory_OrganizationObjectType
     */
    public $Supervisory_Organization_Reference;
    /**
     * The Number_of_Openings
     * Meta information extracted from the WSDL
     * - documentation: Number of openings associated with the job requisition. There can be no more than 100 positions allocated for a Job Requisition for a Position Management Organization. | The number of positions made available by the job requisition.
     * This number can only be greater than 1 for job requisitions created with the "new position" option. A value of greater than 1 was only allowed starting in W16. This element must be omitted for the Create Job Requisition and Edit Job Requisition
     * operations. | Number of openings associated with the job requisition
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $Number_of_Openings;
    /**
     * The Edit_Job_Requisition_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for a Reason for the Edit Job Requisition Business Process.
     * @var \StructType\Event_Classification_SubcategoryObjectType
     */
    public $Edit_Job_Requisition_Reason_Reference;
    /**
     * The Job_Requisition_Data
     * Meta information extracted from the WSDL
     * - documentation: The Job Requisition Data for Create and Edit sub-element.
     * - maxOccurs: unbounded
     * @var \StructType\Job_Requisition_Data_for_Create_and_EditType[]
     */
    public $Job_Requisition_Data;
    /**
     * Constructor method for Edit_Job_Requisition_Event_DataType
     * @uses Edit_Job_Requisition_Event_DataType::setSupervisory_Organization_Reference()
     * @uses Edit_Job_Requisition_Event_DataType::setNumber_of_Openings()
     * @uses Edit_Job_Requisition_Event_DataType::setEdit_Job_Requisition_Reason_Reference()
     * @uses Edit_Job_Requisition_Event_DataType::setJob_Requisition_Data()
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @param float $number_of_Openings
     * @param \StructType\Event_Classification_SubcategoryObjectType $edit_Job_Requisition_Reason_Reference
     * @param \StructType\Job_Requisition_Data_for_Create_and_EditType[] $job_Requisition_Data
     */
    public function __construct(\StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null, $number_of_Openings = null, \StructType\Event_Classification_SubcategoryObjectType $edit_Job_Requisition_Reason_Reference = null, array $job_Requisition_Data = array())
    {
        $this
            ->setSupervisory_Organization_Reference($supervisory_Organization_Reference)
            ->setNumber_of_Openings($number_of_Openings)
            ->setEdit_Job_Requisition_Reason_Reference($edit_Job_Requisition_Reason_Reference)
            ->setJob_Requisition_Data($job_Requisition_Data);
    }
    /**
     * Get Supervisory_Organization_Reference value
     * @return \StructType\Supervisory_OrganizationObjectType|null
     */
    public function getSupervisory_Organization_Reference()
    {
        return $this->Supervisory_Organization_Reference;
    }
    /**
     * Set Supervisory_Organization_Reference value
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @return \StructType\Edit_Job_Requisition_Event_DataType
     */
    public function setSupervisory_Organization_Reference(\StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null)
    {
        $this->Supervisory_Organization_Reference = $supervisory_Organization_Reference;
        return $this;
    }
    /**
     * Get Number_of_Openings value
     * @return float|null
     */
    public function getNumber_of_Openings()
    {
        return $this->Number_of_Openings;
    }
    /**
     * Set Number_of_Openings value
     * @param float $number_of_Openings
     * @return \StructType\Edit_Job_Requisition_Event_DataType
     */
    public function setNumber_of_Openings($number_of_Openings = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Openings) && !(is_float($number_of_Openings) || is_numeric($number_of_Openings))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Openings, true), gettype($number_of_Openings)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Openings) && mb_strlen(mb_substr($number_of_Openings, false !== mb_strpos($number_of_Openings, '.') ? mb_strpos($number_of_Openings, '.') + 1 : mb_strlen($number_of_Openings))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Openings, true), mb_strlen(mb_substr($number_of_Openings, mb_strpos($number_of_Openings, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Openings) && $number_of_Openings < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Openings, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($number_of_Openings) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Openings)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($number_of_Openings, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Openings))), __LINE__);
        }
        $this->Number_of_Openings = $number_of_Openings;
        return $this;
    }
    /**
     * Get Edit_Job_Requisition_Reason_Reference value
     * @return \StructType\Event_Classification_SubcategoryObjectType|null
     */
    public function getEdit_Job_Requisition_Reason_Reference()
    {
        return $this->Edit_Job_Requisition_Reason_Reference;
    }
    /**
     * Set Edit_Job_Requisition_Reason_Reference value
     * @param \StructType\Event_Classification_SubcategoryObjectType $edit_Job_Requisition_Reason_Reference
     * @return \StructType\Edit_Job_Requisition_Event_DataType
     */
    public function setEdit_Job_Requisition_Reason_Reference(\StructType\Event_Classification_SubcategoryObjectType $edit_Job_Requisition_Reason_Reference = null)
    {
        $this->Edit_Job_Requisition_Reason_Reference = $edit_Job_Requisition_Reason_Reference;
        return $this;
    }
    /**
     * Get Job_Requisition_Data value
     * @return \StructType\Job_Requisition_Data_for_Create_and_EditType[]|null
     */
    public function getJob_Requisition_Data()
    {
        return $this->Job_Requisition_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Requisition_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Requisition_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Requisition_DataForArrayConstraintsFromSetJob_Requisition_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $edit_Job_Requisition_Event_DataTypeJob_Requisition_DataItem) {
            // validation for constraint: itemType
            if (!$edit_Job_Requisition_Event_DataTypeJob_Requisition_DataItem instanceof \StructType\Job_Requisition_Data_for_Create_and_EditType) {
                $invalidValues[] = is_object($edit_Job_Requisition_Event_DataTypeJob_Requisition_DataItem) ? get_class($edit_Job_Requisition_Event_DataTypeJob_Requisition_DataItem) : sprintf('%s(%s)', gettype($edit_Job_Requisition_Event_DataTypeJob_Requisition_DataItem), var_export($edit_Job_Requisition_Event_DataTypeJob_Requisition_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Requisition_Data property can only contain items of type \StructType\Job_Requisition_Data_for_Create_and_EditType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Requisition_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_Data_for_Create_and_EditType[] $job_Requisition_Data
     * @return \StructType\Edit_Job_Requisition_Event_DataType
     */
    public function setJob_Requisition_Data(array $job_Requisition_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Requisition_DataArrayErrorMessage = self::validateJob_Requisition_DataForArrayConstraintsFromSetJob_Requisition_Data($job_Requisition_Data))) {
            throw new \InvalidArgumentException($job_Requisition_DataArrayErrorMessage, __LINE__);
        }
        $this->Job_Requisition_Data = $job_Requisition_Data;
        return $this;
    }
    /**
     * Add item to Job_Requisition_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_Requisition_Data_for_Create_and_EditType $item
     * @return \StructType\Edit_Job_Requisition_Event_DataType
     */
    public function addToJob_Requisition_Data(\StructType\Job_Requisition_Data_for_Create_and_EditType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_Requisition_Data_for_Create_and_EditType) {
            throw new \InvalidArgumentException(sprintf('The Job_Requisition_Data property can only contain items of type \StructType\Job_Requisition_Data_for_Create_and_EditType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Requisition_Data[] = $item;
        return $this;
    }
}
