<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Create_Position_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Responds with the event id for the Position Request Event and the Position Opening Reference (if the event was completed).
 * @subpackage Structs
 */
class Create_Position_ResponseType extends AbstractStructBase
{
    /**
     * The Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Request Position event
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Event_Reference;
    /**
     * The Position_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the new position (if created automatically from web service).
     * - minOccurs: 0
     * @var \StructType\Position_GroupObjectType
     */
    public $Position_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Create_Position_ResponseType
     * @uses Create_Position_ResponseType::setEvent_Reference()
     * @uses Create_Position_ResponseType::setPosition_Reference()
     * @uses Create_Position_ResponseType::setVersion()
     * @param \StructType\Unique_IdentifierObjectType $event_Reference
     * @param \StructType\Position_GroupObjectType $position_Reference
     * @param string $version
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $event_Reference = null, \StructType\Position_GroupObjectType $position_Reference = null, $version = null)
    {
        $this
            ->setEvent_Reference($event_Reference)
            ->setPosition_Reference($position_Reference)
            ->setVersion($version);
    }
    /**
     * Get Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getEvent_Reference()
    {
        return $this->Event_Reference;
    }
    /**
     * Set Event_Reference value
     * @param \StructType\Unique_IdentifierObjectType $event_Reference
     * @return \StructType\Create_Position_ResponseType
     */
    public function setEvent_Reference(\StructType\Unique_IdentifierObjectType $event_Reference = null)
    {
        $this->Event_Reference = $event_Reference;
        return $this;
    }
    /**
     * Get Position_Reference value
     * @return \StructType\Position_GroupObjectType|null
     */
    public function getPosition_Reference()
    {
        return $this->Position_Reference;
    }
    /**
     * Set Position_Reference value
     * @param \StructType\Position_GroupObjectType $position_Reference
     * @return \StructType\Create_Position_ResponseType
     */
    public function setPosition_Reference(\StructType\Position_GroupObjectType $position_Reference = null)
    {
        $this->Position_Reference = $position_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Create_Position_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
