<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Create_Job_Requisition_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Responds with the event id for the Create Job Requisition Event and the Job Requisition Reference.
 * @subpackage Structs
 */
class Create_Job_Requisition_ResponseType extends AbstractStructBase
{
    /**
     * The Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Create Job Requisition Event.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Event_Reference;
    /**
     * The Job_Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the new Job Requisition (if created automatically and the event was completed).
     * - minOccurs: 0
     * @var \StructType\Job_RequisitionObjectType
     */
    public $Job_Requisition_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Create_Job_Requisition_ResponseType
     * @uses Create_Job_Requisition_ResponseType::setEvent_Reference()
     * @uses Create_Job_Requisition_ResponseType::setJob_Requisition_Reference()
     * @uses Create_Job_Requisition_ResponseType::setVersion()
     * @param \StructType\Unique_IdentifierObjectType $event_Reference
     * @param \StructType\Job_RequisitionObjectType $job_Requisition_Reference
     * @param string $version
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $event_Reference = null, \StructType\Job_RequisitionObjectType $job_Requisition_Reference = null, $version = null)
    {
        $this
            ->setEvent_Reference($event_Reference)
            ->setJob_Requisition_Reference($job_Requisition_Reference)
            ->setVersion($version);
    }
    /**
     * Get Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getEvent_Reference()
    {
        return $this->Event_Reference;
    }
    /**
     * Set Event_Reference value
     * @param \StructType\Unique_IdentifierObjectType $event_Reference
     * @return \StructType\Create_Job_Requisition_ResponseType
     */
    public function setEvent_Reference(\StructType\Unique_IdentifierObjectType $event_Reference = null)
    {
        $this->Event_Reference = $event_Reference;
        return $this;
    }
    /**
     * Get Job_Requisition_Reference value
     * @return \StructType\Job_RequisitionObjectType|null
     */
    public function getJob_Requisition_Reference()
    {
        return $this->Job_Requisition_Reference;
    }
    /**
     * Set Job_Requisition_Reference value
     * @param \StructType\Job_RequisitionObjectType $job_Requisition_Reference
     * @return \StructType\Create_Job_Requisition_ResponseType
     */
    public function setJob_Requisition_Reference(\StructType\Job_RequisitionObjectType $job_Requisition_Reference = null)
    {
        $this->Job_Requisition_Reference = $job_Requisition_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Create_Job_Requisition_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
