<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Create_Job_Requisition_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for the creation of a new job requisition for a position in a supervisory organization using position management.
 * @subpackage Structs
 */
class Create_Job_Requisition_DataType extends AbstractStructBase
{
    /**
     * The Position_Restriction_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Position Restrictions this requisition is being created for. The position must be in a position management organization, and the tenant must have job requisitions enabled.
     * - minOccurs: 0
     * @var \StructType\Position_GroupObjectType
     */
    public $Position_Restriction_Reference;
    /**
     * The Supervisory_Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Supervisory Organization this requisition is being created for. The position must be in a job management organization, and the tenant must have job requisitions enabled for job management.
     * - minOccurs: 0
     * @var \StructType\Supervisory_OrganizationObjectType
     */
    public $Supervisory_Organization_Reference;
    /**
     * The Create_Job_Requisition_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the reason the job requisition is being created.
     * @var \StructType\Event_Classification_SubcategoryObjectType
     */
    public $Create_Job_Requisition_Reason_Reference;
    /**
     * The Number_of_Openings
     * Meta information extracted from the WSDL
     * - documentation: Number of openings associated with the job requisition. There can be no more than 100 positions allocated for a Job Requisition for a Position Management Organization. | The number of positions made available by the job requisition.
     * This number can only be greater than 1 for job requisitions created with the "new position" option. A value of greater than 1 was only allowed starting in W16. This element must be omitted for the Create Job Requisition and Edit Job Requisition
     * operations. | Number of openings associated with the job requisition
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $Number_of_Openings;
    /**
     * The Job_Requisition_Data
     * Meta information extracted from the WSDL
     * - documentation: Data for the Create Job Requisition event. This element is required and must contain all its required attributes.
     * @var \StructType\Job_Requisition_Data_for_Create_and_EditType
     */
    public $Job_Requisition_Data;
    /**
     * The Check_Position_Budget_Sub_Process
     * Meta information extracted from the WSDL
     * - documentation: Run the Check Position Budget Sub Business Process to calculate any commitments and obligations for the outbound and/or inbound positions on this event to enable budget checking.
     * - minOccurs: 0
     * @var \StructType\Check_Position_Budget_Sub_Business_ProcessType
     */
    public $Check_Position_Budget_Sub_Process;
    /**
     * The Post_Job_Sub_Process
     * Meta information extracted from the WSDL
     * - documentation: Run the Post Job Sub Business Process to post this job requisition to one or more Job Posting Sites. To use, Post Job must be enabled in the Workflow Definition for Create Job Requisition.
     * - minOccurs: 0
     * @var \StructType\Post_Job_Sub_Business_ProcessType
     */
    public $Post_Job_Sub_Process;
    /**
     * The Assign_Organization_Roles_Sub_Process
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Assign_Organization_Roles_Sub_Business_ProcessType
     */
    public $Assign_Organization_Roles_Sub_Process;
    /**
     * The Request_Requisition_Compensation_Sub_Process
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Request_Requisition_Compensation_Sub_ProcessType
     */
    public $Request_Requisition_Compensation_Sub_Process;
    /**
     * Constructor method for Create_Job_Requisition_DataType
     * @uses Create_Job_Requisition_DataType::setPosition_Restriction_Reference()
     * @uses Create_Job_Requisition_DataType::setSupervisory_Organization_Reference()
     * @uses Create_Job_Requisition_DataType::setCreate_Job_Requisition_Reason_Reference()
     * @uses Create_Job_Requisition_DataType::setNumber_of_Openings()
     * @uses Create_Job_Requisition_DataType::setJob_Requisition_Data()
     * @uses Create_Job_Requisition_DataType::setCheck_Position_Budget_Sub_Process()
     * @uses Create_Job_Requisition_DataType::setPost_Job_Sub_Process()
     * @uses Create_Job_Requisition_DataType::setAssign_Organization_Roles_Sub_Process()
     * @uses Create_Job_Requisition_DataType::setRequest_Requisition_Compensation_Sub_Process()
     * @param \StructType\Position_GroupObjectType $position_Restriction_Reference
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @param \StructType\Event_Classification_SubcategoryObjectType $create_Job_Requisition_Reason_Reference
     * @param float $number_of_Openings
     * @param \StructType\Job_Requisition_Data_for_Create_and_EditType $job_Requisition_Data
     * @param \StructType\Check_Position_Budget_Sub_Business_ProcessType $check_Position_Budget_Sub_Process
     * @param \StructType\Post_Job_Sub_Business_ProcessType $post_Job_Sub_Process
     * @param \StructType\Assign_Organization_Roles_Sub_Business_ProcessType $assign_Organization_Roles_Sub_Process
     * @param \StructType\Request_Requisition_Compensation_Sub_ProcessType $request_Requisition_Compensation_Sub_Process
     */
    public function __construct(\StructType\Position_GroupObjectType $position_Restriction_Reference = null, \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null, \StructType\Event_Classification_SubcategoryObjectType $create_Job_Requisition_Reason_Reference = null, $number_of_Openings = null, \StructType\Job_Requisition_Data_for_Create_and_EditType $job_Requisition_Data = null, \StructType\Check_Position_Budget_Sub_Business_ProcessType $check_Position_Budget_Sub_Process = null, \StructType\Post_Job_Sub_Business_ProcessType $post_Job_Sub_Process = null, \StructType\Assign_Organization_Roles_Sub_Business_ProcessType $assign_Organization_Roles_Sub_Process = null, \StructType\Request_Requisition_Compensation_Sub_ProcessType $request_Requisition_Compensation_Sub_Process = null)
    {
        $this
            ->setPosition_Restriction_Reference($position_Restriction_Reference)
            ->setSupervisory_Organization_Reference($supervisory_Organization_Reference)
            ->setCreate_Job_Requisition_Reason_Reference($create_Job_Requisition_Reason_Reference)
            ->setNumber_of_Openings($number_of_Openings)
            ->setJob_Requisition_Data($job_Requisition_Data)
            ->setCheck_Position_Budget_Sub_Process($check_Position_Budget_Sub_Process)
            ->setPost_Job_Sub_Process($post_Job_Sub_Process)
            ->setAssign_Organization_Roles_Sub_Process($assign_Organization_Roles_Sub_Process)
            ->setRequest_Requisition_Compensation_Sub_Process($request_Requisition_Compensation_Sub_Process);
    }
    /**
     * Get Position_Restriction_Reference value
     * @return \StructType\Position_GroupObjectType|null
     */
    public function getPosition_Restriction_Reference()
    {
        return $this->Position_Restriction_Reference;
    }
    /**
     * Set Position_Restriction_Reference value
     * @param \StructType\Position_GroupObjectType $position_Restriction_Reference
     * @return \StructType\Create_Job_Requisition_DataType
     */
    public function setPosition_Restriction_Reference(\StructType\Position_GroupObjectType $position_Restriction_Reference = null)
    {
        $this->Position_Restriction_Reference = $position_Restriction_Reference;
        return $this;
    }
    /**
     * Get Supervisory_Organization_Reference value
     * @return \StructType\Supervisory_OrganizationObjectType|null
     */
    public function getSupervisory_Organization_Reference()
    {
        return $this->Supervisory_Organization_Reference;
    }
    /**
     * Set Supervisory_Organization_Reference value
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @return \StructType\Create_Job_Requisition_DataType
     */
    public function setSupervisory_Organization_Reference(\StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null)
    {
        $this->Supervisory_Organization_Reference = $supervisory_Organization_Reference;
        return $this;
    }
    /**
     * Get Create_Job_Requisition_Reason_Reference value
     * @return \StructType\Event_Classification_SubcategoryObjectType|null
     */
    public function getCreate_Job_Requisition_Reason_Reference()
    {
        return $this->Create_Job_Requisition_Reason_Reference;
    }
    /**
     * Set Create_Job_Requisition_Reason_Reference value
     * @param \StructType\Event_Classification_SubcategoryObjectType $create_Job_Requisition_Reason_Reference
     * @return \StructType\Create_Job_Requisition_DataType
     */
    public function setCreate_Job_Requisition_Reason_Reference(\StructType\Event_Classification_SubcategoryObjectType $create_Job_Requisition_Reason_Reference = null)
    {
        $this->Create_Job_Requisition_Reason_Reference = $create_Job_Requisition_Reason_Reference;
        return $this;
    }
    /**
     * Get Number_of_Openings value
     * @return float|null
     */
    public function getNumber_of_Openings()
    {
        return $this->Number_of_Openings;
    }
    /**
     * Set Number_of_Openings value
     * @param float $number_of_Openings
     * @return \StructType\Create_Job_Requisition_DataType
     */
    public function setNumber_of_Openings($number_of_Openings = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Openings) && !(is_float($number_of_Openings) || is_numeric($number_of_Openings))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Openings, true), gettype($number_of_Openings)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Openings) && mb_strlen(mb_substr($number_of_Openings, false !== mb_strpos($number_of_Openings, '.') ? mb_strpos($number_of_Openings, '.') + 1 : mb_strlen($number_of_Openings))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Openings, true), mb_strlen(mb_substr($number_of_Openings, mb_strpos($number_of_Openings, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Openings) && $number_of_Openings < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Openings, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($number_of_Openings) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Openings)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($number_of_Openings, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Openings))), __LINE__);
        }
        $this->Number_of_Openings = $number_of_Openings;
        return $this;
    }
    /**
     * Get Job_Requisition_Data value
     * @return \StructType\Job_Requisition_Data_for_Create_and_EditType|null
     */
    public function getJob_Requisition_Data()
    {
        return $this->Job_Requisition_Data;
    }
    /**
     * Set Job_Requisition_Data value
     * @param \StructType\Job_Requisition_Data_for_Create_and_EditType $job_Requisition_Data
     * @return \StructType\Create_Job_Requisition_DataType
     */
    public function setJob_Requisition_Data(\StructType\Job_Requisition_Data_for_Create_and_EditType $job_Requisition_Data = null)
    {
        $this->Job_Requisition_Data = $job_Requisition_Data;
        return $this;
    }
    /**
     * Get Check_Position_Budget_Sub_Process value
     * @return \StructType\Check_Position_Budget_Sub_Business_ProcessType|null
     */
    public function getCheck_Position_Budget_Sub_Process()
    {
        return $this->Check_Position_Budget_Sub_Process;
    }
    /**
     * Set Check_Position_Budget_Sub_Process value
     * @param \StructType\Check_Position_Budget_Sub_Business_ProcessType $check_Position_Budget_Sub_Process
     * @return \StructType\Create_Job_Requisition_DataType
     */
    public function setCheck_Position_Budget_Sub_Process(\StructType\Check_Position_Budget_Sub_Business_ProcessType $check_Position_Budget_Sub_Process = null)
    {
        $this->Check_Position_Budget_Sub_Process = $check_Position_Budget_Sub_Process;
        return $this;
    }
    /**
     * Get Post_Job_Sub_Process value
     * @return \StructType\Post_Job_Sub_Business_ProcessType|null
     */
    public function getPost_Job_Sub_Process()
    {
        return $this->Post_Job_Sub_Process;
    }
    /**
     * Set Post_Job_Sub_Process value
     * @param \StructType\Post_Job_Sub_Business_ProcessType $post_Job_Sub_Process
     * @return \StructType\Create_Job_Requisition_DataType
     */
    public function setPost_Job_Sub_Process(\StructType\Post_Job_Sub_Business_ProcessType $post_Job_Sub_Process = null)
    {
        $this->Post_Job_Sub_Process = $post_Job_Sub_Process;
        return $this;
    }
    /**
     * Get Assign_Organization_Roles_Sub_Process value
     * @return \StructType\Assign_Organization_Roles_Sub_Business_ProcessType|null
     */
    public function getAssign_Organization_Roles_Sub_Process()
    {
        return $this->Assign_Organization_Roles_Sub_Process;
    }
    /**
     * Set Assign_Organization_Roles_Sub_Process value
     * @param \StructType\Assign_Organization_Roles_Sub_Business_ProcessType $assign_Organization_Roles_Sub_Process
     * @return \StructType\Create_Job_Requisition_DataType
     */
    public function setAssign_Organization_Roles_Sub_Process(\StructType\Assign_Organization_Roles_Sub_Business_ProcessType $assign_Organization_Roles_Sub_Process = null)
    {
        $this->Assign_Organization_Roles_Sub_Process = $assign_Organization_Roles_Sub_Process;
        return $this;
    }
    /**
     * Get Request_Requisition_Compensation_Sub_Process value
     * @return \StructType\Request_Requisition_Compensation_Sub_ProcessType|null
     */
    public function getRequest_Requisition_Compensation_Sub_Process()
    {
        return $this->Request_Requisition_Compensation_Sub_Process;
    }
    /**
     * Set Request_Requisition_Compensation_Sub_Process value
     * @param \StructType\Request_Requisition_Compensation_Sub_ProcessType $request_Requisition_Compensation_Sub_Process
     * @return \StructType\Create_Job_Requisition_DataType
     */
    public function setRequest_Requisition_Compensation_Sub_Process(\StructType\Request_Requisition_Compensation_Sub_ProcessType $request_Requisition_Compensation_Sub_Process = null)
    {
        $this->Request_Requisition_Compensation_Sub_Process = $request_Requisition_Compensation_Sub_Process;
        return $this;
    }
}
