<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Competency_Profile_for_Job_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the competency profile's information for a position.
 * @subpackage Structs
 */
class Competency_Profile_for_Job_DataType extends AbstractStructBase
{
    /**
     * The Competency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for the Competency.
     * - minOccurs: 0
     * @var \StructType\CompetencyObjectType
     */
    public $Competency_Reference;
    /**
     * The Proficiency_Rating_Reference
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier for the proficiency rating.
     * - minOccurs: 0
     * @var \StructType\Proficiency_RatingObjectType
     */
    public $Proficiency_Rating_Reference;
    /**
     * The Required
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the profile is required for this position.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Required;
    /**
     * The Qualification_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: The source (job profile or position) reference from which the qualification came from.
     * - minOccurs: 0
     * @var \StructType\Talent_Qualification_EnabledObjectType
     */
    public $Qualification_Source_Reference;
    /**
     * Constructor method for Competency_Profile_for_Job_DataType
     * @uses Competency_Profile_for_Job_DataType::setCompetency_Reference()
     * @uses Competency_Profile_for_Job_DataType::setProficiency_Rating_Reference()
     * @uses Competency_Profile_for_Job_DataType::setRequired()
     * @uses Competency_Profile_for_Job_DataType::setQualification_Source_Reference()
     * @param \StructType\CompetencyObjectType $competency_Reference
     * @param \StructType\Proficiency_RatingObjectType $proficiency_Rating_Reference
     * @param bool $required
     * @param \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference
     */
    public function __construct(\StructType\CompetencyObjectType $competency_Reference = null, \StructType\Proficiency_RatingObjectType $proficiency_Rating_Reference = null, $required = null, \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference = null)
    {
        $this
            ->setCompetency_Reference($competency_Reference)
            ->setProficiency_Rating_Reference($proficiency_Rating_Reference)
            ->setRequired($required)
            ->setQualification_Source_Reference($qualification_Source_Reference);
    }
    /**
     * Get Competency_Reference value
     * @return \StructType\CompetencyObjectType|null
     */
    public function getCompetency_Reference()
    {
        return $this->Competency_Reference;
    }
    /**
     * Set Competency_Reference value
     * @param \StructType\CompetencyObjectType $competency_Reference
     * @return \StructType\Competency_Profile_for_Job_DataType
     */
    public function setCompetency_Reference(\StructType\CompetencyObjectType $competency_Reference = null)
    {
        $this->Competency_Reference = $competency_Reference;
        return $this;
    }
    /**
     * Get Proficiency_Rating_Reference value
     * @return \StructType\Proficiency_RatingObjectType|null
     */
    public function getProficiency_Rating_Reference()
    {
        return $this->Proficiency_Rating_Reference;
    }
    /**
     * Set Proficiency_Rating_Reference value
     * @param \StructType\Proficiency_RatingObjectType $proficiency_Rating_Reference
     * @return \StructType\Competency_Profile_for_Job_DataType
     */
    public function setProficiency_Rating_Reference(\StructType\Proficiency_RatingObjectType $proficiency_Rating_Reference = null)
    {
        $this->Proficiency_Rating_Reference = $proficiency_Rating_Reference;
        return $this;
    }
    /**
     * Get Required value
     * @return bool|null
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param bool $required
     * @return \StructType\Competency_Profile_for_Job_DataType
     */
    public function setRequired($required = null)
    {
        // validation for constraint: boolean
        if (!is_null($required) && !is_bool($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required, true), gettype($required)), __LINE__);
        }
        $this->Required = $required;
        return $this;
    }
    /**
     * Get Qualification_Source_Reference value
     * @return \StructType\Talent_Qualification_EnabledObjectType|null
     */
    public function getQualification_Source_Reference()
    {
        return $this->Qualification_Source_Reference;
    }
    /**
     * Set Qualification_Source_Reference value
     * @param \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference
     * @return \StructType\Competency_Profile_for_Job_DataType
     */
    public function setQualification_Source_Reference(\StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference = null)
    {
        $this->Qualification_Source_Reference = $qualification_Source_Reference;
        return $this;
    }
}
