<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Compensation_Default_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data element that contains the compensation default information. If a section is to be provided, it must be provided fully as it will fully replace the current default compensation.
 * @subpackage Structs
 */
class Compensation_Default_DataType extends AbstractStructBase
{
    /**
     * The Primary_Compensation_Basis
     * Meta information extracted from the WSDL
     * - documentation: Sum of the worker's plan assignments as defined by their primary compensation basis. | Sum of the employee's plan assignments as defined by their primary compensation basis.
     * - base: xsd:decimal
     * - choice: Primary_Compensation_Basis | Primary_Compensation_Basis_Amount_Change | Primary_Compensation_Basis_Percent_Change
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Primary_Compensation_Basis;
    /**
     * The Primary_Compensation_Basis_Amount_Change
     * Meta information extracted from the WSDL
     * - documentation: Amount you can change the primary compensation basis for employees managed by basis total. Mutually exclusive from the percent.
     * - base: xsd:decimal
     * - choice: Primary_Compensation_Basis | Primary_Compensation_Basis_Amount_Change | Primary_Compensation_Basis_Percent_Change
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Primary_Compensation_Basis_Amount_Change;
    /**
     * The Primary_Compensation_Basis_Percent_Change
     * Meta information extracted from the WSDL
     * - documentation: Percent you can change the primary compensation basis for employees managed by a compensation basis. Mutually exclusive from the amount.
     * - base: xsd:decimal
     * - choice: Primary_Compensation_Basis | Primary_Compensation_Basis_Amount_Change | Primary_Compensation_Basis_Percent_Change
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 21
     * @var float
     */
    public $Primary_Compensation_Basis_Percent_Change;
    /**
     * The Guidelines_Data
     * Meta information extracted from the WSDL
     * - documentation: Data element containing the compensation guidelines for a compensation change.
     * - minOccurs: 0
     * @var \StructType\Compensatable_Default_Guidelines_DataType
     */
    public $Guidelines_Data;
    /**
     * The Pay_Plan_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing all Salary or Hourly Plan Compensation data.
     * - minOccurs: 0
     * @var \StructType\Proposed_Base_Pay_Plan_Assignment_Container_DataType
     */
    public $Pay_Plan_Data;
    /**
     * The Unit_Salary_Plan_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing all Unit Salary Plan Compensation data.
     * - minOccurs: 0
     * @var \StructType\Proposed_Salary_Unit_Plan_Assignment_Container_DataType
     */
    public $Unit_Salary_Plan_Data;
    /**
     * The Allowance_Plan_Non_Unit_Based_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing all Allowance Plan Compensation data.
     * - minOccurs: 0
     * @var \StructType\Proposed_Allowance_Plan_Assignment_Container_DataType
     */
    public $Allowance_Plan_Non_Unit_Based_Data;
    /**
     * The Allowance_Plan_Unit_Based_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing all Unit Allowance Plan Compensation data.
     * - minOccurs: 0
     * @var \StructType\Proposed_Allowance_Unit_Plan_Assignment_Container_DataType
     */
    public $Allowance_Plan_Unit_Based_Data;
    /**
     * The Bonus_Plan_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing all Bonus Plan Compensation data.
     * - minOccurs: 0
     * @var \StructType\Proposed_Bonus_Plan_Assignment_Container_DataType
     */
    public $Bonus_Plan_Data;
    /**
     * The Merit_Plan_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing all Merit Plan Compensation data.
     * - minOccurs: 0
     * @var \StructType\Proposed_Merit_Plan_Assignment_Container_DataType
     */
    public $Merit_Plan_Data;
    /**
     * The Commission_Plan_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing all Commission Plan Compensation data.
     * - minOccurs: 0
     * @var \StructType\Proposed_Commission_Plan_Assignment_Container_DataType
     */
    public $Commission_Plan_Data;
    /**
     * The Stock_Plan_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing all Stock Plan Compensation data.
     * - minOccurs: 0
     * @var \StructType\Proposed_Stock_Plan_Assignment_Container_DataType
     */
    public $Stock_Plan_Data;
    /**
     * The Period_Salary_Plan_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing all Period Salary Plan Compensation data.
     * - minOccurs: 0
     * @var \StructType\Proposed_Period_Salary_Plan_Assignment_Container_DataType
     */
    public $Period_Salary_Plan_Data;
    /**
     * The Calculated_Plan_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing all Calculated Plan Compensation data.
     * - minOccurs: 0
     * @var \StructType\Proposed_Calculated_Plan_Assignment_Container_DataType
     */
    public $Calculated_Plan_Data;
    /**
     * Constructor method for Compensation_Default_DataType
     * @uses Compensation_Default_DataType::setPrimary_Compensation_Basis()
     * @uses Compensation_Default_DataType::setPrimary_Compensation_Basis_Amount_Change()
     * @uses Compensation_Default_DataType::setPrimary_Compensation_Basis_Percent_Change()
     * @uses Compensation_Default_DataType::setGuidelines_Data()
     * @uses Compensation_Default_DataType::setPay_Plan_Data()
     * @uses Compensation_Default_DataType::setUnit_Salary_Plan_Data()
     * @uses Compensation_Default_DataType::setAllowance_Plan_Non_Unit_Based_Data()
     * @uses Compensation_Default_DataType::setAllowance_Plan_Unit_Based_Data()
     * @uses Compensation_Default_DataType::setBonus_Plan_Data()
     * @uses Compensation_Default_DataType::setMerit_Plan_Data()
     * @uses Compensation_Default_DataType::setCommission_Plan_Data()
     * @uses Compensation_Default_DataType::setStock_Plan_Data()
     * @uses Compensation_Default_DataType::setPeriod_Salary_Plan_Data()
     * @uses Compensation_Default_DataType::setCalculated_Plan_Data()
     * @param float $primary_Compensation_Basis
     * @param float $primary_Compensation_Basis_Amount_Change
     * @param float $primary_Compensation_Basis_Percent_Change
     * @param \StructType\Compensatable_Default_Guidelines_DataType $guidelines_Data
     * @param \StructType\Proposed_Base_Pay_Plan_Assignment_Container_DataType $pay_Plan_Data
     * @param \StructType\Proposed_Salary_Unit_Plan_Assignment_Container_DataType $unit_Salary_Plan_Data
     * @param \StructType\Proposed_Allowance_Plan_Assignment_Container_DataType $allowance_Plan_Non_Unit_Based_Data
     * @param \StructType\Proposed_Allowance_Unit_Plan_Assignment_Container_DataType $allowance_Plan_Unit_Based_Data
     * @param \StructType\Proposed_Bonus_Plan_Assignment_Container_DataType $bonus_Plan_Data
     * @param \StructType\Proposed_Merit_Plan_Assignment_Container_DataType $merit_Plan_Data
     * @param \StructType\Proposed_Commission_Plan_Assignment_Container_DataType $commission_Plan_Data
     * @param \StructType\Proposed_Stock_Plan_Assignment_Container_DataType $stock_Plan_Data
     * @param \StructType\Proposed_Period_Salary_Plan_Assignment_Container_DataType $period_Salary_Plan_Data
     * @param \StructType\Proposed_Calculated_Plan_Assignment_Container_DataType $calculated_Plan_Data
     */
    public function __construct($primary_Compensation_Basis = null, $primary_Compensation_Basis_Amount_Change = null, $primary_Compensation_Basis_Percent_Change = null, \StructType\Compensatable_Default_Guidelines_DataType $guidelines_Data = null, \StructType\Proposed_Base_Pay_Plan_Assignment_Container_DataType $pay_Plan_Data = null, \StructType\Proposed_Salary_Unit_Plan_Assignment_Container_DataType $unit_Salary_Plan_Data = null, \StructType\Proposed_Allowance_Plan_Assignment_Container_DataType $allowance_Plan_Non_Unit_Based_Data = null, \StructType\Proposed_Allowance_Unit_Plan_Assignment_Container_DataType $allowance_Plan_Unit_Based_Data = null, \StructType\Proposed_Bonus_Plan_Assignment_Container_DataType $bonus_Plan_Data = null, \StructType\Proposed_Merit_Plan_Assignment_Container_DataType $merit_Plan_Data = null, \StructType\Proposed_Commission_Plan_Assignment_Container_DataType $commission_Plan_Data = null, \StructType\Proposed_Stock_Plan_Assignment_Container_DataType $stock_Plan_Data = null, \StructType\Proposed_Period_Salary_Plan_Assignment_Container_DataType $period_Salary_Plan_Data = null, \StructType\Proposed_Calculated_Plan_Assignment_Container_DataType $calculated_Plan_Data = null)
    {
        $this
            ->setPrimary_Compensation_Basis($primary_Compensation_Basis)
            ->setPrimary_Compensation_Basis_Amount_Change($primary_Compensation_Basis_Amount_Change)
            ->setPrimary_Compensation_Basis_Percent_Change($primary_Compensation_Basis_Percent_Change)
            ->setGuidelines_Data($guidelines_Data)
            ->setPay_Plan_Data($pay_Plan_Data)
            ->setUnit_Salary_Plan_Data($unit_Salary_Plan_Data)
            ->setAllowance_Plan_Non_Unit_Based_Data($allowance_Plan_Non_Unit_Based_Data)
            ->setAllowance_Plan_Unit_Based_Data($allowance_Plan_Unit_Based_Data)
            ->setBonus_Plan_Data($bonus_Plan_Data)
            ->setMerit_Plan_Data($merit_Plan_Data)
            ->setCommission_Plan_Data($commission_Plan_Data)
            ->setStock_Plan_Data($stock_Plan_Data)
            ->setPeriod_Salary_Plan_Data($period_Salary_Plan_Data)
            ->setCalculated_Plan_Data($calculated_Plan_Data);
    }
    /**
     * Get Primary_Compensation_Basis value
     * @return float|null
     */
    public function getPrimary_Compensation_Basis()
    {
        return isset($this->Primary_Compensation_Basis) ? $this->Primary_Compensation_Basis : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPrimary_Compensation_Basis method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrimary_Compensation_Basis method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePrimary_Compensation_BasisForChoiceConstraintsFromSetPrimary_Compensation_Basis($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Primary_Compensation_Basis_Amount_Change',
            'Primary_Compensation_Basis_Percent_Change',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Primary_Compensation_Basis can\'t be set as the property %s is already set. Only one property must be set among these properties: Primary_Compensation_Basis, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Primary_Compensation_Basis value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $primary_Compensation_Basis
     * @return \StructType\Compensation_Default_DataType
     */
    public function setPrimary_Compensation_Basis($primary_Compensation_Basis = null)
    {
        // validation for constraint: float
        if (!is_null($primary_Compensation_Basis) && !(is_float($primary_Compensation_Basis) || is_numeric($primary_Compensation_Basis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($primary_Compensation_Basis, true), gettype($primary_Compensation_Basis)), __LINE__);
        }
        // validation for constraint: choice(Primary_Compensation_Basis, Primary_Compensation_Basis_Amount_Change, Primary_Compensation_Basis_Percent_Change)
        if ('' !== ($primary_Compensation_BasisChoiceErrorMessage = self::validatePrimary_Compensation_BasisForChoiceConstraintsFromSetPrimary_Compensation_Basis($primary_Compensation_Basis))) {
            throw new \InvalidArgumentException($primary_Compensation_BasisChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($primary_Compensation_Basis) && mb_strlen(mb_substr($primary_Compensation_Basis, false !== mb_strpos($primary_Compensation_Basis, '.') ? mb_strpos($primary_Compensation_Basis, '.') + 1 : mb_strlen($primary_Compensation_Basis))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($primary_Compensation_Basis, true), mb_strlen(mb_substr($primary_Compensation_Basis, mb_strpos($primary_Compensation_Basis, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($primary_Compensation_Basis) && mb_strlen(preg_replace('/(\D)/', '', $primary_Compensation_Basis)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($primary_Compensation_Basis, true), mb_strlen(preg_replace('/(\D)/', '', $primary_Compensation_Basis))), __LINE__);
        }
        if (is_null($primary_Compensation_Basis) || (is_array($primary_Compensation_Basis) && empty($primary_Compensation_Basis))) {
            unset($this->Primary_Compensation_Basis);
        } else {
            $this->Primary_Compensation_Basis = $primary_Compensation_Basis;
        }
        return $this;
    }
    /**
     * Get Primary_Compensation_Basis_Amount_Change value
     * @return float|null
     */
    public function getPrimary_Compensation_Basis_Amount_Change()
    {
        return isset($this->Primary_Compensation_Basis_Amount_Change) ? $this->Primary_Compensation_Basis_Amount_Change : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPrimary_Compensation_Basis_Amount_Change method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrimary_Compensation_Basis_Amount_Change method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePrimary_Compensation_Basis_Amount_ChangeForChoiceConstraintsFromSetPrimary_Compensation_Basis_Amount_Change($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Primary_Compensation_Basis',
            'Primary_Compensation_Basis_Percent_Change',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Primary_Compensation_Basis_Amount_Change can\'t be set as the property %s is already set. Only one property must be set among these properties: Primary_Compensation_Basis_Amount_Change, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Primary_Compensation_Basis_Amount_Change value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $primary_Compensation_Basis_Amount_Change
     * @return \StructType\Compensation_Default_DataType
     */
    public function setPrimary_Compensation_Basis_Amount_Change($primary_Compensation_Basis_Amount_Change = null)
    {
        // validation for constraint: float
        if (!is_null($primary_Compensation_Basis_Amount_Change) && !(is_float($primary_Compensation_Basis_Amount_Change) || is_numeric($primary_Compensation_Basis_Amount_Change))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($primary_Compensation_Basis_Amount_Change, true), gettype($primary_Compensation_Basis_Amount_Change)), __LINE__);
        }
        // validation for constraint: choice(Primary_Compensation_Basis, Primary_Compensation_Basis_Amount_Change, Primary_Compensation_Basis_Percent_Change)
        if ('' !== ($primary_Compensation_Basis_Amount_ChangeChoiceErrorMessage = self::validatePrimary_Compensation_Basis_Amount_ChangeForChoiceConstraintsFromSetPrimary_Compensation_Basis_Amount_Change($primary_Compensation_Basis_Amount_Change))) {
            throw new \InvalidArgumentException($primary_Compensation_Basis_Amount_ChangeChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($primary_Compensation_Basis_Amount_Change) && mb_strlen(mb_substr($primary_Compensation_Basis_Amount_Change, false !== mb_strpos($primary_Compensation_Basis_Amount_Change, '.') ? mb_strpos($primary_Compensation_Basis_Amount_Change, '.') + 1 : mb_strlen($primary_Compensation_Basis_Amount_Change))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($primary_Compensation_Basis_Amount_Change, true), mb_strlen(mb_substr($primary_Compensation_Basis_Amount_Change, mb_strpos($primary_Compensation_Basis_Amount_Change, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($primary_Compensation_Basis_Amount_Change) && mb_strlen(preg_replace('/(\D)/', '', $primary_Compensation_Basis_Amount_Change)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($primary_Compensation_Basis_Amount_Change, true), mb_strlen(preg_replace('/(\D)/', '', $primary_Compensation_Basis_Amount_Change))), __LINE__);
        }
        if (is_null($primary_Compensation_Basis_Amount_Change) || (is_array($primary_Compensation_Basis_Amount_Change) && empty($primary_Compensation_Basis_Amount_Change))) {
            unset($this->Primary_Compensation_Basis_Amount_Change);
        } else {
            $this->Primary_Compensation_Basis_Amount_Change = $primary_Compensation_Basis_Amount_Change;
        }
        return $this;
    }
    /**
     * Get Primary_Compensation_Basis_Percent_Change value
     * @return float|null
     */
    public function getPrimary_Compensation_Basis_Percent_Change()
    {
        return isset($this->Primary_Compensation_Basis_Percent_Change) ? $this->Primary_Compensation_Basis_Percent_Change : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPrimary_Compensation_Basis_Percent_Change method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrimary_Compensation_Basis_Percent_Change method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePrimary_Compensation_Basis_Percent_ChangeForChoiceConstraintsFromSetPrimary_Compensation_Basis_Percent_Change($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Primary_Compensation_Basis',
            'Primary_Compensation_Basis_Amount_Change',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Primary_Compensation_Basis_Percent_Change can\'t be set as the property %s is already set. Only one property must be set among these properties: Primary_Compensation_Basis_Percent_Change, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Primary_Compensation_Basis_Percent_Change value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $primary_Compensation_Basis_Percent_Change
     * @return \StructType\Compensation_Default_DataType
     */
    public function setPrimary_Compensation_Basis_Percent_Change($primary_Compensation_Basis_Percent_Change = null)
    {
        // validation for constraint: float
        if (!is_null($primary_Compensation_Basis_Percent_Change) && !(is_float($primary_Compensation_Basis_Percent_Change) || is_numeric($primary_Compensation_Basis_Percent_Change))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($primary_Compensation_Basis_Percent_Change, true), gettype($primary_Compensation_Basis_Percent_Change)), __LINE__);
        }
        // validation for constraint: choice(Primary_Compensation_Basis, Primary_Compensation_Basis_Amount_Change, Primary_Compensation_Basis_Percent_Change)
        if ('' !== ($primary_Compensation_Basis_Percent_ChangeChoiceErrorMessage = self::validatePrimary_Compensation_Basis_Percent_ChangeForChoiceConstraintsFromSetPrimary_Compensation_Basis_Percent_Change($primary_Compensation_Basis_Percent_Change))) {
            throw new \InvalidArgumentException($primary_Compensation_Basis_Percent_ChangeChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($primary_Compensation_Basis_Percent_Change) && mb_strlen(mb_substr($primary_Compensation_Basis_Percent_Change, false !== mb_strpos($primary_Compensation_Basis_Percent_Change, '.') ? mb_strpos($primary_Compensation_Basis_Percent_Change, '.') + 1 : mb_strlen($primary_Compensation_Basis_Percent_Change))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($primary_Compensation_Basis_Percent_Change, true), mb_strlen(mb_substr($primary_Compensation_Basis_Percent_Change, mb_strpos($primary_Compensation_Basis_Percent_Change, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(21)
        if (!is_null($primary_Compensation_Basis_Percent_Change) && mb_strlen(preg_replace('/(\D)/', '', $primary_Compensation_Basis_Percent_Change)) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 21 digits, "%d" given', var_export($primary_Compensation_Basis_Percent_Change, true), mb_strlen(preg_replace('/(\D)/', '', $primary_Compensation_Basis_Percent_Change))), __LINE__);
        }
        if (is_null($primary_Compensation_Basis_Percent_Change) || (is_array($primary_Compensation_Basis_Percent_Change) && empty($primary_Compensation_Basis_Percent_Change))) {
            unset($this->Primary_Compensation_Basis_Percent_Change);
        } else {
            $this->Primary_Compensation_Basis_Percent_Change = $primary_Compensation_Basis_Percent_Change;
        }
        return $this;
    }
    /**
     * Get Guidelines_Data value
     * @return \StructType\Compensatable_Default_Guidelines_DataType|null
     */
    public function getGuidelines_Data()
    {
        return $this->Guidelines_Data;
    }
    /**
     * Set Guidelines_Data value
     * @param \StructType\Compensatable_Default_Guidelines_DataType $guidelines_Data
     * @return \StructType\Compensation_Default_DataType
     */
    public function setGuidelines_Data(\StructType\Compensatable_Default_Guidelines_DataType $guidelines_Data = null)
    {
        $this->Guidelines_Data = $guidelines_Data;
        return $this;
    }
    /**
     * Get Pay_Plan_Data value
     * @return \StructType\Proposed_Base_Pay_Plan_Assignment_Container_DataType|null
     */
    public function getPay_Plan_Data()
    {
        return $this->Pay_Plan_Data;
    }
    /**
     * Set Pay_Plan_Data value
     * @param \StructType\Proposed_Base_Pay_Plan_Assignment_Container_DataType $pay_Plan_Data
     * @return \StructType\Compensation_Default_DataType
     */
    public function setPay_Plan_Data(\StructType\Proposed_Base_Pay_Plan_Assignment_Container_DataType $pay_Plan_Data = null)
    {
        $this->Pay_Plan_Data = $pay_Plan_Data;
        return $this;
    }
    /**
     * Get Unit_Salary_Plan_Data value
     * @return \StructType\Proposed_Salary_Unit_Plan_Assignment_Container_DataType|null
     */
    public function getUnit_Salary_Plan_Data()
    {
        return $this->Unit_Salary_Plan_Data;
    }
    /**
     * Set Unit_Salary_Plan_Data value
     * @param \StructType\Proposed_Salary_Unit_Plan_Assignment_Container_DataType $unit_Salary_Plan_Data
     * @return \StructType\Compensation_Default_DataType
     */
    public function setUnit_Salary_Plan_Data(\StructType\Proposed_Salary_Unit_Plan_Assignment_Container_DataType $unit_Salary_Plan_Data = null)
    {
        $this->Unit_Salary_Plan_Data = $unit_Salary_Plan_Data;
        return $this;
    }
    /**
     * Get Allowance_Plan_Non_Unit_Based_Data value
     * @return \StructType\Proposed_Allowance_Plan_Assignment_Container_DataType|null
     */
    public function getAllowance_Plan_Non_Unit_Based_Data()
    {
        return $this->{'Allowance_Plan_Non-Unit_Based_Data'};
    }
    /**
     * Set Allowance_Plan_Non_Unit_Based_Data value
     * @param \StructType\Proposed_Allowance_Plan_Assignment_Container_DataType $allowance_Plan_Non_Unit_Based_Data
     * @return \StructType\Compensation_Default_DataType
     */
    public function setAllowance_Plan_Non_Unit_Based_Data(\StructType\Proposed_Allowance_Plan_Assignment_Container_DataType $allowance_Plan_Non_Unit_Based_Data = null)
    {
        $this->Allowance_Plan_Non_Unit_Based_Data = $this->{'Allowance_Plan_Non-Unit_Based_Data'} = $allowance_Plan_Non_Unit_Based_Data;
        return $this;
    }
    /**
     * Get Allowance_Plan_Unit_Based_Data value
     * @return \StructType\Proposed_Allowance_Unit_Plan_Assignment_Container_DataType|null
     */
    public function getAllowance_Plan_Unit_Based_Data()
    {
        return $this->Allowance_Plan_Unit_Based_Data;
    }
    /**
     * Set Allowance_Plan_Unit_Based_Data value
     * @param \StructType\Proposed_Allowance_Unit_Plan_Assignment_Container_DataType $allowance_Plan_Unit_Based_Data
     * @return \StructType\Compensation_Default_DataType
     */
    public function setAllowance_Plan_Unit_Based_Data(\StructType\Proposed_Allowance_Unit_Plan_Assignment_Container_DataType $allowance_Plan_Unit_Based_Data = null)
    {
        $this->Allowance_Plan_Unit_Based_Data = $allowance_Plan_Unit_Based_Data;
        return $this;
    }
    /**
     * Get Bonus_Plan_Data value
     * @return \StructType\Proposed_Bonus_Plan_Assignment_Container_DataType|null
     */
    public function getBonus_Plan_Data()
    {
        return $this->Bonus_Plan_Data;
    }
    /**
     * Set Bonus_Plan_Data value
     * @param \StructType\Proposed_Bonus_Plan_Assignment_Container_DataType $bonus_Plan_Data
     * @return \StructType\Compensation_Default_DataType
     */
    public function setBonus_Plan_Data(\StructType\Proposed_Bonus_Plan_Assignment_Container_DataType $bonus_Plan_Data = null)
    {
        $this->Bonus_Plan_Data = $bonus_Plan_Data;
        return $this;
    }
    /**
     * Get Merit_Plan_Data value
     * @return \StructType\Proposed_Merit_Plan_Assignment_Container_DataType|null
     */
    public function getMerit_Plan_Data()
    {
        return $this->Merit_Plan_Data;
    }
    /**
     * Set Merit_Plan_Data value
     * @param \StructType\Proposed_Merit_Plan_Assignment_Container_DataType $merit_Plan_Data
     * @return \StructType\Compensation_Default_DataType
     */
    public function setMerit_Plan_Data(\StructType\Proposed_Merit_Plan_Assignment_Container_DataType $merit_Plan_Data = null)
    {
        $this->Merit_Plan_Data = $merit_Plan_Data;
        return $this;
    }
    /**
     * Get Commission_Plan_Data value
     * @return \StructType\Proposed_Commission_Plan_Assignment_Container_DataType|null
     */
    public function getCommission_Plan_Data()
    {
        return $this->Commission_Plan_Data;
    }
    /**
     * Set Commission_Plan_Data value
     * @param \StructType\Proposed_Commission_Plan_Assignment_Container_DataType $commission_Plan_Data
     * @return \StructType\Compensation_Default_DataType
     */
    public function setCommission_Plan_Data(\StructType\Proposed_Commission_Plan_Assignment_Container_DataType $commission_Plan_Data = null)
    {
        $this->Commission_Plan_Data = $commission_Plan_Data;
        return $this;
    }
    /**
     * Get Stock_Plan_Data value
     * @return \StructType\Proposed_Stock_Plan_Assignment_Container_DataType|null
     */
    public function getStock_Plan_Data()
    {
        return $this->Stock_Plan_Data;
    }
    /**
     * Set Stock_Plan_Data value
     * @param \StructType\Proposed_Stock_Plan_Assignment_Container_DataType $stock_Plan_Data
     * @return \StructType\Compensation_Default_DataType
     */
    public function setStock_Plan_Data(\StructType\Proposed_Stock_Plan_Assignment_Container_DataType $stock_Plan_Data = null)
    {
        $this->Stock_Plan_Data = $stock_Plan_Data;
        return $this;
    }
    /**
     * Get Period_Salary_Plan_Data value
     * @return \StructType\Proposed_Period_Salary_Plan_Assignment_Container_DataType|null
     */
    public function getPeriod_Salary_Plan_Data()
    {
        return $this->Period_Salary_Plan_Data;
    }
    /**
     * Set Period_Salary_Plan_Data value
     * @param \StructType\Proposed_Period_Salary_Plan_Assignment_Container_DataType $period_Salary_Plan_Data
     * @return \StructType\Compensation_Default_DataType
     */
    public function setPeriod_Salary_Plan_Data(\StructType\Proposed_Period_Salary_Plan_Assignment_Container_DataType $period_Salary_Plan_Data = null)
    {
        $this->Period_Salary_Plan_Data = $period_Salary_Plan_Data;
        return $this;
    }
    /**
     * Get Calculated_Plan_Data value
     * @return \StructType\Proposed_Calculated_Plan_Assignment_Container_DataType|null
     */
    public function getCalculated_Plan_Data()
    {
        return $this->Calculated_Plan_Data;
    }
    /**
     * Set Calculated_Plan_Data value
     * @param \StructType\Proposed_Calculated_Plan_Assignment_Container_DataType $calculated_Plan_Data
     * @return \StructType\Compensation_Default_DataType
     */
    public function setCalculated_Plan_Data(\StructType\Proposed_Calculated_Plan_Assignment_Container_DataType $calculated_Plan_Data = null)
    {
        $this->Calculated_Plan_Data = $calculated_Plan_Data;
        return $this;
    }
}
