<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Status_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains candidate statuses.
 * @subpackage Structs
 */
class Candidate_Status_DataType extends AbstractStructBase
{
    /**
     * The Do_Not_Hire
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether a candidate is in a "Do Not Hire" status.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Do_Not_Hire;
    /**
     * The Withdrawn
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether a candidate is in a "Withdrawn" status.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Withdrawn;
    /**
     * Constructor method for Candidate_Status_DataType
     * @uses Candidate_Status_DataType::setDo_Not_Hire()
     * @uses Candidate_Status_DataType::setWithdrawn()
     * @param bool $do_Not_Hire
     * @param bool $withdrawn
     */
    public function __construct($do_Not_Hire = null, $withdrawn = null)
    {
        $this
            ->setDo_Not_Hire($do_Not_Hire)
            ->setWithdrawn($withdrawn);
    }
    /**
     * Get Do_Not_Hire value
     * @return bool|null
     */
    public function getDo_Not_Hire()
    {
        return $this->Do_Not_Hire;
    }
    /**
     * Set Do_Not_Hire value
     * @param bool $do_Not_Hire
     * @return \StructType\Candidate_Status_DataType
     */
    public function setDo_Not_Hire($do_Not_Hire = null)
    {
        // validation for constraint: boolean
        if (!is_null($do_Not_Hire) && !is_bool($do_Not_Hire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($do_Not_Hire, true), gettype($do_Not_Hire)), __LINE__);
        }
        $this->Do_Not_Hire = $do_Not_Hire;
        return $this;
    }
    /**
     * Get Withdrawn value
     * @return bool|null
     */
    public function getWithdrawn()
    {
        return $this->Withdrawn;
    }
    /**
     * Set Withdrawn value
     * @param bool $withdrawn
     * @return \StructType\Candidate_Status_DataType
     */
    public function setWithdrawn($withdrawn = null)
    {
        // validation for constraint: boolean
        if (!is_null($withdrawn) && !is_bool($withdrawn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withdrawn, true), gettype($withdrawn)), __LINE__);
        }
        $this->Withdrawn = $withdrawn;
        return $this;
    }
}
