<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Resume_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the candidate resume (skills, experience, and education). Do not remove the Candidate_Resume_Data section when the Enforce Required in Web Service check box is selected for a section on a Job Application Template.
 * @subpackage Structs
 */
class Candidate_Resume_DataType extends AbstractStructBase
{
    /**
     * The Summary
     * Meta information extracted from the WSDL
     * - documentation: The resume summary for the candidate.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Summary;
    /**
     * The Skill_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains skill items for the candidate.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_Skill_DataType[]
     */
    public $Skill_Data;
    /**
     * The Experience_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains the work experience for the candidate.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_Experience_DataType[]
     */
    public $Experience_Data;
    /**
     * The Education_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_Education_DataType[]
     */
    public $Education_Data;
    /**
     * The Certification_Data
     * Meta information extracted from the WSDL
     * - documentation: Candidate Certification Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_Certification_Skill_DataType[]
     */
    public $Certification_Data;
    /**
     * The Language_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_Language_Skill_DataType[]
     */
    public $Language_Data;
    /**
     * The Questionnaire_Response_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_Questionnaire_Response_DataType[]
     */
    public $Questionnaire_Response_Data;
    /**
     * Constructor method for Candidate_Resume_DataType
     * @uses Candidate_Resume_DataType::setSummary()
     * @uses Candidate_Resume_DataType::setSkill_Data()
     * @uses Candidate_Resume_DataType::setExperience_Data()
     * @uses Candidate_Resume_DataType::setEducation_Data()
     * @uses Candidate_Resume_DataType::setCertification_Data()
     * @uses Candidate_Resume_DataType::setLanguage_Data()
     * @uses Candidate_Resume_DataType::setQuestionnaire_Response_Data()
     * @param string $summary
     * @param \StructType\Candidate_Skill_DataType[] $skill_Data
     * @param \StructType\Candidate_Experience_DataType[] $experience_Data
     * @param \StructType\Candidate_Education_DataType[] $education_Data
     * @param \StructType\Candidate_Certification_Skill_DataType[] $certification_Data
     * @param \StructType\Candidate_Language_Skill_DataType[] $language_Data
     * @param \StructType\Candidate_Questionnaire_Response_DataType[] $questionnaire_Response_Data
     */
    public function __construct($summary = null, array $skill_Data = array(), array $experience_Data = array(), array $education_Data = array(), array $certification_Data = array(), array $language_Data = array(), array $questionnaire_Response_Data = array())
    {
        $this
            ->setSummary($summary)
            ->setSkill_Data($skill_Data)
            ->setExperience_Data($experience_Data)
            ->setEducation_Data($education_Data)
            ->setCertification_Data($certification_Data)
            ->setLanguage_Data($language_Data)
            ->setQuestionnaire_Response_Data($questionnaire_Response_Data);
    }
    /**
     * Get Summary value
     * @return string|null
     */
    public function getSummary()
    {
        return $this->Summary;
    }
    /**
     * Set Summary value
     * @param string $summary
     * @return \StructType\Candidate_Resume_DataType
     */
    public function setSummary($summary = null)
    {
        // validation for constraint: string
        if (!is_null($summary) && !is_string($summary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($summary, true), gettype($summary)), __LINE__);
        }
        $this->Summary = $summary;
        return $this;
    }
    /**
     * Get Skill_Data value
     * @return \StructType\Candidate_Skill_DataType[]|null
     */
    public function getSkill_Data()
    {
        return $this->Skill_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSkill_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSkill_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSkill_DataForArrayConstraintsFromSetSkill_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Resume_DataTypeSkill_DataItem) {
            // validation for constraint: itemType
            if (!$candidate_Resume_DataTypeSkill_DataItem instanceof \StructType\Candidate_Skill_DataType) {
                $invalidValues[] = is_object($candidate_Resume_DataTypeSkill_DataItem) ? get_class($candidate_Resume_DataTypeSkill_DataItem) : sprintf('%s(%s)', gettype($candidate_Resume_DataTypeSkill_DataItem), var_export($candidate_Resume_DataTypeSkill_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Skill_Data property can only contain items of type \StructType\Candidate_Skill_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Skill_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Skill_DataType[] $skill_Data
     * @return \StructType\Candidate_Resume_DataType
     */
    public function setSkill_Data(array $skill_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($skill_DataArrayErrorMessage = self::validateSkill_DataForArrayConstraintsFromSetSkill_Data($skill_Data))) {
            throw new \InvalidArgumentException($skill_DataArrayErrorMessage, __LINE__);
        }
        $this->Skill_Data = $skill_Data;
        return $this;
    }
    /**
     * Add item to Skill_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Skill_DataType $item
     * @return \StructType\Candidate_Resume_DataType
     */
    public function addToSkill_Data(\StructType\Candidate_Skill_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_Skill_DataType) {
            throw new \InvalidArgumentException(sprintf('The Skill_Data property can only contain items of type \StructType\Candidate_Skill_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Skill_Data[] = $item;
        return $this;
    }
    /**
     * Get Experience_Data value
     * @return \StructType\Candidate_Experience_DataType[]|null
     */
    public function getExperience_Data()
    {
        return $this->Experience_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setExperience_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExperience_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExperience_DataForArrayConstraintsFromSetExperience_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Resume_DataTypeExperience_DataItem) {
            // validation for constraint: itemType
            if (!$candidate_Resume_DataTypeExperience_DataItem instanceof \StructType\Candidate_Experience_DataType) {
                $invalidValues[] = is_object($candidate_Resume_DataTypeExperience_DataItem) ? get_class($candidate_Resume_DataTypeExperience_DataItem) : sprintf('%s(%s)', gettype($candidate_Resume_DataTypeExperience_DataItem), var_export($candidate_Resume_DataTypeExperience_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Experience_Data property can only contain items of type \StructType\Candidate_Experience_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Experience_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Experience_DataType[] $experience_Data
     * @return \StructType\Candidate_Resume_DataType
     */
    public function setExperience_Data(array $experience_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($experience_DataArrayErrorMessage = self::validateExperience_DataForArrayConstraintsFromSetExperience_Data($experience_Data))) {
            throw new \InvalidArgumentException($experience_DataArrayErrorMessage, __LINE__);
        }
        $this->Experience_Data = $experience_Data;
        return $this;
    }
    /**
     * Add item to Experience_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Experience_DataType $item
     * @return \StructType\Candidate_Resume_DataType
     */
    public function addToExperience_Data(\StructType\Candidate_Experience_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_Experience_DataType) {
            throw new \InvalidArgumentException(sprintf('The Experience_Data property can only contain items of type \StructType\Candidate_Experience_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Experience_Data[] = $item;
        return $this;
    }
    /**
     * Get Education_Data value
     * @return \StructType\Candidate_Education_DataType[]|null
     */
    public function getEducation_Data()
    {
        return $this->Education_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setEducation_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEducation_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEducation_DataForArrayConstraintsFromSetEducation_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Resume_DataTypeEducation_DataItem) {
            // validation for constraint: itemType
            if (!$candidate_Resume_DataTypeEducation_DataItem instanceof \StructType\Candidate_Education_DataType) {
                $invalidValues[] = is_object($candidate_Resume_DataTypeEducation_DataItem) ? get_class($candidate_Resume_DataTypeEducation_DataItem) : sprintf('%s(%s)', gettype($candidate_Resume_DataTypeEducation_DataItem), var_export($candidate_Resume_DataTypeEducation_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Education_Data property can only contain items of type \StructType\Candidate_Education_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Education_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Education_DataType[] $education_Data
     * @return \StructType\Candidate_Resume_DataType
     */
    public function setEducation_Data(array $education_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($education_DataArrayErrorMessage = self::validateEducation_DataForArrayConstraintsFromSetEducation_Data($education_Data))) {
            throw new \InvalidArgumentException($education_DataArrayErrorMessage, __LINE__);
        }
        $this->Education_Data = $education_Data;
        return $this;
    }
    /**
     * Add item to Education_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Education_DataType $item
     * @return \StructType\Candidate_Resume_DataType
     */
    public function addToEducation_Data(\StructType\Candidate_Education_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_Education_DataType) {
            throw new \InvalidArgumentException(sprintf('The Education_Data property can only contain items of type \StructType\Candidate_Education_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Education_Data[] = $item;
        return $this;
    }
    /**
     * Get Certification_Data value
     * @return \StructType\Candidate_Certification_Skill_DataType[]|null
     */
    public function getCertification_Data()
    {
        return $this->Certification_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCertification_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCertification_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCertification_DataForArrayConstraintsFromSetCertification_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Resume_DataTypeCertification_DataItem) {
            // validation for constraint: itemType
            if (!$candidate_Resume_DataTypeCertification_DataItem instanceof \StructType\Candidate_Certification_Skill_DataType) {
                $invalidValues[] = is_object($candidate_Resume_DataTypeCertification_DataItem) ? get_class($candidate_Resume_DataTypeCertification_DataItem) : sprintf('%s(%s)', gettype($candidate_Resume_DataTypeCertification_DataItem), var_export($candidate_Resume_DataTypeCertification_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Certification_Data property can only contain items of type \StructType\Candidate_Certification_Skill_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Certification_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Certification_Skill_DataType[] $certification_Data
     * @return \StructType\Candidate_Resume_DataType
     */
    public function setCertification_Data(array $certification_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($certification_DataArrayErrorMessage = self::validateCertification_DataForArrayConstraintsFromSetCertification_Data($certification_Data))) {
            throw new \InvalidArgumentException($certification_DataArrayErrorMessage, __LINE__);
        }
        $this->Certification_Data = $certification_Data;
        return $this;
    }
    /**
     * Add item to Certification_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Certification_Skill_DataType $item
     * @return \StructType\Candidate_Resume_DataType
     */
    public function addToCertification_Data(\StructType\Candidate_Certification_Skill_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_Certification_Skill_DataType) {
            throw new \InvalidArgumentException(sprintf('The Certification_Data property can only contain items of type \StructType\Candidate_Certification_Skill_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Certification_Data[] = $item;
        return $this;
    }
    /**
     * Get Language_Data value
     * @return \StructType\Candidate_Language_Skill_DataType[]|null
     */
    public function getLanguage_Data()
    {
        return $this->Language_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguage_DataForArrayConstraintsFromSetLanguage_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Resume_DataTypeLanguage_DataItem) {
            // validation for constraint: itemType
            if (!$candidate_Resume_DataTypeLanguage_DataItem instanceof \StructType\Candidate_Language_Skill_DataType) {
                $invalidValues[] = is_object($candidate_Resume_DataTypeLanguage_DataItem) ? get_class($candidate_Resume_DataTypeLanguage_DataItem) : sprintf('%s(%s)', gettype($candidate_Resume_DataTypeLanguage_DataItem), var_export($candidate_Resume_DataTypeLanguage_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Language_Data property can only contain items of type \StructType\Candidate_Language_Skill_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Language_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Language_Skill_DataType[] $language_Data
     * @return \StructType\Candidate_Resume_DataType
     */
    public function setLanguage_Data(array $language_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($language_DataArrayErrorMessage = self::validateLanguage_DataForArrayConstraintsFromSetLanguage_Data($language_Data))) {
            throw new \InvalidArgumentException($language_DataArrayErrorMessage, __LINE__);
        }
        $this->Language_Data = $language_Data;
        return $this;
    }
    /**
     * Add item to Language_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Language_Skill_DataType $item
     * @return \StructType\Candidate_Resume_DataType
     */
    public function addToLanguage_Data(\StructType\Candidate_Language_Skill_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_Language_Skill_DataType) {
            throw new \InvalidArgumentException(sprintf('The Language_Data property can only contain items of type \StructType\Candidate_Language_Skill_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Language_Data[] = $item;
        return $this;
    }
    /**
     * Get Questionnaire_Response_Data value
     * @return \StructType\Candidate_Questionnaire_Response_DataType[]|null
     */
    public function getQuestionnaire_Response_Data()
    {
        return $this->Questionnaire_Response_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setQuestionnaire_Response_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuestionnaire_Response_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQuestionnaire_Response_DataForArrayConstraintsFromSetQuestionnaire_Response_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Resume_DataTypeQuestionnaire_Response_DataItem) {
            // validation for constraint: itemType
            if (!$candidate_Resume_DataTypeQuestionnaire_Response_DataItem instanceof \StructType\Candidate_Questionnaire_Response_DataType) {
                $invalidValues[] = is_object($candidate_Resume_DataTypeQuestionnaire_Response_DataItem) ? get_class($candidate_Resume_DataTypeQuestionnaire_Response_DataItem) : sprintf('%s(%s)', gettype($candidate_Resume_DataTypeQuestionnaire_Response_DataItem), var_export($candidate_Resume_DataTypeQuestionnaire_Response_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Questionnaire_Response_Data property can only contain items of type \StructType\Candidate_Questionnaire_Response_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Questionnaire_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Questionnaire_Response_DataType[] $questionnaire_Response_Data
     * @return \StructType\Candidate_Resume_DataType
     */
    public function setQuestionnaire_Response_Data(array $questionnaire_Response_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($questionnaire_Response_DataArrayErrorMessage = self::validateQuestionnaire_Response_DataForArrayConstraintsFromSetQuestionnaire_Response_Data($questionnaire_Response_Data))) {
            throw new \InvalidArgumentException($questionnaire_Response_DataArrayErrorMessage, __LINE__);
        }
        $this->Questionnaire_Response_Data = $questionnaire_Response_Data;
        return $this;
    }
    /**
     * Add item to Questionnaire_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Questionnaire_Response_DataType $item
     * @return \StructType\Candidate_Resume_DataType
     */
    public function addToQuestionnaire_Response_Data(\StructType\Candidate_Questionnaire_Response_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_Questionnaire_Response_DataType) {
            throw new \InvalidArgumentException(sprintf('The Questionnaire_Response_Data property can only contain items of type \StructType\Candidate_Questionnaire_Response_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Questionnaire_Response_Data[] = $item;
        return $this;
    }
}
