<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains Candidate data.
 * @subpackage Structs
 */
class Candidate_Response_DataType extends AbstractStructBase
{
    /**
     * The Candidate
     * Meta information extracted from the WSDL
     * - documentation: Contains name data, contact data, recruiting data, and status data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CandidateType[]
     */
    public $Candidate;
    /**
     * Constructor method for Candidate_Response_DataType
     * @uses Candidate_Response_DataType::setCandidate()
     * @param \StructType\CandidateType[] $candidate
     */
    public function __construct(array $candidate = array())
    {
        $this
            ->setCandidate($candidate);
    }
    /**
     * Get Candidate value
     * @return \StructType\CandidateType[]|null
     */
    public function getCandidate()
    {
        return $this->Candidate;
    }
    /**
     * This method is responsible for validating the values passed to the setCandidate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCandidate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCandidateForArrayConstraintsFromSetCandidate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Response_DataTypeCandidateItem) {
            // validation for constraint: itemType
            if (!$candidate_Response_DataTypeCandidateItem instanceof \StructType\CandidateType) {
                $invalidValues[] = is_object($candidate_Response_DataTypeCandidateItem) ? get_class($candidate_Response_DataTypeCandidateItem) : sprintf('%s(%s)', gettype($candidate_Response_DataTypeCandidateItem), var_export($candidate_Response_DataTypeCandidateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Candidate property can only contain items of type \StructType\CandidateType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Candidate value
     * @throws \InvalidArgumentException
     * @param \StructType\CandidateType[] $candidate
     * @return \StructType\Candidate_Response_DataType
     */
    public function setCandidate(array $candidate = array())
    {
        // validation for constraint: array
        if ('' !== ($candidateArrayErrorMessage = self::validateCandidateForArrayConstraintsFromSetCandidate($candidate))) {
            throw new \InvalidArgumentException($candidateArrayErrorMessage, __LINE__);
        }
        $this->Candidate = $candidate;
        return $this;
    }
    /**
     * Add item to Candidate value
     * @throws \InvalidArgumentException
     * @param \StructType\CandidateType $item
     * @return \StructType\Candidate_Response_DataType
     */
    public function addToCandidate(\StructType\CandidateType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CandidateType) {
            throw new \InvalidArgumentException(sprintf('The Candidate property can only contain items of type \StructType\CandidateType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Candidate[] = $item;
        return $this;
    }
}
