<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Language_Skill_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for language profile
 * @subpackage Structs
 */
class Candidate_Language_Skill_DataType extends AbstractStructBase
{
    /**
     * The Language_Reference
     * Meta information extracted from the WSDL
     * - documentation: Language Reference
     * @var \StructType\LanguageObjectType
     */
    public $Language_Reference;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element for Language Achievement information
     * - maxOccurs: unbounded
     * @var \StructType\Candidate_Language_DataType[]
     */
    public $Language;
    /**
     * Constructor method for Candidate_Language_Skill_DataType
     * @uses Candidate_Language_Skill_DataType::setLanguage_Reference()
     * @uses Candidate_Language_Skill_DataType::setLanguage()
     * @param \StructType\LanguageObjectType $language_Reference
     * @param \StructType\Candidate_Language_DataType[] $language
     */
    public function __construct(\StructType\LanguageObjectType $language_Reference = null, array $language = array())
    {
        $this
            ->setLanguage_Reference($language_Reference)
            ->setLanguage($language);
    }
    /**
     * Get Language_Reference value
     * @return \StructType\LanguageObjectType|null
     */
    public function getLanguage_Reference()
    {
        return $this->Language_Reference;
    }
    /**
     * Set Language_Reference value
     * @param \StructType\LanguageObjectType $language_Reference
     * @return \StructType\Candidate_Language_Skill_DataType
     */
    public function setLanguage_Reference(\StructType\LanguageObjectType $language_Reference = null)
    {
        $this->Language_Reference = $language_Reference;
        return $this;
    }
    /**
     * Get Language value
     * @return \StructType\Candidate_Language_DataType[]|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * This method is responsible for validating the values passed to the setLanguage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLanguage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLanguageForArrayConstraintsFromSetLanguage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Language_Skill_DataTypeLanguageItem) {
            // validation for constraint: itemType
            if (!$candidate_Language_Skill_DataTypeLanguageItem instanceof \StructType\Candidate_Language_DataType) {
                $invalidValues[] = is_object($candidate_Language_Skill_DataTypeLanguageItem) ? get_class($candidate_Language_Skill_DataTypeLanguageItem) : sprintf('%s(%s)', gettype($candidate_Language_Skill_DataTypeLanguageItem), var_export($candidate_Language_Skill_DataTypeLanguageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Language property can only contain items of type \StructType\Candidate_Language_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Language value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Language_DataType[] $language
     * @return \StructType\Candidate_Language_Skill_DataType
     */
    public function setLanguage(array $language = array())
    {
        // validation for constraint: array
        if ('' !== ($languageArrayErrorMessage = self::validateLanguageForArrayConstraintsFromSetLanguage($language))) {
            throw new \InvalidArgumentException($languageArrayErrorMessage, __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Add item to Language value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Language_DataType $item
     * @return \StructType\Candidate_Language_Skill_DataType
     */
    public function addToLanguage(\StructType\Candidate_Language_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_Language_DataType) {
            throw new \InvalidArgumentException(sprintf('The Language property can only contain items of type \StructType\Candidate_Language_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Language[] = $item;
        return $this;
    }
}
