<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Contact_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains contact data for a candidate.
 * @subpackage Structs
 */
class Candidate_Contact_DataType extends AbstractStructBase
{
    /**
     * The Phone_Device_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The phone device type for the candidate's public primary phone number.
     * - minOccurs: 0
     * @var \StructType\Phone_Device_TypeObjectType
     */
    public $Phone_Device_Type_Reference;
    /**
     * The Country_Phone_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: The country phone code for the candidate's public primary phone number.
     * - minOccurs: 0
     * @var \StructType\Country_Phone_CodeObjectType
     */
    public $Country_Phone_Code_Reference;
    /**
     * The Phone_Number
     * Meta information extracted from the WSDL
     * - documentation: The public primary phone number for the candidate.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone_Number;
    /**
     * The Phone_Extension
     * Meta information extracted from the WSDL
     * - documentation: The phone extension for the candidate's public primary phone number.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone_Extension;
    /**
     * The Email_Address
     * Meta information extracted from the WSDL
     * - documentation: The public primary email address for the candidate.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email_Address;
    /**
     * The Website_Data
     * Meta information extracted from the WSDL
     * - documentation: The public web site(s) for the Candidate. Note: a full sync of web sites for the Candidate is expected when this web service is used.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_Websites_DataType[]
     */
    public $Website_Data;
    /**
     * The Location_Data
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element for Candidates' Country and Postal Code.
     * - minOccurs: 0
     * @var \StructType\Candidate_Location_DataType
     */
    public $Location_Data;
    /**
     * Constructor method for Candidate_Contact_DataType
     * @uses Candidate_Contact_DataType::setPhone_Device_Type_Reference()
     * @uses Candidate_Contact_DataType::setCountry_Phone_Code_Reference()
     * @uses Candidate_Contact_DataType::setPhone_Number()
     * @uses Candidate_Contact_DataType::setPhone_Extension()
     * @uses Candidate_Contact_DataType::setEmail_Address()
     * @uses Candidate_Contact_DataType::setWebsite_Data()
     * @uses Candidate_Contact_DataType::setLocation_Data()
     * @param \StructType\Phone_Device_TypeObjectType $phone_Device_Type_Reference
     * @param \StructType\Country_Phone_CodeObjectType $country_Phone_Code_Reference
     * @param string $phone_Number
     * @param string $phone_Extension
     * @param string $email_Address
     * @param \StructType\Candidate_Websites_DataType[] $website_Data
     * @param \StructType\Candidate_Location_DataType $location_Data
     */
    public function __construct(\StructType\Phone_Device_TypeObjectType $phone_Device_Type_Reference = null, \StructType\Country_Phone_CodeObjectType $country_Phone_Code_Reference = null, $phone_Number = null, $phone_Extension = null, $email_Address = null, array $website_Data = array(), \StructType\Candidate_Location_DataType $location_Data = null)
    {
        $this
            ->setPhone_Device_Type_Reference($phone_Device_Type_Reference)
            ->setCountry_Phone_Code_Reference($country_Phone_Code_Reference)
            ->setPhone_Number($phone_Number)
            ->setPhone_Extension($phone_Extension)
            ->setEmail_Address($email_Address)
            ->setWebsite_Data($website_Data)
            ->setLocation_Data($location_Data);
    }
    /**
     * Get Phone_Device_Type_Reference value
     * @return \StructType\Phone_Device_TypeObjectType|null
     */
    public function getPhone_Device_Type_Reference()
    {
        return $this->Phone_Device_Type_Reference;
    }
    /**
     * Set Phone_Device_Type_Reference value
     * @param \StructType\Phone_Device_TypeObjectType $phone_Device_Type_Reference
     * @return \StructType\Candidate_Contact_DataType
     */
    public function setPhone_Device_Type_Reference(\StructType\Phone_Device_TypeObjectType $phone_Device_Type_Reference = null)
    {
        $this->Phone_Device_Type_Reference = $phone_Device_Type_Reference;
        return $this;
    }
    /**
     * Get Country_Phone_Code_Reference value
     * @return \StructType\Country_Phone_CodeObjectType|null
     */
    public function getCountry_Phone_Code_Reference()
    {
        return $this->Country_Phone_Code_Reference;
    }
    /**
     * Set Country_Phone_Code_Reference value
     * @param \StructType\Country_Phone_CodeObjectType $country_Phone_Code_Reference
     * @return \StructType\Candidate_Contact_DataType
     */
    public function setCountry_Phone_Code_Reference(\StructType\Country_Phone_CodeObjectType $country_Phone_Code_Reference = null)
    {
        $this->Country_Phone_Code_Reference = $country_Phone_Code_Reference;
        return $this;
    }
    /**
     * Get Phone_Number value
     * @return string|null
     */
    public function getPhone_Number()
    {
        return $this->Phone_Number;
    }
    /**
     * Set Phone_Number value
     * @param string $phone_Number
     * @return \StructType\Candidate_Contact_DataType
     */
    public function setPhone_Number($phone_Number = null)
    {
        // validation for constraint: string
        if (!is_null($phone_Number) && !is_string($phone_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone_Number, true), gettype($phone_Number)), __LINE__);
        }
        $this->Phone_Number = $phone_Number;
        return $this;
    }
    /**
     * Get Phone_Extension value
     * @return string|null
     */
    public function getPhone_Extension()
    {
        return $this->Phone_Extension;
    }
    /**
     * Set Phone_Extension value
     * @param string $phone_Extension
     * @return \StructType\Candidate_Contact_DataType
     */
    public function setPhone_Extension($phone_Extension = null)
    {
        // validation for constraint: string
        if (!is_null($phone_Extension) && !is_string($phone_Extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone_Extension, true), gettype($phone_Extension)), __LINE__);
        }
        $this->Phone_Extension = $phone_Extension;
        return $this;
    }
    /**
     * Get Email_Address value
     * @return string|null
     */
    public function getEmail_Address()
    {
        return $this->Email_Address;
    }
    /**
     * Set Email_Address value
     * @param string $email_Address
     * @return \StructType\Candidate_Contact_DataType
     */
    public function setEmail_Address($email_Address = null)
    {
        // validation for constraint: string
        if (!is_null($email_Address) && !is_string($email_Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email_Address, true), gettype($email_Address)), __LINE__);
        }
        $this->Email_Address = $email_Address;
        return $this;
    }
    /**
     * Get Website_Data value
     * @return \StructType\Candidate_Websites_DataType[]|null
     */
    public function getWebsite_Data()
    {
        return $this->Website_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setWebsite_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWebsite_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWebsite_DataForArrayConstraintsFromSetWebsite_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Contact_DataTypeWebsite_DataItem) {
            // validation for constraint: itemType
            if (!$candidate_Contact_DataTypeWebsite_DataItem instanceof \StructType\Candidate_Websites_DataType) {
                $invalidValues[] = is_object($candidate_Contact_DataTypeWebsite_DataItem) ? get_class($candidate_Contact_DataTypeWebsite_DataItem) : sprintf('%s(%s)', gettype($candidate_Contact_DataTypeWebsite_DataItem), var_export($candidate_Contact_DataTypeWebsite_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Website_Data property can only contain items of type \StructType\Candidate_Websites_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Website_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Websites_DataType[] $website_Data
     * @return \StructType\Candidate_Contact_DataType
     */
    public function setWebsite_Data(array $website_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($website_DataArrayErrorMessage = self::validateWebsite_DataForArrayConstraintsFromSetWebsite_Data($website_Data))) {
            throw new \InvalidArgumentException($website_DataArrayErrorMessage, __LINE__);
        }
        $this->Website_Data = $website_Data;
        return $this;
    }
    /**
     * Add item to Website_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Websites_DataType $item
     * @return \StructType\Candidate_Contact_DataType
     */
    public function addToWebsite_Data(\StructType\Candidate_Websites_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_Websites_DataType) {
            throw new \InvalidArgumentException(sprintf('The Website_Data property can only contain items of type \StructType\Candidate_Websites_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Website_Data[] = $item;
        return $this;
    }
    /**
     * Get Location_Data value
     * @return \StructType\Candidate_Location_DataType|null
     */
    public function getLocation_Data()
    {
        return $this->Location_Data;
    }
    /**
     * Set Location_Data value
     * @param \StructType\Candidate_Location_DataType $location_Data
     * @return \StructType\Candidate_Contact_DataType
     */
    public function setLocation_Data(\StructType\Candidate_Location_DataType $location_Data = null)
    {
        $this->Location_Data = $location_Data;
        return $this;
    }
}
