<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Certification_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Enter an Examination Date that is on or after January 1, 1930. | Enter an Expiration Date that is on or after January 1, 1930. | Enter an Issue Date that is on or after January 1, 1930. | Checks that there are either no duplicates,
 * or the only duplicate returned is this instance (an edit is happening) | Exam Date must be less than or equal to Issued Date. | Issued Date must be less than or equal to today's date. | You must first select Enable Specialties for Certifications on
 * the Maintain Skills and Experience Setup task. | Exam Date must be less than Expiration Date. | Expiration Date may not be prior to Issued Date. | Contains the certification information.
 * @subpackage Structs
 */
class Candidate_Certification_DataType extends AbstractStructBase
{
    /**
     * The Certification_ID
     * Meta information extracted from the WSDL
     * - documentation: Certification ID. If no value is provided, a new certification will be created. If a value is passed in and a corresponding certification is not found, a new certification will be created with the provided id.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Certification_ID;
    /**
     * The Remove_Certification
     * Meta information extracted from the WSDL
     * - documentation: Used for inbound operations to indicate that the certification should be removed for the person. Will always return false for outbound operations.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Remove_Certification;
    /**
     * The Country_Reference
     * Meta information extracted from the WSDL
     * - documentation: The country in which the certification is used.
     * - minOccurs: 0
     * @var \StructType\CountryObjectType
     */
    public $Country_Reference;
    /**
     * The Certification_Reference
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element for the Certification Reference, i.e. from the list of pre-defined certifications.
     * @var \StructType\CertificationObjectType
     */
    public $Certification_Reference;
    /**
     * The Certification_Number
     * Meta information extracted from the WSDL
     * - documentation: Certification Number for the Certification.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Certification_Number;
    /**
     * The Exam_Date
     * Meta information extracted from the WSDL
     * - documentation: The date of expiration of the certification.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Exam_Date;
    /**
     * The Exam_Score
     * Meta information extracted from the WSDL
     * - documentation: The person's score on the certification examination.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Exam_Score;
    /**
     * The Issued_Date
     * Meta information extracted from the WSDL
     * - documentation: The date the certification was issued.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Issued_Date;
    /**
     * The Expiration_Date
     * Meta information extracted from the WSDL
     * - documentation: The date of expiration of the certification.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expiration_Date;
    /**
     * The Specialty_Data_Details
     * Meta information extracted from the WSDL
     * - documentation: This data contains information about any specialties and subspecialties associated with the certification achievement.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Candidate_Specialty_Achievement_DataType[]
     */
    public $Specialty_Data_Details;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Attachment_WWS_DataType[]
     */
    public $Attachment_Data;
    /**
     * Constructor method for Candidate_Certification_DataType
     * @uses Candidate_Certification_DataType::setCertification_ID()
     * @uses Candidate_Certification_DataType::setRemove_Certification()
     * @uses Candidate_Certification_DataType::setCountry_Reference()
     * @uses Candidate_Certification_DataType::setCertification_Reference()
     * @uses Candidate_Certification_DataType::setCertification_Number()
     * @uses Candidate_Certification_DataType::setExam_Date()
     * @uses Candidate_Certification_DataType::setExam_Score()
     * @uses Candidate_Certification_DataType::setIssued_Date()
     * @uses Candidate_Certification_DataType::setExpiration_Date()
     * @uses Candidate_Certification_DataType::setSpecialty_Data_Details()
     * @uses Candidate_Certification_DataType::setAttachment_Data()
     * @param string $certification_ID
     * @param bool $remove_Certification
     * @param \StructType\CountryObjectType $country_Reference
     * @param \StructType\CertificationObjectType $certification_Reference
     * @param string $certification_Number
     * @param string $exam_Date
     * @param string $exam_Score
     * @param string $issued_Date
     * @param string $expiration_Date
     * @param \StructType\Candidate_Specialty_Achievement_DataType[] $specialty_Data_Details
     * @param \StructType\Attachment_WWS_DataType[] $attachment_Data
     */
    public function __construct($certification_ID = null, $remove_Certification = null, \StructType\CountryObjectType $country_Reference = null, \StructType\CertificationObjectType $certification_Reference = null, $certification_Number = null, $exam_Date = null, $exam_Score = null, $issued_Date = null, $expiration_Date = null, array $specialty_Data_Details = array(), array $attachment_Data = array())
    {
        $this
            ->setCertification_ID($certification_ID)
            ->setRemove_Certification($remove_Certification)
            ->setCountry_Reference($country_Reference)
            ->setCertification_Reference($certification_Reference)
            ->setCertification_Number($certification_Number)
            ->setExam_Date($exam_Date)
            ->setExam_Score($exam_Score)
            ->setIssued_Date($issued_Date)
            ->setExpiration_Date($expiration_Date)
            ->setSpecialty_Data_Details($specialty_Data_Details)
            ->setAttachment_Data($attachment_Data);
    }
    /**
     * Get Certification_ID value
     * @return string|null
     */
    public function getCertification_ID()
    {
        return $this->Certification_ID;
    }
    /**
     * Set Certification_ID value
     * @param string $certification_ID
     * @return \StructType\Candidate_Certification_DataType
     */
    public function setCertification_ID($certification_ID = null)
    {
        // validation for constraint: string
        if (!is_null($certification_ID) && !is_string($certification_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certification_ID, true), gettype($certification_ID)), __LINE__);
        }
        $this->Certification_ID = $certification_ID;
        return $this;
    }
    /**
     * Get Remove_Certification value
     * @return bool|null
     */
    public function getRemove_Certification()
    {
        return $this->Remove_Certification;
    }
    /**
     * Set Remove_Certification value
     * @param bool $remove_Certification
     * @return \StructType\Candidate_Certification_DataType
     */
    public function setRemove_Certification($remove_Certification = null)
    {
        // validation for constraint: boolean
        if (!is_null($remove_Certification) && !is_bool($remove_Certification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($remove_Certification, true), gettype($remove_Certification)), __LINE__);
        }
        $this->Remove_Certification = $remove_Certification;
        return $this;
    }
    /**
     * Get Country_Reference value
     * @return \StructType\CountryObjectType|null
     */
    public function getCountry_Reference()
    {
        return $this->Country_Reference;
    }
    /**
     * Set Country_Reference value
     * @param \StructType\CountryObjectType $country_Reference
     * @return \StructType\Candidate_Certification_DataType
     */
    public function setCountry_Reference(\StructType\CountryObjectType $country_Reference = null)
    {
        $this->Country_Reference = $country_Reference;
        return $this;
    }
    /**
     * Get Certification_Reference value
     * @return \StructType\CertificationObjectType|null
     */
    public function getCertification_Reference()
    {
        return $this->Certification_Reference;
    }
    /**
     * Set Certification_Reference value
     * @param \StructType\CertificationObjectType $certification_Reference
     * @return \StructType\Candidate_Certification_DataType
     */
    public function setCertification_Reference(\StructType\CertificationObjectType $certification_Reference = null)
    {
        $this->Certification_Reference = $certification_Reference;
        return $this;
    }
    /**
     * Get Certification_Number value
     * @return string|null
     */
    public function getCertification_Number()
    {
        return $this->Certification_Number;
    }
    /**
     * Set Certification_Number value
     * @param string $certification_Number
     * @return \StructType\Candidate_Certification_DataType
     */
    public function setCertification_Number($certification_Number = null)
    {
        // validation for constraint: string
        if (!is_null($certification_Number) && !is_string($certification_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certification_Number, true), gettype($certification_Number)), __LINE__);
        }
        $this->Certification_Number = $certification_Number;
        return $this;
    }
    /**
     * Get Exam_Date value
     * @return string|null
     */
    public function getExam_Date()
    {
        return $this->Exam_Date;
    }
    /**
     * Set Exam_Date value
     * @param string $exam_Date
     * @return \StructType\Candidate_Certification_DataType
     */
    public function setExam_Date($exam_Date = null)
    {
        // validation for constraint: string
        if (!is_null($exam_Date) && !is_string($exam_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exam_Date, true), gettype($exam_Date)), __LINE__);
        }
        $this->Exam_Date = $exam_Date;
        return $this;
    }
    /**
     * Get Exam_Score value
     * @return string|null
     */
    public function getExam_Score()
    {
        return $this->Exam_Score;
    }
    /**
     * Set Exam_Score value
     * @param string $exam_Score
     * @return \StructType\Candidate_Certification_DataType
     */
    public function setExam_Score($exam_Score = null)
    {
        // validation for constraint: string
        if (!is_null($exam_Score) && !is_string($exam_Score)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exam_Score, true), gettype($exam_Score)), __LINE__);
        }
        $this->Exam_Score = $exam_Score;
        return $this;
    }
    /**
     * Get Issued_Date value
     * @return string|null
     */
    public function getIssued_Date()
    {
        return $this->Issued_Date;
    }
    /**
     * Set Issued_Date value
     * @param string $issued_Date
     * @return \StructType\Candidate_Certification_DataType
     */
    public function setIssued_Date($issued_Date = null)
    {
        // validation for constraint: string
        if (!is_null($issued_Date) && !is_string($issued_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issued_Date, true), gettype($issued_Date)), __LINE__);
        }
        $this->Issued_Date = $issued_Date;
        return $this;
    }
    /**
     * Get Expiration_Date value
     * @return string|null
     */
    public function getExpiration_Date()
    {
        return $this->Expiration_Date;
    }
    /**
     * Set Expiration_Date value
     * @param string $expiration_Date
     * @return \StructType\Candidate_Certification_DataType
     */
    public function setExpiration_Date($expiration_Date = null)
    {
        // validation for constraint: string
        if (!is_null($expiration_Date) && !is_string($expiration_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiration_Date, true), gettype($expiration_Date)), __LINE__);
        }
        $this->Expiration_Date = $expiration_Date;
        return $this;
    }
    /**
     * Get Specialty_Data_Details value
     * @return \StructType\Candidate_Specialty_Achievement_DataType[]|null
     */
    public function getSpecialty_Data_Details()
    {
        return $this->Specialty_Data_Details;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialty_Data_Details method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialty_Data_Details method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialty_Data_DetailsForArrayConstraintsFromSetSpecialty_Data_Details(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Certification_DataTypeSpecialty_Data_DetailsItem) {
            // validation for constraint: itemType
            if (!$candidate_Certification_DataTypeSpecialty_Data_DetailsItem instanceof \StructType\Candidate_Specialty_Achievement_DataType) {
                $invalidValues[] = is_object($candidate_Certification_DataTypeSpecialty_Data_DetailsItem) ? get_class($candidate_Certification_DataTypeSpecialty_Data_DetailsItem) : sprintf('%s(%s)', gettype($candidate_Certification_DataTypeSpecialty_Data_DetailsItem), var_export($candidate_Certification_DataTypeSpecialty_Data_DetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Specialty_Data_Details property can only contain items of type \StructType\Candidate_Specialty_Achievement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Specialty_Data_Details value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Specialty_Achievement_DataType[] $specialty_Data_Details
     * @return \StructType\Candidate_Certification_DataType
     */
    public function setSpecialty_Data_Details(array $specialty_Data_Details = array())
    {
        // validation for constraint: array
        if ('' !== ($specialty_Data_DetailsArrayErrorMessage = self::validateSpecialty_Data_DetailsForArrayConstraintsFromSetSpecialty_Data_Details($specialty_Data_Details))) {
            throw new \InvalidArgumentException($specialty_Data_DetailsArrayErrorMessage, __LINE__);
        }
        $this->Specialty_Data_Details = $specialty_Data_Details;
        return $this;
    }
    /**
     * Add item to Specialty_Data_Details value
     * @throws \InvalidArgumentException
     * @param \StructType\Candidate_Specialty_Achievement_DataType $item
     * @return \StructType\Candidate_Certification_DataType
     */
    public function addToSpecialty_Data_Details(\StructType\Candidate_Specialty_Achievement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Candidate_Specialty_Achievement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Specialty_Data_Details property can only contain items of type \StructType\Candidate_Specialty_Achievement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Specialty_Data_Details[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Attachment_WWS_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Certification_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$candidate_Certification_DataTypeAttachment_DataItem instanceof \StructType\Attachment_WWS_DataType) {
                $invalidValues[] = is_object($candidate_Certification_DataTypeAttachment_DataItem) ? get_class($candidate_Certification_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($candidate_Certification_DataTypeAttachment_DataItem), var_export($candidate_Certification_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Attachment_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment_WWS_DataType[] $attachment_Data
     * @return \StructType\Candidate_Certification_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment_WWS_DataType $item
     * @return \StructType\Candidate_Certification_DataType
     */
    public function addToAttachment_Data(\StructType\Attachment_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attachment_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Attachment_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
}
