<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Candidate_Attachment_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Utilize the following criteria options to search for Candidate attachments within the Workday system.
 * @subpackage Structs
 */
class Candidate_Attachment_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Candidate_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Candidate.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CandidateObjectType[]
     */
    public $Candidate_Reference;
    /**
     * Constructor method for Candidate_Attachment_Request_CriteriaType
     * @uses Candidate_Attachment_Request_CriteriaType::setCandidate_Reference()
     * @param \StructType\CandidateObjectType[] $candidate_Reference
     */
    public function __construct(array $candidate_Reference = array())
    {
        $this
            ->setCandidate_Reference($candidate_Reference);
    }
    /**
     * Get Candidate_Reference value
     * @return \StructType\CandidateObjectType[]|null
     */
    public function getCandidate_Reference()
    {
        return $this->Candidate_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCandidate_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCandidate_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCandidate_ReferenceForArrayConstraintsFromSetCandidate_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $candidate_Attachment_Request_CriteriaTypeCandidate_ReferenceItem) {
            // validation for constraint: itemType
            if (!$candidate_Attachment_Request_CriteriaTypeCandidate_ReferenceItem instanceof \StructType\CandidateObjectType) {
                $invalidValues[] = is_object($candidate_Attachment_Request_CriteriaTypeCandidate_ReferenceItem) ? get_class($candidate_Attachment_Request_CriteriaTypeCandidate_ReferenceItem) : sprintf('%s(%s)', gettype($candidate_Attachment_Request_CriteriaTypeCandidate_ReferenceItem), var_export($candidate_Attachment_Request_CriteriaTypeCandidate_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Candidate_Reference property can only contain items of type \StructType\CandidateObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Candidate_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CandidateObjectType[] $candidate_Reference
     * @return \StructType\Candidate_Attachment_Request_CriteriaType
     */
    public function setCandidate_Reference(array $candidate_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($candidate_ReferenceArrayErrorMessage = self::validateCandidate_ReferenceForArrayConstraintsFromSetCandidate_Reference($candidate_Reference))) {
            throw new \InvalidArgumentException($candidate_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Candidate_Reference = $candidate_Reference;
        return $this;
    }
    /**
     * Add item to Candidate_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CandidateObjectType $item
     * @return \StructType\Candidate_Attachment_Request_CriteriaType
     */
    public function addToCandidate_Reference(\StructType\CandidateObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CandidateObjectType) {
            throw new \InvalidArgumentException(sprintf('The Candidate_Reference property can only contain items of type \StructType\CandidateObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Candidate_Reference[] = $item;
        return $this;
    }
}
