<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Brand_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element container for button, header, and additional component data for a brand.
 * @subpackage Structs
 */
class Brand_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier for the brand.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Publish_Brand
     * Meta information extracted from the WSDL
     * - documentation: Check box indicates that the service should mark the site brand as published or unpublished.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Publish_Brand;
    /**
     * The General_Settings_Data
     * Meta information extracted from the WSDL
     * - documentation: Element container for brand general settings.
     * @var \StructType\Brand_General_Settings_DataType
     */
    public $General_Settings_Data;
    /**
     * The Header_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Header_DataType
     */
    public $Header_Data;
    /**
     * The Buttons_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Button_DataType
     */
    public $Buttons_Data;
    /**
     * The Additional_Component_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Additional_Component_DataType
     */
    public $Additional_Component_Data;
    /**
     * Constructor method for Brand_DataType
     * @uses Brand_DataType::setID()
     * @uses Brand_DataType::setPublish_Brand()
     * @uses Brand_DataType::setGeneral_Settings_Data()
     * @uses Brand_DataType::setHeader_Data()
     * @uses Brand_DataType::setButtons_Data()
     * @uses Brand_DataType::setAdditional_Component_Data()
     * @param string $iD
     * @param bool $publish_Brand
     * @param \StructType\Brand_General_Settings_DataType $general_Settings_Data
     * @param \StructType\Header_DataType $header_Data
     * @param \StructType\Button_DataType $buttons_Data
     * @param \StructType\Additional_Component_DataType $additional_Component_Data
     */
    public function __construct($iD = null, $publish_Brand = null, \StructType\Brand_General_Settings_DataType $general_Settings_Data = null, \StructType\Header_DataType $header_Data = null, \StructType\Button_DataType $buttons_Data = null, \StructType\Additional_Component_DataType $additional_Component_Data = null)
    {
        $this
            ->setID($iD)
            ->setPublish_Brand($publish_Brand)
            ->setGeneral_Settings_Data($general_Settings_Data)
            ->setHeader_Data($header_Data)
            ->setButtons_Data($buttons_Data)
            ->setAdditional_Component_Data($additional_Component_Data);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Brand_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Publish_Brand value
     * @return bool|null
     */
    public function getPublish_Brand()
    {
        return $this->Publish_Brand;
    }
    /**
     * Set Publish_Brand value
     * @param bool $publish_Brand
     * @return \StructType\Brand_DataType
     */
    public function setPublish_Brand($publish_Brand = null)
    {
        // validation for constraint: boolean
        if (!is_null($publish_Brand) && !is_bool($publish_Brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($publish_Brand, true), gettype($publish_Brand)), __LINE__);
        }
        $this->Publish_Brand = $publish_Brand;
        return $this;
    }
    /**
     * Get General_Settings_Data value
     * @return \StructType\Brand_General_Settings_DataType|null
     */
    public function getGeneral_Settings_Data()
    {
        return $this->General_Settings_Data;
    }
    /**
     * Set General_Settings_Data value
     * @param \StructType\Brand_General_Settings_DataType $general_Settings_Data
     * @return \StructType\Brand_DataType
     */
    public function setGeneral_Settings_Data(\StructType\Brand_General_Settings_DataType $general_Settings_Data = null)
    {
        $this->General_Settings_Data = $general_Settings_Data;
        return $this;
    }
    /**
     * Get Header_Data value
     * @return \StructType\Header_DataType|null
     */
    public function getHeader_Data()
    {
        return $this->Header_Data;
    }
    /**
     * Set Header_Data value
     * @param \StructType\Header_DataType $header_Data
     * @return \StructType\Brand_DataType
     */
    public function setHeader_Data(\StructType\Header_DataType $header_Data = null)
    {
        $this->Header_Data = $header_Data;
        return $this;
    }
    /**
     * Get Buttons_Data value
     * @return \StructType\Button_DataType|null
     */
    public function getButtons_Data()
    {
        return $this->Buttons_Data;
    }
    /**
     * Set Buttons_Data value
     * @param \StructType\Button_DataType $buttons_Data
     * @return \StructType\Brand_DataType
     */
    public function setButtons_Data(\StructType\Button_DataType $buttons_Data = null)
    {
        $this->Buttons_Data = $buttons_Data;
        return $this;
    }
    /**
     * Get Additional_Component_Data value
     * @return \StructType\Additional_Component_DataType|null
     */
    public function getAdditional_Component_Data()
    {
        return $this->Additional_Component_Data;
    }
    /**
     * Set Additional_Component_Data value
     * @param \StructType\Additional_Component_DataType $additional_Component_Data
     * @return \StructType\Brand_DataType
     */
    public function setAdditional_Component_Data(\StructType\Additional_Component_DataType $additional_Component_Data = null)
    {
        $this->Additional_Component_Data = $additional_Component_Data;
        return $this;
    }
}
