<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Background_Check_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Utilize the Request Criteria element to filter the returned Background Check Events to those Payees that meet ALL of the criteria.
 * @subpackage Structs
 */
class Background_Check_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Requester_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the background check submitter.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Requester_Reference;
    /**
     * The Recipient_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a candidate, worker, or pre-hire.
     * - minOccurs: 0
     * @var \StructType\RoleObjectType
     */
    public $Recipient_Reference;
    /**
     * The Submission_Date
     * Meta information extracted from the WSDL
     * - documentation: Date the background check event was initiated.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Submission_Date;
    /**
     * The Workflow_State_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to the State of the Workflow Event. Supports WIDs only.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Workflow_State_Reference;
    /**
     * The Package_Selected
     * Meta information extracted from the WSDL
     * - documentation: List only those background checks that include a background check package.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Package_Selected;
    /**
     * The Field_And_Parameter_Criteria_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Field_And_Parameter_Criteria_DataType
     */
    public $Field_And_Parameter_Criteria_Data;
    /**
     * Constructor method for Background_Check_Request_CriteriaType
     * @uses Background_Check_Request_CriteriaType::setRequester_Reference()
     * @uses Background_Check_Request_CriteriaType::setRecipient_Reference()
     * @uses Background_Check_Request_CriteriaType::setSubmission_Date()
     * @uses Background_Check_Request_CriteriaType::setWorkflow_State_Reference()
     * @uses Background_Check_Request_CriteriaType::setPackage_Selected()
     * @uses Background_Check_Request_CriteriaType::setField_And_Parameter_Criteria_Data()
     * @param \StructType\WorkerObjectType $requester_Reference
     * @param \StructType\RoleObjectType $recipient_Reference
     * @param string $submission_Date
     * @param \StructType\Unique_IdentifierObjectType $workflow_State_Reference
     * @param bool $package_Selected
     * @param \StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data
     */
    public function __construct(\StructType\WorkerObjectType $requester_Reference = null, \StructType\RoleObjectType $recipient_Reference = null, $submission_Date = null, \StructType\Unique_IdentifierObjectType $workflow_State_Reference = null, $package_Selected = null, \StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data = null)
    {
        $this
            ->setRequester_Reference($requester_Reference)
            ->setRecipient_Reference($recipient_Reference)
            ->setSubmission_Date($submission_Date)
            ->setWorkflow_State_Reference($workflow_State_Reference)
            ->setPackage_Selected($package_Selected)
            ->setField_And_Parameter_Criteria_Data($field_And_Parameter_Criteria_Data);
    }
    /**
     * Get Requester_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getRequester_Reference()
    {
        return $this->Requester_Reference;
    }
    /**
     * Set Requester_Reference value
     * @param \StructType\WorkerObjectType $requester_Reference
     * @return \StructType\Background_Check_Request_CriteriaType
     */
    public function setRequester_Reference(\StructType\WorkerObjectType $requester_Reference = null)
    {
        $this->Requester_Reference = $requester_Reference;
        return $this;
    }
    /**
     * Get Recipient_Reference value
     * @return \StructType\RoleObjectType|null
     */
    public function getRecipient_Reference()
    {
        return $this->Recipient_Reference;
    }
    /**
     * Set Recipient_Reference value
     * @param \StructType\RoleObjectType $recipient_Reference
     * @return \StructType\Background_Check_Request_CriteriaType
     */
    public function setRecipient_Reference(\StructType\RoleObjectType $recipient_Reference = null)
    {
        $this->Recipient_Reference = $recipient_Reference;
        return $this;
    }
    /**
     * Get Submission_Date value
     * @return string|null
     */
    public function getSubmission_Date()
    {
        return $this->Submission_Date;
    }
    /**
     * Set Submission_Date value
     * @param string $submission_Date
     * @return \StructType\Background_Check_Request_CriteriaType
     */
    public function setSubmission_Date($submission_Date = null)
    {
        // validation for constraint: string
        if (!is_null($submission_Date) && !is_string($submission_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($submission_Date, true), gettype($submission_Date)), __LINE__);
        }
        $this->Submission_Date = $submission_Date;
        return $this;
    }
    /**
     * Get Workflow_State_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getWorkflow_State_Reference()
    {
        return $this->Workflow_State_Reference;
    }
    /**
     * Set Workflow_State_Reference value
     * @param \StructType\Unique_IdentifierObjectType $workflow_State_Reference
     * @return \StructType\Background_Check_Request_CriteriaType
     */
    public function setWorkflow_State_Reference(\StructType\Unique_IdentifierObjectType $workflow_State_Reference = null)
    {
        $this->Workflow_State_Reference = $workflow_State_Reference;
        return $this;
    }
    /**
     * Get Package_Selected value
     * @return bool|null
     */
    public function getPackage_Selected()
    {
        return $this->Package_Selected;
    }
    /**
     * Set Package_Selected value
     * @param bool $package_Selected
     * @return \StructType\Background_Check_Request_CriteriaType
     */
    public function setPackage_Selected($package_Selected = null)
    {
        // validation for constraint: boolean
        if (!is_null($package_Selected) && !is_bool($package_Selected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($package_Selected, true), gettype($package_Selected)), __LINE__);
        }
        $this->Package_Selected = $package_Selected;
        return $this;
    }
    /**
     * Get Field_And_Parameter_Criteria_Data value
     * @return \StructType\Field_And_Parameter_Criteria_DataType|null
     */
    public function getField_And_Parameter_Criteria_Data()
    {
        return $this->Field_And_Parameter_Criteria_Data;
    }
    /**
     * Set Field_And_Parameter_Criteria_Data value
     * @param \StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data
     * @return \StructType\Background_Check_Request_CriteriaType
     */
    public function setField_And_Parameter_Criteria_Data(\StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data = null)
    {
        $this->Field_And_Parameter_Criteria_Data = $field_And_Parameter_Criteria_Data;
        return $this;
    }
}
