<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Background_Check_Package_TestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Background Check Package data and related tests.
 * @subpackage Structs
 */
class Background_Check_Package_TestType extends AbstractStructBase
{
    /**
     * The Background_Check_Package_Test_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID of the Background Check Package Test to update.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Background_Check_Package_Test_Reference_ID;
    /**
     * The Background_Check_Test_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains information about the Background Check Package Test.
     * @var \StructType\Background_Check_Package_Test_DataType
     */
    public $Background_Check_Test_Data;
    /**
     * Constructor method for Background_Check_Package_TestType
     * @uses Background_Check_Package_TestType::setBackground_Check_Package_Test_Reference_ID()
     * @uses Background_Check_Package_TestType::setBackground_Check_Test_Data()
     * @param string $background_Check_Package_Test_Reference_ID
     * @param \StructType\Background_Check_Package_Test_DataType $background_Check_Test_Data
     */
    public function __construct($background_Check_Package_Test_Reference_ID = null, \StructType\Background_Check_Package_Test_DataType $background_Check_Test_Data = null)
    {
        $this
            ->setBackground_Check_Package_Test_Reference_ID($background_Check_Package_Test_Reference_ID)
            ->setBackground_Check_Test_Data($background_Check_Test_Data);
    }
    /**
     * Get Background_Check_Package_Test_Reference_ID value
     * @return string|null
     */
    public function getBackground_Check_Package_Test_Reference_ID()
    {
        return $this->Background_Check_Package_Test_Reference_ID;
    }
    /**
     * Set Background_Check_Package_Test_Reference_ID value
     * @param string $background_Check_Package_Test_Reference_ID
     * @return \StructType\Background_Check_Package_TestType
     */
    public function setBackground_Check_Package_Test_Reference_ID($background_Check_Package_Test_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($background_Check_Package_Test_Reference_ID) && !is_string($background_Check_Package_Test_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($background_Check_Package_Test_Reference_ID, true), gettype($background_Check_Package_Test_Reference_ID)), __LINE__);
        }
        $this->Background_Check_Package_Test_Reference_ID = $background_Check_Package_Test_Reference_ID;
        return $this;
    }
    /**
     * Get Background_Check_Test_Data value
     * @return \StructType\Background_Check_Package_Test_DataType|null
     */
    public function getBackground_Check_Test_Data()
    {
        return $this->Background_Check_Test_Data;
    }
    /**
     * Set Background_Check_Test_Data value
     * @param \StructType\Background_Check_Package_Test_DataType $background_Check_Test_Data
     * @return \StructType\Background_Check_Package_TestType
     */
    public function setBackground_Check_Test_Data(\StructType\Background_Check_Package_Test_DataType $background_Check_Test_Data = null)
    {
        $this->Background_Check_Test_Data = $background_Check_Test_Data;
        return $this;
    }
}
