<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assign_Costing_Allocation_Event_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the costing allocation for the position.
 * @subpackage Structs
 */
class Assign_Costing_Allocation_Event_DataType extends AbstractStructBase
{
    /**
     * The Costing_Override_Data
     * Meta information extracted from the WSDL
     * - documentation: Specified the costing allocation for a given date range.
     * - maxOccurs: unbounded
     * @var \StructType\Costing_Allocation_Interval_DataType[]
     */
    public $Costing_Override_Data;
    /**
     * The Costing_Allocation_Level_Reference
     * Meta information extracted from the WSDL
     * - documentation: Specifies the costing allocation level for the given costing allocation.
     * @var \StructType\Costing_Allocation_LevelObjectType
     */
    public $Costing_Allocation_Level_Reference;
    /**
     * The Costing_Allocation_Earning_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Earning for this Costing Allocation. This is both required and only allowed when the Costing Allocation Level includes Earning.
     * - minOccurs: 0
     * @var \StructType\Earning__All_ObjectType
     */
    public $Costing_Allocation_Earning_Reference;
    /**
     * Constructor method for Assign_Costing_Allocation_Event_DataType
     * @uses Assign_Costing_Allocation_Event_DataType::setCosting_Override_Data()
     * @uses Assign_Costing_Allocation_Event_DataType::setCosting_Allocation_Level_Reference()
     * @uses Assign_Costing_Allocation_Event_DataType::setCosting_Allocation_Earning_Reference()
     * @param \StructType\Costing_Allocation_Interval_DataType[] $costing_Override_Data
     * @param \StructType\Costing_Allocation_LevelObjectType $costing_Allocation_Level_Reference
     * @param \StructType\Earning__All_ObjectType $costing_Allocation_Earning_Reference
     */
    public function __construct(array $costing_Override_Data = array(), \StructType\Costing_Allocation_LevelObjectType $costing_Allocation_Level_Reference = null, \StructType\Earning__All_ObjectType $costing_Allocation_Earning_Reference = null)
    {
        $this
            ->setCosting_Override_Data($costing_Override_Data)
            ->setCosting_Allocation_Level_Reference($costing_Allocation_Level_Reference)
            ->setCosting_Allocation_Earning_Reference($costing_Allocation_Earning_Reference);
    }
    /**
     * Get Costing_Override_Data value
     * @return \StructType\Costing_Allocation_Interval_DataType[]|null
     */
    public function getCosting_Override_Data()
    {
        return $this->Costing_Override_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCosting_Override_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCosting_Override_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCosting_Override_DataForArrayConstraintsFromSetCosting_Override_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assign_Costing_Allocation_Event_DataTypeCosting_Override_DataItem) {
            // validation for constraint: itemType
            if (!$assign_Costing_Allocation_Event_DataTypeCosting_Override_DataItem instanceof \StructType\Costing_Allocation_Interval_DataType) {
                $invalidValues[] = is_object($assign_Costing_Allocation_Event_DataTypeCosting_Override_DataItem) ? get_class($assign_Costing_Allocation_Event_DataTypeCosting_Override_DataItem) : sprintf('%s(%s)', gettype($assign_Costing_Allocation_Event_DataTypeCosting_Override_DataItem), var_export($assign_Costing_Allocation_Event_DataTypeCosting_Override_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Costing_Override_Data property can only contain items of type \StructType\Costing_Allocation_Interval_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Costing_Override_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Costing_Allocation_Interval_DataType[] $costing_Override_Data
     * @return \StructType\Assign_Costing_Allocation_Event_DataType
     */
    public function setCosting_Override_Data(array $costing_Override_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($costing_Override_DataArrayErrorMessage = self::validateCosting_Override_DataForArrayConstraintsFromSetCosting_Override_Data($costing_Override_Data))) {
            throw new \InvalidArgumentException($costing_Override_DataArrayErrorMessage, __LINE__);
        }
        $this->Costing_Override_Data = $costing_Override_Data;
        return $this;
    }
    /**
     * Add item to Costing_Override_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Costing_Allocation_Interval_DataType $item
     * @return \StructType\Assign_Costing_Allocation_Event_DataType
     */
    public function addToCosting_Override_Data(\StructType\Costing_Allocation_Interval_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Costing_Allocation_Interval_DataType) {
            throw new \InvalidArgumentException(sprintf('The Costing_Override_Data property can only contain items of type \StructType\Costing_Allocation_Interval_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Costing_Override_Data[] = $item;
        return $this;
    }
    /**
     * Get Costing_Allocation_Level_Reference value
     * @return \StructType\Costing_Allocation_LevelObjectType|null
     */
    public function getCosting_Allocation_Level_Reference()
    {
        return $this->Costing_Allocation_Level_Reference;
    }
    /**
     * Set Costing_Allocation_Level_Reference value
     * @param \StructType\Costing_Allocation_LevelObjectType $costing_Allocation_Level_Reference
     * @return \StructType\Assign_Costing_Allocation_Event_DataType
     */
    public function setCosting_Allocation_Level_Reference(\StructType\Costing_Allocation_LevelObjectType $costing_Allocation_Level_Reference = null)
    {
        $this->Costing_Allocation_Level_Reference = $costing_Allocation_Level_Reference;
        return $this;
    }
    /**
     * Get Costing_Allocation_Earning_Reference value
     * @return \StructType\Earning__All_ObjectType|null
     */
    public function getCosting_Allocation_Earning_Reference()
    {
        return $this->Costing_Allocation_Earning_Reference;
    }
    /**
     * Set Costing_Allocation_Earning_Reference value
     * @param \StructType\Earning__All_ObjectType $costing_Allocation_Earning_Reference
     * @return \StructType\Assign_Costing_Allocation_Event_DataType
     */
    public function setCosting_Allocation_Earning_Reference(\StructType\Earning__All_ObjectType $costing_Allocation_Earning_Reference = null)
    {
        $this->Costing_Allocation_Earning_Reference = $costing_Allocation_Earning_Reference;
        return $this;
    }
}
