<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assess_Candidate_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The result of a Candidate Assessment request. Will contain the result of the added or modified Candidate Assessment.
 * @subpackage Structs
 */
class Assess_Candidate_Response_DataType extends AbstractStructBase
{
    /**
     * The Assess_Candidate_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Assess_Candidate_EventType[]
     */
    public $Assess_Candidate_Data;
    /**
     * The Inline_Assessment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Inline_Assessment_DataType[]
     */
    public $Inline_Assessment_Data;
    /**
     * Constructor method for Assess_Candidate_Response_DataType
     * @uses Assess_Candidate_Response_DataType::setAssess_Candidate_Data()
     * @uses Assess_Candidate_Response_DataType::setInline_Assessment_Data()
     * @param \StructType\Assess_Candidate_EventType[] $assess_Candidate_Data
     * @param \StructType\Inline_Assessment_DataType[] $inline_Assessment_Data
     */
    public function __construct(array $assess_Candidate_Data = array(), array $inline_Assessment_Data = array())
    {
        $this
            ->setAssess_Candidate_Data($assess_Candidate_Data)
            ->setInline_Assessment_Data($inline_Assessment_Data);
    }
    /**
     * Get Assess_Candidate_Data value
     * @return \StructType\Assess_Candidate_EventType[]|null
     */
    public function getAssess_Candidate_Data()
    {
        return $this->Assess_Candidate_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAssess_Candidate_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssess_Candidate_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssess_Candidate_DataForArrayConstraintsFromSetAssess_Candidate_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assess_Candidate_Response_DataTypeAssess_Candidate_DataItem) {
            // validation for constraint: itemType
            if (!$assess_Candidate_Response_DataTypeAssess_Candidate_DataItem instanceof \StructType\Assess_Candidate_EventType) {
                $invalidValues[] = is_object($assess_Candidate_Response_DataTypeAssess_Candidate_DataItem) ? get_class($assess_Candidate_Response_DataTypeAssess_Candidate_DataItem) : sprintf('%s(%s)', gettype($assess_Candidate_Response_DataTypeAssess_Candidate_DataItem), var_export($assess_Candidate_Response_DataTypeAssess_Candidate_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Assess_Candidate_Data property can only contain items of type \StructType\Assess_Candidate_EventType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Assess_Candidate_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Assess_Candidate_EventType[] $assess_Candidate_Data
     * @return \StructType\Assess_Candidate_Response_DataType
     */
    public function setAssess_Candidate_Data(array $assess_Candidate_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($assess_Candidate_DataArrayErrorMessage = self::validateAssess_Candidate_DataForArrayConstraintsFromSetAssess_Candidate_Data($assess_Candidate_Data))) {
            throw new \InvalidArgumentException($assess_Candidate_DataArrayErrorMessage, __LINE__);
        }
        $this->Assess_Candidate_Data = $assess_Candidate_Data;
        return $this;
    }
    /**
     * Add item to Assess_Candidate_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Assess_Candidate_EventType $item
     * @return \StructType\Assess_Candidate_Response_DataType
     */
    public function addToAssess_Candidate_Data(\StructType\Assess_Candidate_EventType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Assess_Candidate_EventType) {
            throw new \InvalidArgumentException(sprintf('The Assess_Candidate_Data property can only contain items of type \StructType\Assess_Candidate_EventType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Assess_Candidate_Data[] = $item;
        return $this;
    }
    /**
     * Get Inline_Assessment_Data value
     * @return \StructType\Inline_Assessment_DataType[]|null
     */
    public function getInline_Assessment_Data()
    {
        return $this->Inline_Assessment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setInline_Assessment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInline_Assessment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInline_Assessment_DataForArrayConstraintsFromSetInline_Assessment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $assess_Candidate_Response_DataTypeInline_Assessment_DataItem) {
            // validation for constraint: itemType
            if (!$assess_Candidate_Response_DataTypeInline_Assessment_DataItem instanceof \StructType\Inline_Assessment_DataType) {
                $invalidValues[] = is_object($assess_Candidate_Response_DataTypeInline_Assessment_DataItem) ? get_class($assess_Candidate_Response_DataTypeInline_Assessment_DataItem) : sprintf('%s(%s)', gettype($assess_Candidate_Response_DataTypeInline_Assessment_DataItem), var_export($assess_Candidate_Response_DataTypeInline_Assessment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Inline_Assessment_Data property can only contain items of type \StructType\Inline_Assessment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Inline_Assessment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Inline_Assessment_DataType[] $inline_Assessment_Data
     * @return \StructType\Assess_Candidate_Response_DataType
     */
    public function setInline_Assessment_Data(array $inline_Assessment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($inline_Assessment_DataArrayErrorMessage = self::validateInline_Assessment_DataForArrayConstraintsFromSetInline_Assessment_Data($inline_Assessment_Data))) {
            throw new \InvalidArgumentException($inline_Assessment_DataArrayErrorMessage, __LINE__);
        }
        $this->Inline_Assessment_Data = $inline_Assessment_Data;
        return $this;
    }
    /**
     * Add item to Inline_Assessment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Inline_Assessment_DataType $item
     * @return \StructType\Assess_Candidate_Response_DataType
     */
    public function addToInline_Assessment_Data(\StructType\Inline_Assessment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Inline_Assessment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Inline_Assessment_Data property can only contain items of type \StructType\Inline_Assessment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Inline_Assessment_Data[] = $item;
        return $this;
    }
}
