<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Applicant_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Utilize the following criteria options to search for Applicants within the Workday system. The Applicant references that are returned are those that satisfy ALL criteria included in the request. Therefore, the result set will become
 * more limited with every criterium that is populated.
 * @subpackage Structs
 */
class Applicant_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Search for a pre-hire by specifying the contingent worker id. The contingent worker id could be the current contingent worker id for the pre-hire (where the pre-hire is still currently also a contingent worker in the system), or the
     * previous contingent worker id for the pre-hire where the pre-hire is no longer a contingent worker.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Worker_Reference;
    /**
     * The Former_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Search for a pre-hire by specifying the former worker id.
     * - minOccurs: 0
     * @var \StructType\Former_WorkerObjectType
     */
    public $Former_Worker_Reference;
    /**
     * The Email_Address
     * Meta information extracted from the WSDL
     * - documentation: If specified, this search criterium will return those references with an exact match. The search index used to query on this value is not case-sensitive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email_Address;
    /**
     * The Field_And_Parameter_Criteria_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Field_And_Parameter_Criteria_DataType
     */
    public $Field_And_Parameter_Criteria_Data;
    /**
     * Constructor method for Applicant_Request_CriteriaType
     * @uses Applicant_Request_CriteriaType::setWorker_Reference()
     * @uses Applicant_Request_CriteriaType::setFormer_Worker_Reference()
     * @uses Applicant_Request_CriteriaType::setEmail_Address()
     * @uses Applicant_Request_CriteriaType::setField_And_Parameter_Criteria_Data()
     * @param \StructType\WorkerObjectType $worker_Reference
     * @param \StructType\Former_WorkerObjectType $former_Worker_Reference
     * @param string $email_Address
     * @param \StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data
     */
    public function __construct(\StructType\WorkerObjectType $worker_Reference = null, \StructType\Former_WorkerObjectType $former_Worker_Reference = null, $email_Address = null, \StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data = null)
    {
        $this
            ->setWorker_Reference($worker_Reference)
            ->setFormer_Worker_Reference($former_Worker_Reference)
            ->setEmail_Address($email_Address)
            ->setField_And_Parameter_Criteria_Data($field_And_Parameter_Criteria_Data);
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * Set Worker_Reference value
     * @param \StructType\WorkerObjectType $worker_Reference
     * @return \StructType\Applicant_Request_CriteriaType
     */
    public function setWorker_Reference(\StructType\WorkerObjectType $worker_Reference = null)
    {
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Get Former_Worker_Reference value
     * @return \StructType\Former_WorkerObjectType|null
     */
    public function getFormer_Worker_Reference()
    {
        return $this->Former_Worker_Reference;
    }
    /**
     * Set Former_Worker_Reference value
     * @param \StructType\Former_WorkerObjectType $former_Worker_Reference
     * @return \StructType\Applicant_Request_CriteriaType
     */
    public function setFormer_Worker_Reference(\StructType\Former_WorkerObjectType $former_Worker_Reference = null)
    {
        $this->Former_Worker_Reference = $former_Worker_Reference;
        return $this;
    }
    /**
     * Get Email_Address value
     * @return string|null
     */
    public function getEmail_Address()
    {
        return $this->Email_Address;
    }
    /**
     * Set Email_Address value
     * @param string $email_Address
     * @return \StructType\Applicant_Request_CriteriaType
     */
    public function setEmail_Address($email_Address = null)
    {
        // validation for constraint: string
        if (!is_null($email_Address) && !is_string($email_Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email_Address, true), gettype($email_Address)), __LINE__);
        }
        $this->Email_Address = $email_Address;
        return $this;
    }
    /**
     * Get Field_And_Parameter_Criteria_Data value
     * @return \StructType\Field_And_Parameter_Criteria_DataType|null
     */
    public function getField_And_Parameter_Criteria_Data()
    {
        return $this->Field_And_Parameter_Criteria_Data;
    }
    /**
     * Set Field_And_Parameter_Criteria_Data value
     * @param \StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data
     * @return \StructType\Applicant_Request_CriteriaType
     */
    public function setField_And_Parameter_Criteria_Data(\StructType\Field_And_Parameter_Criteria_DataType $field_And_Parameter_Criteria_Data = null)
    {
        $this->Field_And_Parameter_Criteria_Data = $field_And_Parameter_Criteria_Data;
        return $this;
    }
}
