<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Put ServiceType
 * @subpackage Services
 */
class Put extends AbstractSoapClientBase
{
    /**
     * Sets the Workday_Common_Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Workday_Common_HeaderType $workday_Common_Header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWorkday_Common_Header(\StructType\Workday_Common_HeaderType $workday_Common_Header, $nameSpace = 'urn:com.workday/bsvc', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Workday_Common_Header', $workday_Common_Header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Put_Applicant
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Adds a new pre-hire (or updates an existing pre-hire) with the information supplied in the request. Note: pre-hire was previously called applicant. However, the web service operation and its elements are not yet renamed, so that
     * existing integrations continue to work.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Applicant_RequestType $body
     * @return \StructType\Put_Applicant_ResponseType|bool
     */
    public function Put_Applicant(\StructType\Put_Applicant_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Applicant($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Candidate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Adds or updates a candidate with the information supplied in the request.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Candidate_RequestType $body
     * @return \StructType\Put_Candidate_ResponseType|bool
     */
    public function Put_Candidate(\StructType\Put_Candidate_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Candidate($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Candidate_Attachment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation adds an attachment to a Candidate and/or a Candidate's Job Application.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Candidate_Attachment_RequestType $body
     * @return \StructType\Put_Candidate_Attachment_ResponseType|bool
     */
    public function Put_Candidate_Attachment(\StructType\Put_Candidate_Attachment_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Candidate_Attachment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Job_Posting_Site
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Adds a generic job posting board to the tenant.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Job_Posting_Site_RequestType $body
     * @return \StructType\Put_Job_Posting_Site_ResponseType|bool
     */
    public function Put_Job_Posting_Site(\StructType\Put_Job_Posting_Site_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Job_Posting_Site($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Candidate_Photo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation adds an image to a Candidate.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Candidate_Photo_RequestType $body
     * @return \StructType\Put_Candidate_Photos_ResponseType|bool
     */
    public function Put_Candidate_Photo(\StructType\Put_Candidate_Photo_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Candidate_Photo($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Background_Check_Package
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service task to create or update background check packages.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Background_Check_Package_RequestType $body
     * @return \StructType\Put_Background_Check_Package_ResponseType|bool
     */
    public function Put_Background_Check_Package(\StructType\Put_Background_Check_Package_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Background_Check_Package($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Background_Check
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Load background check results for a Background Check Event.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Background_Check_RequestType $body
     * @return \StructType\Put_Background_Check_ResponseType|bool
     */
    public function Put_Background_Check(\StructType\Put_Background_Check_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Background_Check($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Recruiting_Agency_User
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Adds or updates a recruiting agency user with the information supplied in the request.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Recruiting_Agency_User_RequestType $body
     * @return \StructType\Put_Recruiting_Agency_User_ResponseType|bool
     */
    public function Put_Recruiting_Agency_User(\StructType\Put_Recruiting_Agency_User_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Recruiting_Agency_User($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Primary_Posting
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Updates an existing Job Posting to make it the Primary Posting, used in social share and invite to apply.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Primary_Posting_RequestType $body
     * @return \StructType\Put_Primary_Posting_ResponseType|bool
     */
    public function Put_Primary_Posting(\StructType\Put_Primary_Posting_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Primary_Posting($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Job_Application_Additional_Data
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Adds or updates Job Application with the Additional Data information supplied in the request.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Job_Application_Additional_Data_RequestType $body
     * @return \StructType\Put_Job_Application_Additional_Data_ResponseType|bool
     */
    public function Put_Job_Application_Additional_Data(\StructType\Put_Job_Application_Additional_Data_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Job_Application_Additional_Data($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Recruiting_Agency
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Add or update a Recruiting Agency specified with the information supplied in the request.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Recruiting_Agency_RequestType $body
     * @return \StructType\Put_Recruiting_Agency_ResponseType|bool
     */
    public function Put_Recruiting_Agency(\StructType\Put_Recruiting_Agency_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Recruiting_Agency($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Recruiting_Agency_Additional_Data
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Add or update additional data to the Recruiting Agency specified. Additional data can only be added for custom objects already associated with Recruiting Agencies.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Recruiting_Agency_Additional_Data_RequestType $body
     * @return \StructType\Put_Recruiting_Agency_Additional_Data_ResponseType|bool
     */
    public function Put_Recruiting_Agency_Additional_Data(\StructType\Put_Recruiting_Agency_Additional_Data_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Recruiting_Agency_Additional_Data($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Job_Requisition_Interview_Settings
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Put web services for Manage Interview Team task.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Job_Requisition_Interview_Settings_RequestType $body
     * @return \StructType\Put_Job_Requisition_Interview_Settings_ResponseType|bool
     */
    public function Put_Job_Requisition_Interview_Settings(\StructType\Put_Job_Requisition_Interview_Settings_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Job_Requisition_Interview_Settings($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Interview
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Submits Interview Data for the Schedule Interview task.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Interview_RequestType $body
     * @return \StructType\Put_Interview_ResponseType|bool
     */
    public function Put_Interview(\StructType\Put_Interview_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Interview($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Interview_Feedback
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Submits Interview Feedback for Interviewers on the Interview Schedule. Also, allows you to move a candidate to the next stage of the business process.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Interview_Feedback_RequestType $body
     * @return \StructType\Put_Interview_Feedback_ResponseType|bool
     */
    public function Put_Interview_Feedback(\StructType\Put_Interview_Feedback_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Interview_Feedback($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Veteran_Status
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Creates a new Veteran Status with the information supplied in the request.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Veteran_Status_RequestType $body
     * @return \StructType\Put_Veteran_Status_ResponseType|bool
     */
    public function Put_Veteran_Status(\StructType\Put_Veteran_Status_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Veteran_Status($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Undo_Move_from_Hire
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Undo the move from a staffing process back to the originating job application process.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Undo_Move_from_Hire_RequestType $body
     * @return \StructType\Put_Undo_Move_from_Hire_ResponseType|bool
     */
    public function Put_Undo_Move_from_Hire(\StructType\Put_Undo_Move_from_Hire_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Undo_Move_from_Hire($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Recruiting_Self-Schedule_Calendar_Type
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service operation to add, update or delete a Recruiting Self-Schedule Calendar Type.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Recruiting_Self_Schedule_Calendar_Type_RequestType $body
     * @return \StructType\Put_Recruiting_Self_Schedule_Calendar_Type_ResponseType|bool
     */
    public function Put_Recruiting_Self_Schedule_Calendar_Type(\StructType\Put_Recruiting_Self_Schedule_Calendar_Type_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->__call('Put_Recruiting_Self-Schedule_Calendar_Type', array(
                $body,
            )));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Recruiting_Self-Schedule_Calendar
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service operation to add, update or delete a Recruiting Self-Schedule Calendar.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Recruiting_Self_Schedule_Calendar_RequestType $body
     * @return \StructType\Put_Recruiting_Self_Schedule_Calendar_ResponseType|bool
     */
    public function Put_Recruiting_Self_Schedule_Calendar(\StructType\Put_Recruiting_Self_Schedule_Calendar_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->__call('Put_Recruiting_Self-Schedule_Calendar', array(
                $body,
            )));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Recruiting_Assessment_Category
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Create or Update Recruiting Assessment CatagoriesNot Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Recruiting_Assessment_Category_RequestType $body
     * @return \StructType\Put_Recruiting_Assessment_Category_ResponseType|bool
     */
    public function Put_Recruiting_Assessment_Category(\StructType\Put_Recruiting_Assessment_Category_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Recruiting_Assessment_Category($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Recruiting_Assessment_Category_Security_Segment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service operation to add, update or delete a Recruiting Assessment Category Security Segment.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Recruiting_Assessment_Category_Security_Segment_RequestType $body
     * @return \StructType\Put_Recruiting_Assessment_Category_Security_Segment_ResponseType|bool
     */
    public function Put_Recruiting_Assessment_Category_Security_Segment(\StructType\Put_Recruiting_Assessment_Category_Security_Segment_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Recruiting_Assessment_Category_Security_Segment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Maintain_Candidate_List_Assignment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Creates the default grid and the Job Requisition Rules with Candidate List Grid ConfigurationsNot Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Maintain_Candidate_List_Assignment_RequestType $body
     * @return \StructType\Put_Maintain_Candidate_List_Assignment_ResponseType|bool
     */
    public function Put_Maintain_Candidate_List_Assignment(\StructType\Put_Maintain_Candidate_List_Assignment_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Maintain_Candidate_List_Assignment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Site_Brand
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Adds or updates a brand with the information supplied in the request.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Site_Brand_RequestType $body
     * @return \StructType\Put_Site_Brand_ResponseType|bool
     */
    public function Put_Site_Brand(\StructType\Put_Site_Brand_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Site_Brand($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Job_Application_Template_Translation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Adds or updates translations for a job application templateNot Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Job_Application_Template_Translation_RequestType $body
     * @return \StructType\Put_Job_Application_Template_Translation_ResponseType|bool
     */
    public function Put_Job_Application_Template_Translation(\StructType\Put_Job_Application_Template_Translation_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Job_Application_Template_Translation($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Put_Masked_Recruiting_Configuration
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service adds or updates a Masked Recruiting Configuration with the information you supply in the web service request.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Masked_Recruiting_Configuration_RequestType $body
     * @return \StructType\Put_Masked_Recruiting_Configuration_ResponseType|bool
     */
    public function Put_Masked_Recruiting_Configuration(\StructType\Put_Masked_Recruiting_Configuration_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Masked_Recruiting_Configuration($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Masked_Job_Requisition_Default
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service to configure Masked Job Requisition Defaults.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Masked_Job_Requisition_Default_RequestType $body
     * @return \StructType\Put_Masked_Job_Requisition_Default_ResponseType|bool
     */
    public function Put_Masked_Job_Requisition_Default(\StructType\Put_Masked_Job_Requisition_Default_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Masked_Job_Requisition_Default($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Referee
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service operation to add or update Referees for a Reference Check Event. The Reference Check Event must be in progress, and cannot have a completed Manage Reference step.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Referee_RequestType $body
     * @return \StructType\Put_Referee_ResponseType|bool
     */
    public function Put_Referee(\StructType\Put_Referee_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Referee($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_External_Reference
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service operation to add or update External References for a Reference Check Event. The Reference Check Event must be in progress, and cannot have a completed Manage Reference step.Yes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_External_Reference_RequestType $body
     * @return \StructType\Put_External_Reference_ResponseType|bool
     */
    public function Put_External_Reference(\StructType\Put_External_Reference_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_External_Reference($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Put_Web_Conference_Interview_Data
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service operation to update interview data for the web conference.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Put_Web_Conference_Interview_Data_RequestType $body
     * @return \StructType\Put_Web_Conference_Interview_Data_ResponseType|bool
     */
    public function Put_Web_Conference_Interview_Data(\StructType\Put_Web_Conference_Interview_Data_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Put_Web_Conference_Interview_Data($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Put_Applicant_ResponseType|\StructType\Put_Background_Check_Package_ResponseType|\StructType\Put_Background_Check_ResponseType|\StructType\Put_Candidate_Attachment_ResponseType|\StructType\Put_Candidate_Photos_ResponseType|\StructType\Put_Candidate_ResponseType|\StructType\Put_External_Reference_ResponseType|\StructType\Put_Interview_Feedback_ResponseType|\StructType\Put_Interview_ResponseType|\StructType\Put_Job_Application_Additional_Data_ResponseType|\StructType\Put_Job_Application_Template_Translation_ResponseType|\StructType\Put_Job_Posting_Site_ResponseType|\StructType\Put_Job_Requisition_Interview_Settings_ResponseType|\StructType\Put_Maintain_Candidate_List_Assignment_ResponseType|\StructType\Put_Masked_Job_Requisition_Default_ResponseType|\StructType\Put_Masked_Recruiting_Configuration_ResponseType|\StructType\Put_Primary_Posting_ResponseType|\StructType\Put_Recruiting_Agency_Additional_Data_ResponseType|\StructType\Put_Recruiting_Agency_ResponseType|\StructType\Put_Recruiting_Agency_User_ResponseType|\StructType\Put_Recruiting_Assessment_Category_ResponseType|\StructType\Put_Recruiting_Assessment_Category_Security_Segment_ResponseType|\StructType\Put_Recruiting_Self_Schedule_Calendar_ResponseType|\StructType\Put_Recruiting_Self_Schedule_Calendar_Type_ResponseType|\StructType\Put_Referee_ResponseType|\StructType\Put_Site_Brand_ResponseType|\StructType\Put_Undo_Move_from_Hire_ResponseType|\StructType\Put_Veteran_Status_ResponseType|\StructType\Put_Web_Conference_Interview_Data_ResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
