<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Working_Hours_Details_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains working hours data for the position restriction.
 * @subpackage Structs
 */
class Working_Hours_Details_DataType extends AbstractStructBase
{
    /**
     * The Default_Hours
     * Meta information extracted from the WSDL
     * - documentation: The default weekly hours for the position restriction.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 5
     * @var float
     */
    public $Default_Hours;
    /**
     * The Scheduled_Hours
     * Meta information extracted from the WSDL
     * - documentation: The scheduled weekly hours for the position restriction.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 14
     * @var float
     */
    public $Scheduled_Hours;
    /**
     * Constructor method for Working_Hours_Details_DataType
     * @uses Working_Hours_Details_DataType::setDefault_Hours()
     * @uses Working_Hours_Details_DataType::setScheduled_Hours()
     * @param float $default_Hours
     * @param float $scheduled_Hours
     */
    public function __construct($default_Hours = null, $scheduled_Hours = null)
    {
        $this
            ->setDefault_Hours($default_Hours)
            ->setScheduled_Hours($scheduled_Hours);
    }
    /**
     * Get Default_Hours value
     * @return float|null
     */
    public function getDefault_Hours()
    {
        return $this->Default_Hours;
    }
    /**
     * Set Default_Hours value
     * @param float $default_Hours
     * @return \StructType\Working_Hours_Details_DataType
     */
    public function setDefault_Hours($default_Hours = null)
    {
        // validation for constraint: float
        if (!is_null($default_Hours) && !(is_float($default_Hours) || is_numeric($default_Hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($default_Hours, true), gettype($default_Hours)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($default_Hours) && mb_strlen(mb_substr($default_Hours, false !== mb_strpos($default_Hours, '.') ? mb_strpos($default_Hours, '.') + 1 : mb_strlen($default_Hours))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($default_Hours, true), mb_strlen(mb_substr($default_Hours, mb_strpos($default_Hours, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($default_Hours) && $default_Hours < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($default_Hours, true)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($default_Hours) && mb_strlen(preg_replace('/(\D)/', '', $default_Hours)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($default_Hours, true), mb_strlen(preg_replace('/(\D)/', '', $default_Hours))), __LINE__);
        }
        $this->Default_Hours = $default_Hours;
        return $this;
    }
    /**
     * Get Scheduled_Hours value
     * @return float|null
     */
    public function getScheduled_Hours()
    {
        return $this->Scheduled_Hours;
    }
    /**
     * Set Scheduled_Hours value
     * @param float $scheduled_Hours
     * @return \StructType\Working_Hours_Details_DataType
     */
    public function setScheduled_Hours($scheduled_Hours = null)
    {
        // validation for constraint: float
        if (!is_null($scheduled_Hours) && !(is_float($scheduled_Hours) || is_numeric($scheduled_Hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($scheduled_Hours, true), gettype($scheduled_Hours)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($scheduled_Hours) && mb_strlen(mb_substr($scheduled_Hours, false !== mb_strpos($scheduled_Hours, '.') ? mb_strpos($scheduled_Hours, '.') + 1 : mb_strlen($scheduled_Hours))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($scheduled_Hours, true), mb_strlen(mb_substr($scheduled_Hours, mb_strpos($scheduled_Hours, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(14)
        if (!is_null($scheduled_Hours) && mb_strlen(preg_replace('/(\D)/', '', $scheduled_Hours)) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 14 digits, "%d" given', var_export($scheduled_Hours, true), mb_strlen(preg_replace('/(\D)/', '', $scheduled_Hours))), __LINE__);
        }
        $this->Scheduled_Hours = $scheduled_Hours;
        return $this;
    }
}
