<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Web_Conference_Interview_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains interview data for the web conference.
 * @subpackage Structs
 */
class Web_Conference_Interview_DataType extends AbstractStructBase
{
    /**
     * The Interview_ID_Reference
     * Meta information extracted from the WSDL
     * - documentation: References interview data to retrieve.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Interview_ID_Reference;
    /**
     * The Interview_Time_Zone_Reference
     * Meta information extracted from the WSDL
     * - documentation: References the time zone associated with the interview.
     * - minOccurs: 0
     * @var \StructType\Time_ZoneObjectType
     */
    public $Interview_Time_Zone_Reference;
    /**
     * The Interview_Session_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains data for the interview session.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Web_Conference_Interview_Session_DataType[]
     */
    public $Interview_Session_Data;
    /**
     * The Web_Conference_Meeting_ID
     * Meta information extracted from the WSDL
     * - documentation: Web conference meeting ID associated with the interview.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Web_Conference_Meeting_ID;
    /**
     * The Web_Conference_Meeting_URL
     * Meta information extracted from the WSDL
     * - documentation: Web conference meeting URL associated with the interview.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Web_Conference_Meeting_URL;
    /**
     * Constructor method for Web_Conference_Interview_DataType
     * @uses Web_Conference_Interview_DataType::setInterview_ID_Reference()
     * @uses Web_Conference_Interview_DataType::setInterview_Time_Zone_Reference()
     * @uses Web_Conference_Interview_DataType::setInterview_Session_Data()
     * @uses Web_Conference_Interview_DataType::setWeb_Conference_Meeting_ID()
     * @uses Web_Conference_Interview_DataType::setWeb_Conference_Meeting_URL()
     * @param \StructType\Unique_IdentifierObjectType $interview_ID_Reference
     * @param \StructType\Time_ZoneObjectType $interview_Time_Zone_Reference
     * @param \StructType\Web_Conference_Interview_Session_DataType[] $interview_Session_Data
     * @param string $web_Conference_Meeting_ID
     * @param string $web_Conference_Meeting_URL
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $interview_ID_Reference = null, \StructType\Time_ZoneObjectType $interview_Time_Zone_Reference = null, array $interview_Session_Data = array(), $web_Conference_Meeting_ID = null, $web_Conference_Meeting_URL = null)
    {
        $this
            ->setInterview_ID_Reference($interview_ID_Reference)
            ->setInterview_Time_Zone_Reference($interview_Time_Zone_Reference)
            ->setInterview_Session_Data($interview_Session_Data)
            ->setWeb_Conference_Meeting_ID($web_Conference_Meeting_ID)
            ->setWeb_Conference_Meeting_URL($web_Conference_Meeting_URL);
    }
    /**
     * Get Interview_ID_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getInterview_ID_Reference()
    {
        return $this->Interview_ID_Reference;
    }
    /**
     * Set Interview_ID_Reference value
     * @param \StructType\Unique_IdentifierObjectType $interview_ID_Reference
     * @return \StructType\Web_Conference_Interview_DataType
     */
    public function setInterview_ID_Reference(\StructType\Unique_IdentifierObjectType $interview_ID_Reference = null)
    {
        $this->Interview_ID_Reference = $interview_ID_Reference;
        return $this;
    }
    /**
     * Get Interview_Time_Zone_Reference value
     * @return \StructType\Time_ZoneObjectType|null
     */
    public function getInterview_Time_Zone_Reference()
    {
        return $this->Interview_Time_Zone_Reference;
    }
    /**
     * Set Interview_Time_Zone_Reference value
     * @param \StructType\Time_ZoneObjectType $interview_Time_Zone_Reference
     * @return \StructType\Web_Conference_Interview_DataType
     */
    public function setInterview_Time_Zone_Reference(\StructType\Time_ZoneObjectType $interview_Time_Zone_Reference = null)
    {
        $this->Interview_Time_Zone_Reference = $interview_Time_Zone_Reference;
        return $this;
    }
    /**
     * Get Interview_Session_Data value
     * @return \StructType\Web_Conference_Interview_Session_DataType[]|null
     */
    public function getInterview_Session_Data()
    {
        return $this->Interview_Session_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setInterview_Session_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterview_Session_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInterview_Session_DataForArrayConstraintsFromSetInterview_Session_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $web_Conference_Interview_DataTypeInterview_Session_DataItem) {
            // validation for constraint: itemType
            if (!$web_Conference_Interview_DataTypeInterview_Session_DataItem instanceof \StructType\Web_Conference_Interview_Session_DataType) {
                $invalidValues[] = is_object($web_Conference_Interview_DataTypeInterview_Session_DataItem) ? get_class($web_Conference_Interview_DataTypeInterview_Session_DataItem) : sprintf('%s(%s)', gettype($web_Conference_Interview_DataTypeInterview_Session_DataItem), var_export($web_Conference_Interview_DataTypeInterview_Session_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Interview_Session_Data property can only contain items of type \StructType\Web_Conference_Interview_Session_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Interview_Session_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Web_Conference_Interview_Session_DataType[] $interview_Session_Data
     * @return \StructType\Web_Conference_Interview_DataType
     */
    public function setInterview_Session_Data(array $interview_Session_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($interview_Session_DataArrayErrorMessage = self::validateInterview_Session_DataForArrayConstraintsFromSetInterview_Session_Data($interview_Session_Data))) {
            throw new \InvalidArgumentException($interview_Session_DataArrayErrorMessage, __LINE__);
        }
        $this->Interview_Session_Data = $interview_Session_Data;
        return $this;
    }
    /**
     * Add item to Interview_Session_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Web_Conference_Interview_Session_DataType $item
     * @return \StructType\Web_Conference_Interview_DataType
     */
    public function addToInterview_Session_Data(\StructType\Web_Conference_Interview_Session_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Web_Conference_Interview_Session_DataType) {
            throw new \InvalidArgumentException(sprintf('The Interview_Session_Data property can only contain items of type \StructType\Web_Conference_Interview_Session_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Interview_Session_Data[] = $item;
        return $this;
    }
    /**
     * Get Web_Conference_Meeting_ID value
     * @return string|null
     */
    public function getWeb_Conference_Meeting_ID()
    {
        return $this->Web_Conference_Meeting_ID;
    }
    /**
     * Set Web_Conference_Meeting_ID value
     * @param string $web_Conference_Meeting_ID
     * @return \StructType\Web_Conference_Interview_DataType
     */
    public function setWeb_Conference_Meeting_ID($web_Conference_Meeting_ID = null)
    {
        // validation for constraint: string
        if (!is_null($web_Conference_Meeting_ID) && !is_string($web_Conference_Meeting_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_Conference_Meeting_ID, true), gettype($web_Conference_Meeting_ID)), __LINE__);
        }
        $this->Web_Conference_Meeting_ID = $web_Conference_Meeting_ID;
        return $this;
    }
    /**
     * Get Web_Conference_Meeting_URL value
     * @return string|null
     */
    public function getWeb_Conference_Meeting_URL()
    {
        return $this->Web_Conference_Meeting_URL;
    }
    /**
     * Set Web_Conference_Meeting_URL value
     * @param string $web_Conference_Meeting_URL
     * @return \StructType\Web_Conference_Interview_DataType
     */
    public function setWeb_Conference_Meeting_URL($web_Conference_Meeting_URL = null)
    {
        // validation for constraint: string
        if (!is_null($web_Conference_Meeting_URL) && !is_string($web_Conference_Meeting_URL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($web_Conference_Meeting_URL, true), gettype($web_Conference_Meeting_URL)), __LINE__);
        }
        $this->Web_Conference_Meeting_URL = $web_Conference_Meeting_URL;
        return $this;
    }
}
