<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Veteran_StatusType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains Veteran Status data.
 * @subpackage Structs
 */
class Veteran_StatusType extends AbstractStructBase
{
    /**
     * The Veteran_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Veteran Status.
     * - minOccurs: 0
     * @var \StructType\Veteran_StatusObjectType
     */
    public $Veteran_Status_Reference;
    /**
     * The Veteran_Status_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains Veteran Status data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Veteran_Status_DataType[]
     */
    public $Veteran_Status_Data;
    /**
     * Constructor method for Veteran_StatusType
     * @uses Veteran_StatusType::setVeteran_Status_Reference()
     * @uses Veteran_StatusType::setVeteran_Status_Data()
     * @param \StructType\Veteran_StatusObjectType $veteran_Status_Reference
     * @param \StructType\Veteran_Status_DataType[] $veteran_Status_Data
     */
    public function __construct(\StructType\Veteran_StatusObjectType $veteran_Status_Reference = null, array $veteran_Status_Data = array())
    {
        $this
            ->setVeteran_Status_Reference($veteran_Status_Reference)
            ->setVeteran_Status_Data($veteran_Status_Data);
    }
    /**
     * Get Veteran_Status_Reference value
     * @return \StructType\Veteran_StatusObjectType|null
     */
    public function getVeteran_Status_Reference()
    {
        return $this->Veteran_Status_Reference;
    }
    /**
     * Set Veteran_Status_Reference value
     * @param \StructType\Veteran_StatusObjectType $veteran_Status_Reference
     * @return \StructType\Veteran_StatusType
     */
    public function setVeteran_Status_Reference(\StructType\Veteran_StatusObjectType $veteran_Status_Reference = null)
    {
        $this->Veteran_Status_Reference = $veteran_Status_Reference;
        return $this;
    }
    /**
     * Get Veteran_Status_Data value
     * @return \StructType\Veteran_Status_DataType[]|null
     */
    public function getVeteran_Status_Data()
    {
        return $this->Veteran_Status_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setVeteran_Status_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVeteran_Status_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVeteran_Status_DataForArrayConstraintsFromSetVeteran_Status_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $veteran_StatusTypeVeteran_Status_DataItem) {
            // validation for constraint: itemType
            if (!$veteran_StatusTypeVeteran_Status_DataItem instanceof \StructType\Veteran_Status_DataType) {
                $invalidValues[] = is_object($veteran_StatusTypeVeteran_Status_DataItem) ? get_class($veteran_StatusTypeVeteran_Status_DataItem) : sprintf('%s(%s)', gettype($veteran_StatusTypeVeteran_Status_DataItem), var_export($veteran_StatusTypeVeteran_Status_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Veteran_Status_Data property can only contain items of type \StructType\Veteran_Status_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Veteran_Status_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Veteran_Status_DataType[] $veteran_Status_Data
     * @return \StructType\Veteran_StatusType
     */
    public function setVeteran_Status_Data(array $veteran_Status_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($veteran_Status_DataArrayErrorMessage = self::validateVeteran_Status_DataForArrayConstraintsFromSetVeteran_Status_Data($veteran_Status_Data))) {
            throw new \InvalidArgumentException($veteran_Status_DataArrayErrorMessage, __LINE__);
        }
        $this->Veteran_Status_Data = $veteran_Status_Data;
        return $this;
    }
    /**
     * Add item to Veteran_Status_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Veteran_Status_DataType $item
     * @return \StructType\Veteran_StatusType
     */
    public function addToVeteran_Status_Data(\StructType\Veteran_Status_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Veteran_Status_DataType) {
            throw new \InvalidArgumentException(sprintf('The Veteran_Status_Data property can only contain items of type \StructType\Veteran_Status_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Veteran_Status_Data[] = $item;
        return $this;
    }
}
