<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Update_Job_Posting_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data for individual Job Postings.
 * @subpackage Structs
 */
class Update_Job_Posting_DataType extends AbstractStructBase
{
    /**
     * The Job_Posting_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start date of the job posting. Must be after today.
     * - maxOccurs: 1
     * @var string
     */
    public $Job_Posting_Start_Date;
    /**
     * The Job_Posting_End_Date
     * Meta information extracted from the WSDL
     * - documentation: End date of the Job Posting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Job_Posting_End_Date;
    /**
     * Constructor method for Update_Job_Posting_DataType
     * @uses Update_Job_Posting_DataType::setJob_Posting_Start_Date()
     * @uses Update_Job_Posting_DataType::setJob_Posting_End_Date()
     * @param string $job_Posting_Start_Date
     * @param string $job_Posting_End_Date
     */
    public function __construct($job_Posting_Start_Date = null, $job_Posting_End_Date = null)
    {
        $this
            ->setJob_Posting_Start_Date($job_Posting_Start_Date)
            ->setJob_Posting_End_Date($job_Posting_End_Date);
    }
    /**
     * Get Job_Posting_Start_Date value
     * @return string|null
     */
    public function getJob_Posting_Start_Date()
    {
        return $this->Job_Posting_Start_Date;
    }
    /**
     * Set Job_Posting_Start_Date value
     * @param string $job_Posting_Start_Date
     * @return \StructType\Update_Job_Posting_DataType
     */
    public function setJob_Posting_Start_Date($job_Posting_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_Start_Date) && !is_string($job_Posting_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_Start_Date, true), gettype($job_Posting_Start_Date)), __LINE__);
        }
        $this->Job_Posting_Start_Date = $job_Posting_Start_Date;
        return $this;
    }
    /**
     * Get Job_Posting_End_Date value
     * @return string|null
     */
    public function getJob_Posting_End_Date()
    {
        return $this->Job_Posting_End_Date;
    }
    /**
     * Set Job_Posting_End_Date value
     * @param string $job_Posting_End_Date
     * @return \StructType\Update_Job_Posting_DataType
     */
    public function setJob_Posting_End_Date($job_Posting_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($job_Posting_End_Date) && !is_string($job_Posting_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($job_Posting_End_Date, true), gettype($job_Posting_End_Date)), __LINE__);
        }
        $this->Job_Posting_End_Date = $job_Posting_End_Date;
        return $this;
    }
}
