<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Translated_Configurable_Field_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains base and translated values for each configurable section
 * @subpackage Structs
 */
class Translated_Configurable_Field_DataType extends AbstractStructBase
{
    /**
     * The Configurable_Field_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference ID or WID of the configurable section
     * @var \StructType\External_Identification_Point__XIP_ObjectType
     */
    public $Configurable_Field_Reference;
    /**
     * The Label_Override_Base_Value
     * Meta information extracted from the WSDL
     * - documentation: View-only base value of label override
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Label_Override_Base_Value;
    /**
     * The Label_Override_Translated_Value
     * Meta information extracted from the WSDL
     * - documentation: Translated label override value
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Label_Override_Translated_Value;
    /**
     * The Instructional_Text_Based_Value
     * Meta information extracted from the WSDL
     * - documentation: View-only base value of instructional text
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Instructional_Text_Based_Value;
    /**
     * The Instructional_Text_Translated_Rich_Value
     * Meta information extracted from the WSDL
     * - documentation: Translated instructional text value
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Instructional_Text_Translated_Rich_Value;
    /**
     * Constructor method for Translated_Configurable_Field_DataType
     * @uses Translated_Configurable_Field_DataType::setConfigurable_Field_Reference()
     * @uses Translated_Configurable_Field_DataType::setLabel_Override_Base_Value()
     * @uses Translated_Configurable_Field_DataType::setLabel_Override_Translated_Value()
     * @uses Translated_Configurable_Field_DataType::setInstructional_Text_Based_Value()
     * @uses Translated_Configurable_Field_DataType::setInstructional_Text_Translated_Rich_Value()
     * @param \StructType\External_Identification_Point__XIP_ObjectType $configurable_Field_Reference
     * @param string $label_Override_Base_Value
     * @param string $label_Override_Translated_Value
     * @param string $instructional_Text_Based_Value
     * @param string $instructional_Text_Translated_Rich_Value
     */
    public function __construct(\StructType\External_Identification_Point__XIP_ObjectType $configurable_Field_Reference = null, $label_Override_Base_Value = null, $label_Override_Translated_Value = null, $instructional_Text_Based_Value = null, $instructional_Text_Translated_Rich_Value = null)
    {
        $this
            ->setConfigurable_Field_Reference($configurable_Field_Reference)
            ->setLabel_Override_Base_Value($label_Override_Base_Value)
            ->setLabel_Override_Translated_Value($label_Override_Translated_Value)
            ->setInstructional_Text_Based_Value($instructional_Text_Based_Value)
            ->setInstructional_Text_Translated_Rich_Value($instructional_Text_Translated_Rich_Value);
    }
    /**
     * Get Configurable_Field_Reference value
     * @return \StructType\External_Identification_Point__XIP_ObjectType|null
     */
    public function getConfigurable_Field_Reference()
    {
        return $this->Configurable_Field_Reference;
    }
    /**
     * Set Configurable_Field_Reference value
     * @param \StructType\External_Identification_Point__XIP_ObjectType $configurable_Field_Reference
     * @return \StructType\Translated_Configurable_Field_DataType
     */
    public function setConfigurable_Field_Reference(\StructType\External_Identification_Point__XIP_ObjectType $configurable_Field_Reference = null)
    {
        $this->Configurable_Field_Reference = $configurable_Field_Reference;
        return $this;
    }
    /**
     * Get Label_Override_Base_Value value
     * @return string|null
     */
    public function getLabel_Override_Base_Value()
    {
        return $this->Label_Override_Base_Value;
    }
    /**
     * Set Label_Override_Base_Value value
     * @param string $label_Override_Base_Value
     * @return \StructType\Translated_Configurable_Field_DataType
     */
    public function setLabel_Override_Base_Value($label_Override_Base_Value = null)
    {
        // validation for constraint: string
        if (!is_null($label_Override_Base_Value) && !is_string($label_Override_Base_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label_Override_Base_Value, true), gettype($label_Override_Base_Value)), __LINE__);
        }
        $this->Label_Override_Base_Value = $label_Override_Base_Value;
        return $this;
    }
    /**
     * Get Label_Override_Translated_Value value
     * @return string|null
     */
    public function getLabel_Override_Translated_Value()
    {
        return $this->Label_Override_Translated_Value;
    }
    /**
     * Set Label_Override_Translated_Value value
     * @param string $label_Override_Translated_Value
     * @return \StructType\Translated_Configurable_Field_DataType
     */
    public function setLabel_Override_Translated_Value($label_Override_Translated_Value = null)
    {
        // validation for constraint: string
        if (!is_null($label_Override_Translated_Value) && !is_string($label_Override_Translated_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label_Override_Translated_Value, true), gettype($label_Override_Translated_Value)), __LINE__);
        }
        $this->Label_Override_Translated_Value = $label_Override_Translated_Value;
        return $this;
    }
    /**
     * Get Instructional_Text_Based_Value value
     * @return string|null
     */
    public function getInstructional_Text_Based_Value()
    {
        return $this->Instructional_Text_Based_Value;
    }
    /**
     * Set Instructional_Text_Based_Value value
     * @param string $instructional_Text_Based_Value
     * @return \StructType\Translated_Configurable_Field_DataType
     */
    public function setInstructional_Text_Based_Value($instructional_Text_Based_Value = null)
    {
        // validation for constraint: string
        if (!is_null($instructional_Text_Based_Value) && !is_string($instructional_Text_Based_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instructional_Text_Based_Value, true), gettype($instructional_Text_Based_Value)), __LINE__);
        }
        $this->Instructional_Text_Based_Value = $instructional_Text_Based_Value;
        return $this;
    }
    /**
     * Get Instructional_Text_Translated_Rich_Value value
     * @return string|null
     */
    public function getInstructional_Text_Translated_Rich_Value()
    {
        return $this->Instructional_Text_Translated_Rich_Value;
    }
    /**
     * Set Instructional_Text_Translated_Rich_Value value
     * @param string $instructional_Text_Translated_Rich_Value
     * @return \StructType\Translated_Configurable_Field_DataType
     */
    public function setInstructional_Text_Translated_Rich_Value($instructional_Text_Translated_Rich_Value = null)
    {
        // validation for constraint: string
        if (!is_null($instructional_Text_Translated_Rich_Value) && !is_string($instructional_Text_Translated_Rich_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instructional_Text_Translated_Rich_Value, true), gettype($instructional_Text_Translated_Rich_Value)), __LINE__);
        }
        $this->Instructional_Text_Translated_Rich_Value = $instructional_Text_Translated_Rich_Value;
        return $this;
    }
}
