<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Role_Assignment_Effective_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for a Organization Role Assignment
 * @subpackage Structs
 */
class Role_Assignment_Effective_DataType extends AbstractStructBase
{
    /**
     * The Role_Assignment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Workday ID for Role Assignment.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Role_Assignment_Reference;
    /**
     * The Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: The Effective Date of the Assigned, Defaulted, or Inherited Role Assignment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Effective_Date;
    /**
     * The Role_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Organization Role being assigned.
     * - minOccurs: 0
     * @var \StructType\Assignable_RoleObjectType
     */
    public $Role_Reference;
    /**
     * The Role_Assignee_Reference
     * Meta information extracted from the WSDL
     * - documentation: The position assigned to this role assignment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoleeObjectType[]
     */
    public $Role_Assignee_Reference;
    /**
     * Constructor method for Role_Assignment_Effective_DataType
     * @uses Role_Assignment_Effective_DataType::setRole_Assignment_Reference()
     * @uses Role_Assignment_Effective_DataType::setEffective_Date()
     * @uses Role_Assignment_Effective_DataType::setRole_Reference()
     * @uses Role_Assignment_Effective_DataType::setRole_Assignee_Reference()
     * @param \StructType\Unique_IdentifierObjectType $role_Assignment_Reference
     * @param string $effective_Date
     * @param \StructType\Assignable_RoleObjectType $role_Reference
     * @param \StructType\RoleeObjectType[] $role_Assignee_Reference
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $role_Assignment_Reference = null, $effective_Date = null, \StructType\Assignable_RoleObjectType $role_Reference = null, array $role_Assignee_Reference = array())
    {
        $this
            ->setRole_Assignment_Reference($role_Assignment_Reference)
            ->setEffective_Date($effective_Date)
            ->setRole_Reference($role_Reference)
            ->setRole_Assignee_Reference($role_Assignee_Reference);
    }
    /**
     * Get Role_Assignment_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getRole_Assignment_Reference()
    {
        return $this->Role_Assignment_Reference;
    }
    /**
     * Set Role_Assignment_Reference value
     * @param \StructType\Unique_IdentifierObjectType $role_Assignment_Reference
     * @return \StructType\Role_Assignment_Effective_DataType
     */
    public function setRole_Assignment_Reference(\StructType\Unique_IdentifierObjectType $role_Assignment_Reference = null)
    {
        $this->Role_Assignment_Reference = $role_Assignment_Reference;
        return $this;
    }
    /**
     * Get Effective_Date value
     * @return string|null
     */
    public function getEffective_Date()
    {
        return $this->Effective_Date;
    }
    /**
     * Set Effective_Date value
     * @param string $effective_Date
     * @return \StructType\Role_Assignment_Effective_DataType
     */
    public function setEffective_Date($effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($effective_Date) && !is_string($effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effective_Date, true), gettype($effective_Date)), __LINE__);
        }
        $this->Effective_Date = $effective_Date;
        return $this;
    }
    /**
     * Get Role_Reference value
     * @return \StructType\Assignable_RoleObjectType|null
     */
    public function getRole_Reference()
    {
        return $this->Role_Reference;
    }
    /**
     * Set Role_Reference value
     * @param \StructType\Assignable_RoleObjectType $role_Reference
     * @return \StructType\Role_Assignment_Effective_DataType
     */
    public function setRole_Reference(\StructType\Assignable_RoleObjectType $role_Reference = null)
    {
        $this->Role_Reference = $role_Reference;
        return $this;
    }
    /**
     * Get Role_Assignee_Reference value
     * @return \StructType\RoleeObjectType[]|null
     */
    public function getRole_Assignee_Reference()
    {
        return $this->Role_Assignee_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRole_Assignee_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRole_Assignee_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRole_Assignee_ReferenceForArrayConstraintsFromSetRole_Assignee_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $role_Assignment_Effective_DataTypeRole_Assignee_ReferenceItem) {
            // validation for constraint: itemType
            if (!$role_Assignment_Effective_DataTypeRole_Assignee_ReferenceItem instanceof \StructType\RoleeObjectType) {
                $invalidValues[] = is_object($role_Assignment_Effective_DataTypeRole_Assignee_ReferenceItem) ? get_class($role_Assignment_Effective_DataTypeRole_Assignee_ReferenceItem) : sprintf('%s(%s)', gettype($role_Assignment_Effective_DataTypeRole_Assignee_ReferenceItem), var_export($role_Assignment_Effective_DataTypeRole_Assignee_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Role_Assignee_Reference property can only contain items of type \StructType\RoleeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Role_Assignee_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\RoleeObjectType[] $role_Assignee_Reference
     * @return \StructType\Role_Assignment_Effective_DataType
     */
    public function setRole_Assignee_Reference(array $role_Assignee_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($role_Assignee_ReferenceArrayErrorMessage = self::validateRole_Assignee_ReferenceForArrayConstraintsFromSetRole_Assignee_Reference($role_Assignee_Reference))) {
            throw new \InvalidArgumentException($role_Assignee_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Role_Assignee_Reference = $role_Assignee_Reference;
        return $this;
    }
    /**
     * Add item to Role_Assignee_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\RoleeObjectType $item
     * @return \StructType\Role_Assignment_Effective_DataType
     */
    public function addToRole_Assignee_Reference(\StructType\RoleeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoleeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Role_Assignee_Reference property can only contain items of type \StructType\RoleeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Role_Assignee_Reference[] = $item;
        return $this;
    }
}
