<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Responsibility_Profile_for_Job_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the responsibility profile's information for a position.
 * @subpackage Structs
 */
class Responsibility_Profile_for_Job_DataType extends AbstractStructBase
{
    /**
     * The Responsibility
     * Meta information extracted from the WSDL
     * - documentation: The description of the Responsibility.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Responsibility;
    /**
     * The Required
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the profile is required for this position.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Required;
    /**
     * The Qualification_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: The source (job profile or position) reference from which the qualification came from.
     * - minOccurs: 0
     * @var \StructType\Talent_Qualification_EnabledObjectType
     */
    public $Qualification_Source_Reference;
    /**
     * Constructor method for Responsibility_Profile_for_Job_DataType
     * @uses Responsibility_Profile_for_Job_DataType::setResponsibility()
     * @uses Responsibility_Profile_for_Job_DataType::setRequired()
     * @uses Responsibility_Profile_for_Job_DataType::setQualification_Source_Reference()
     * @param string $responsibility
     * @param bool $required
     * @param \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference
     */
    public function __construct($responsibility = null, $required = null, \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference = null)
    {
        $this
            ->setResponsibility($responsibility)
            ->setRequired($required)
            ->setQualification_Source_Reference($qualification_Source_Reference);
    }
    /**
     * Get Responsibility value
     * @return string|null
     */
    public function getResponsibility()
    {
        return $this->Responsibility;
    }
    /**
     * Set Responsibility value
     * @param string $responsibility
     * @return \StructType\Responsibility_Profile_for_Job_DataType
     */
    public function setResponsibility($responsibility = null)
    {
        // validation for constraint: string
        if (!is_null($responsibility) && !is_string($responsibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responsibility, true), gettype($responsibility)), __LINE__);
        }
        $this->Responsibility = $responsibility;
        return $this;
    }
    /**
     * Get Required value
     * @return bool|null
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param bool $required
     * @return \StructType\Responsibility_Profile_for_Job_DataType
     */
    public function setRequired($required = null)
    {
        // validation for constraint: boolean
        if (!is_null($required) && !is_bool($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required, true), gettype($required)), __LINE__);
        }
        $this->Required = $required;
        return $this;
    }
    /**
     * Get Qualification_Source_Reference value
     * @return \StructType\Talent_Qualification_EnabledObjectType|null
     */
    public function getQualification_Source_Reference()
    {
        return $this->Qualification_Source_Reference;
    }
    /**
     * Set Qualification_Source_Reference value
     * @param \StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference
     * @return \StructType\Responsibility_Profile_for_Job_DataType
     */
    public function setQualification_Source_Reference(\StructType\Talent_Qualification_EnabledObjectType $qualification_Source_Reference = null)
    {
        $this->Qualification_Source_Reference = $qualification_Source_Reference;
        return $this;
    }
}
