<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Referee_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The referees for this reference check.
 * @subpackage Structs
 */
class Referee_Response_DataType extends AbstractStructBase
{
    /**
     * The Referee
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RefereeType[]
     */
    public $Referee;
    /**
     * Constructor method for Referee_Response_DataType
     * @uses Referee_Response_DataType::setReferee()
     * @param \StructType\RefereeType[] $referee
     */
    public function __construct(array $referee = array())
    {
        $this
            ->setReferee($referee);
    }
    /**
     * Get Referee value
     * @return \StructType\RefereeType[]|null
     */
    public function getReferee()
    {
        return $this->Referee;
    }
    /**
     * This method is responsible for validating the values passed to the setReferee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRefereeForArrayConstraintsFromSetReferee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $referee_Response_DataTypeRefereeItem) {
            // validation for constraint: itemType
            if (!$referee_Response_DataTypeRefereeItem instanceof \StructType\RefereeType) {
                $invalidValues[] = is_object($referee_Response_DataTypeRefereeItem) ? get_class($referee_Response_DataTypeRefereeItem) : sprintf('%s(%s)', gettype($referee_Response_DataTypeRefereeItem), var_export($referee_Response_DataTypeRefereeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Referee property can only contain items of type \StructType\RefereeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Referee value
     * @throws \InvalidArgumentException
     * @param \StructType\RefereeType[] $referee
     * @return \StructType\Referee_Response_DataType
     */
    public function setReferee(array $referee = array())
    {
        // validation for constraint: array
        if ('' !== ($refereeArrayErrorMessage = self::validateRefereeForArrayConstraintsFromSetReferee($referee))) {
            throw new \InvalidArgumentException($refereeArrayErrorMessage, __LINE__);
        }
        $this->Referee = $referee;
        return $this;
    }
    /**
     * Add item to Referee value
     * @throws \InvalidArgumentException
     * @param \StructType\RefereeType $item
     * @return \StructType\Referee_Response_DataType
     */
    public function addToReferee(\StructType\RefereeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RefereeType) {
            throw new \InvalidArgumentException(sprintf('The Referee property can only contain items of type \StructType\RefereeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Referee[] = $item;
        return $this;
    }
}
